/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.data;

import it.businesslogic.ireport.gui.JRSQLExpressionArea;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.Connection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.QueryModel;
import nickyb.sqleonardo.querybuilder.syntax.SQLParser;

public class QueryBuilderDialog
extends JDialog {
    private String query = null;
    private int dialogResult = 2;
    private boolean init = false;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JPanel jPanel1;
    private JRSQLExpressionArea jRSQLExpressionArea1;
    private JTabbedPane jTabbedPane1;
    private QueryBuilder queryBuilder1;

    public QueryBuilderDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public QueryBuilderDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void applyI18n() {
        this.jTabbedPane1.setTitleAt(0, I18n.getString("application.builder", "Builder"));
        this.jTabbedPane1.setTitleAt(1, I18n.getString("application.syntax", "SQL"));
        this.jButtonOk.setText(I18n.getString("ok", "Ok"));
        this.jButtonCancel.setText(I18n.getString("cancel", "jButtonCancel"));
    }

    private void initAll() {
        this.setInit(true);
        this.initComponents();
        this.applyI18n();
        this.setInit(false);
        Misc.centerFrame(this);
    }

    public void setConnection(Connection c) {
        this.queryBuilder1.setConnection(c);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.queryBuilder1 = new QueryBuilder();
        this.jRSQLExpressionArea1 = new JRSQLExpressionArea();
        this.jPanel1 = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.jTabbedPane1.setTabPlacement(3);
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                QueryBuilderDialog.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.queryBuilder1.setPreferredSize(new Dimension(600, 483));
        this.jTabbedPane1.addTab("Design", (Component)this.queryBuilder1);
        this.jRSQLExpressionArea1.setBorder(BorderFactory.createEtchedBorder());
        this.jRSQLExpressionArea1.setMinimumSize(new Dimension(50, 200));
        this.jRSQLExpressionArea1.setPreferredSize(new Dimension(661, 340));
        this.jTabbedPane1.addTab("SQL", this.jRSQLExpressionArea1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButtonOk.setText("Ok");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryBuilderDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.jPanel1.add((Component)this.jButtonOk, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryBuilderDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (this.isInit()) {
            return;
        }
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            String msql = this.queryBuilder1.getModel().toString(true);
            String tsql = this.jRSQLExpressionArea1.getText();
            if (!tsql.equals(msql) && JOptionPane.showConfirmDialog(this, I18n.getString("application.syntaxChanged", "syntax changed!\ndo you want to apply changes (builder need to reload)?")) == 0) {
                new Thread(new Runnable(){

                    public void run() {
                        while (!QueryBuilderDialog.this.queryBuilder1.isVisible()) {
                        }
                        try {
                            QueryModel qm = SQLParser.toQueryModel((String)QueryBuilderDialog.this.jRSQLExpressionArea1.getText());
                            QueryBuilderDialog.this.queryBuilder1.setModel(qm);
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(QueryBuilderDialog.this, I18n.getString("errorParsingSQL", "I'm sorry, I'm unable to parse the query..."));
                            QueryBuilderDialog.this.jTabbedPane1.setSelectedIndex(0);
                        }
                    }
                }).start();
            }
        } else {
            try {
                this.jRSQLExpressionArea1.setText(this.queryBuilder1.getModel().toString(true));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.query = this.jTabbedPane1.getSelectedIndex() == 0 ? this.queryBuilder1.getModel().toString(true) : this.jRSQLExpressionArea1.getText();
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) throws Exception {
        final QueryModel qm = SQLParser.toQueryModel((String)query);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (QueryBuilderDialog.this.isVisible()) {
                    QueryBuilderDialog.this.queryBuilder1.setModel(qm);
                }
            }
        });
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }
}

