/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.drag;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.defaults.DefaultDockingPort;
import org.flexdock.docking.drag.DragGlasspane;
import org.flexdock.docking.drag.DragManager;
import org.flexdock.docking.drag.DragOperation;
import org.flexdock.docking.drag.effects.EffectsManager;
import org.flexdock.docking.drag.effects.RubberBand;
import org.flexdock.logging.Log;
import org.flexdock.util.RootWindow;
import org.flexdock.util.SwingUtility;
import org.flexdock.util.Utilities;

public class DragPipeline {
    private GlassPaneMonitor paneMonitor = new GlassPaneMonitor();
    private RootWindow[] windows;
    private HashMap rootWindowsByBounds;
    private DragGlasspane currentGlasspane;
    private DragGlasspane newGlassPane;
    private Rectangle[] windowBounds;
    private boolean heavyweightDockableSupportted;
    private boolean open;
    private DragOperation dragToken;
    private RubberBand rubberBand = EffectsManager.getRubberBand();

    public boolean isOpen() {
        return this.open;
    }

    public void open(DragOperation token) {
        if (token == null) {
            throw new NullPointerException("'token' parameter cannot be null.");
        }
        if (EventQueue.isDispatchThread()) {
            this.openImpl(token);
            return;
        }
        final DragOperation dToken = token;
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    DragPipeline.this.openImpl(dToken);
                }
            });
        }
        catch (Exception e) {
            Log.warn(e.getMessage(), e);
        }
    }

    private void openImpl(DragOperation operation) {
        this.heavyweightDockableSupportted = Utilities.sysTrue("heavyweight.dockables");
        this.dragToken = operation;
        this.setCurrentDragOperation(operation);
        this.windows = RootWindow.getVisibleWindows();
        this.windowBounds = new Rectangle[this.windows.length];
        this.rootWindowsByBounds = new HashMap();
        for (int i = 0; i < this.windows.length; ++i) {
            this.applyGlassPane(this.windows[i], this.createGlassPane());
            this.windowBounds[i] = this.windows[i].getBounds();
            this.rootWindowsByBounds.put(this.windowBounds[i], this.windows[i]);
        }
        if (!DragManager.isFloatingAllowed(operation.getDockableReference())) {
            this.rubberBand = null;
        }
        operation.start();
        this.open = true;
    }

    private DragGlasspane createGlassPane() {
        DragGlasspane pane = new DragGlasspane();
        pane.addMouseListener(this.paneMonitor);
        return pane;
    }

    private void applyGlassPane(RootWindow win, DragGlasspane pane) {
        pane.setRootWindow(win);
        pane.setCachedGlassPane(win.getGlassPane());
        win.setGlassPane(pane);
        pane.setVisible(true);
    }

    public void close() {
        if (!this.open) {
            return;
        }
        this.clearRubberBand();
        for (int i = 0; i < this.windows.length; ++i) {
            Component cmp = this.windows[i].getGlassPane();
            if (!(cmp instanceof DragGlasspane)) continue;
            DragGlasspane pane = (DragGlasspane)cmp;
            pane.setVisible(false);
            cmp = pane.getCachedGlassPane();
            this.windows[i].setGlassPane(cmp);
            this.windows[i] = null;
        }
        this.windowBounds = null;
        this.rootWindowsByBounds.clear();
        this.setCurrentDragOperation(null);
        this.open = false;
    }

    public void processDragEvent(MouseEvent me) {
        if (!this.open) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.processDragEventImpl(me);
            return;
        }
        final MouseEvent evt = me;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DragPipeline.this.processDragEventImpl(evt);
            }
        });
    }

    private void processDragEventImpl(MouseEvent me) {
        this.dragToken.updateMouse(me);
        if (this.heavyweightDockableSupportted) {
            this.preprocessHeavyweightDockables();
        }
        me.consume();
        this.clearRubberBand();
        this.dragToken.setOverWindow(this.newGlassPane != null);
        if (this.newGlassPane == this.currentGlasspane) {
            this.dontSwitchGlassPanes();
            return;
        }
        if (this.newGlassPane == null) {
            this.transitionToNullArea();
            return;
        }
        if (this.currentGlasspane == null) {
            this.transitionFromNullArea(this.newGlassPane);
            return;
        }
        this.currentGlasspane.clear();
        this.currentGlasspane = this.newGlassPane;
        Rectangle screenRect = this.dragToken.getDragRect(true);
        this.currentGlasspane.setPostPainter(this.getPostPainter(screenRect));
        this.currentGlasspane.processDragEvent(this.dragToken);
    }

    private void dontSwitchGlassPanes() {
        Rectangle screenRect = this.dragToken.getDragRect(true);
        if (this.currentGlasspane == null) {
            this.drawRubberBand(screenRect);
            return;
        }
        this.currentGlasspane.setPostPainter(null);
        this.currentGlasspane.processDragEvent(this.dragToken);
    }

    private void transitionToNullArea() {
        DragGlasspane pane = this.currentGlasspane;
        this.currentGlasspane = null;
        Rectangle screenRect = this.dragToken.getDragRect(true);
        pane.setPostPainter(null);
        pane.clear();
    }

    private void transitionFromNullArea(DragGlasspane newGlassPane) {
        this.currentGlasspane = newGlassPane;
        Rectangle screenRect = this.dragToken.getDragRect(true);
        this.currentGlasspane.setPostPainter(null);
        this.currentGlasspane.processDragEvent(this.dragToken);
    }

    private void setCurrentGlassPane(DragGlasspane gp) {
        this.newGlassPane = gp;
    }

    private Runnable getPostPainter(final Rectangle rect) {
        return new Runnable(){

            public void run() {
                DragPipeline.this.deferRubberBandDrawing(rect);
            }
        };
    }

    private void deferRubberBandDrawing(final Rectangle rect) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DragPipeline.this.drawRubberBand(rect);
            }
        });
    }

    private void drawRubberBand(Rectangle rect) {
        this.paintRubberBand(rect);
    }

    public DragOperation getDragToken() {
        return this.dragToken;
    }

    private void clearRubberBand() {
        if (this.rubberBand != null) {
            this.rubberBand.clear();
        }
    }

    private void paintRubberBand(Rectangle rect) {
        if (this.rubberBand != null) {
            this.rubberBand.paint(rect);
        }
    }

    private void setCurrentDragOperation(DragOperation operation) {
        DragOperation current = DragManager.getCurrentDragOperation();
        if (operation == current) {
            return;
        }
        DockingPort srcPort = operation == null ? current.getSourcePort() : operation.getSourcePort();
        DragManager.setCurrentDragOperation(operation);
        if (srcPort instanceof Component) {
            SwingUtility.repaint((Component)((Object)srcPort));
        }
        if (srcPort instanceof DefaultDockingPort) {
            DefaultDockingPort port = (DefaultDockingPort)srcPort;
            port.setDragInProgress(operation != null);
        }
    }

    private void preprocessHeavyweightDockables() {
        Component gp;
        RootWindow targetWindow = this.getTargetWindow();
        if (this.newGlassPane == null && targetWindow != null && (gp = targetWindow.getGlassPane()) instanceof DragGlasspane) {
            this.setCurrentGlassPane((DragGlasspane)gp);
        }
    }

    private RootWindow getTargetWindow() {
        Point screenLoc = this.dragToken.getCurrentMouse(true);
        for (int i = 0; i < this.windowBounds.length; ++i) {
            if (!this.windowBounds[i].contains(screenLoc)) continue;
            return (RootWindow)this.rootWindowsByBounds.get(this.windowBounds[i]);
        }
        return null;
    }

    private class GlassPaneMonitor
    extends MouseAdapter {
        private GlassPaneMonitor() {
        }

        public void mouseEntered(MouseEvent me) {
            Object obj = me.getSource();
            if (obj instanceof DragGlasspane) {
                DragPipeline.this.setCurrentGlassPane((DragGlasspane)obj);
            }
        }

        public void mouseExited(MouseEvent me) {
            DragPipeline.this.setCurrentGlassPane(null);
        }
    }
}

