/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

public final class SAFER {
    public static final int SK128_VARIANT = 0;
    public static final int SK64_VARIANT = 1;
    public static final int K128_VARIANT = 2;
    public static final int K64_VARIANT = 3;
    private static final int SK128_DEFAULT_NOF_ROUNDS = 10;
    private static final int MAX_NOF_ROUNDS = 13;
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 217;
    private static final int TAB_LEN = 256;
    private int[] sKey = new int[217];
    private int rounds = 13;
    private static final int[] EXP = new int[256];
    private static final int[] LOG = new int[256];
    private boolean encryptIfTrue = false;
    private boolean weak = false;

    static {
        int exp = 1;
        int i = 0;
        while (i < 256) {
            SAFER.EXP[i] = exp & 0xFF;
            SAFER.LOG[SAFER.EXP[i]] = i;
            exp = exp * 45 % 257;
            ++i;
        }
    }

    protected final void finalize() {
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 8;
    }

    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        if (inLen < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int blockCount = inLen / 8;
        inLen = blockCount * 8;
        boolean doEncrypt = this.encryptIfTrue;
        if (in == out && (outOffset >= inOffset && (long)outOffset < (long)inOffset + (long)inLen || inOffset >= outOffset && (long)inOffset < (long)outOffset + (long)inLen)) {
            byte[] newin = new byte[inLen];
            System.arraycopy(in, inOffset, newin, 0, inLen);
            in = newin;
            inOffset = 0;
        }
        if (doEncrypt) {
            int i = 0;
            while (i < blockCount) {
                this.blockEncrypt(in, inOffset, out, outOffset);
                inOffset += 8;
                outOffset += 8;
                ++i;
            }
        } else {
            int i = 0;
            while (i < blockCount) {
                this.blockDecrypt(in, inOffset, out, outOffset);
                inOffset += 8;
                outOffset += 8;
                ++i;
            }
        }
        return inLen;
    }

    public void blockEncrypt(byte[] in, int inOff, byte[] out, int outOff) {
        int round;
        int k = 0;
        if (13 < (round = this.sKey[k++])) {
            round = 13;
        }
        int a = in[inOff++];
        int b = in[inOff++];
        int c = in[inOff++];
        int d = in[inOff++];
        int e = in[inOff++];
        int f = in[inOff++];
        int g = in[inOff++];
        int h = in[inOff++];
        int i = 0;
        while (i < round) {
            a ^= this.sKey[k++];
            b += this.sKey[k++];
            c += this.sKey[k++];
            d ^= this.sKey[k++];
            e ^= this.sKey[k++];
            f += this.sKey[k++];
            g += this.sKey[k++];
            h ^= this.sKey[k++];
            a = EXP[a & 0xFF] + this.sKey[k++];
            b = LOG[b & 0xFF] ^ this.sKey[k++];
            c = LOG[c & 0xFF] ^ this.sKey[k++];
            d = EXP[d & 0xFF] + this.sKey[k++];
            e = EXP[e & 0xFF] + this.sKey[k++];
            f = LOG[f & 0xFF] ^ this.sKey[k++];
            g = LOG[g & 0xFF] ^ this.sKey[k++];
            h = EXP[h & 0xFF] + this.sKey[k++];
            b += a;
            a += b;
            d += c;
            c += d;
            f += e;
            h += g;
            g += h;
            c += a;
            a += c;
            g += (e += f);
            e += g;
            d += b;
            h += f;
            f += h;
            e += a;
            a += e;
            f += (b += d);
            g += c;
            h += d;
            int t = b += f;
            b = e;
            e = c += g;
            c = t;
            t = d += h;
            d = f;
            f = g;
            g = t;
            ++i;
        }
        out[outOff++] = (byte)(a ^ this.sKey[k++]);
        out[outOff++] = (byte)(b + this.sKey[k++]);
        out[outOff++] = (byte)(c + this.sKey[k++]);
        out[outOff++] = (byte)(d ^ this.sKey[k++]);
        out[outOff++] = (byte)(e ^ this.sKey[k++]);
        out[outOff++] = (byte)(f + this.sKey[k++]);
        out[outOff++] = (byte)(g + this.sKey[k++]);
        out[outOff++] = (byte)(h ^ this.sKey[k++]);
    }

    public void blockDecrypt(byte[] in, int inOff, byte[] out, int outOff) {
        int round = this.sKey[0];
        if (13 < round) {
            round = 13;
        }
        int a = in[inOff++];
        int b = in[inOff++];
        int c = in[inOff++];
        int d = in[inOff++];
        int e = in[inOff++];
        int f = in[inOff++];
        int g = in[inOff++];
        int h = in[inOff++];
        int k = 8 * (1 + 2 * round);
        h ^= this.sKey[k];
        g -= this.sKey[--k];
        f -= this.sKey[--k];
        e ^= this.sKey[--k];
        d ^= this.sKey[--k];
        c -= this.sKey[--k];
        b -= this.sKey[--k];
        a ^= this.sKey[--k];
        int i = 0;
        while (i < round) {
            int t = e;
            e = b;
            b = c;
            c = t;
            t = f;
            f = d;
            d = g;
            g = t;
            a -= e;
            e -= a;
            b -= f;
            f -= b;
            c -= g;
            g -= c;
            d -= h;
            h -= d;
            a -= c;
            c -= a;
            e -= g;
            g -= e;
            b -= d;
            d -= b;
            f -= h;
            h -= f;
            a -= b;
            b -= a;
            c -= d;
            d -= c;
            e -= f;
            f -= e;
            g -= h;
            h -= g;
            h -= this.sKey[--k];
            g ^= this.sKey[--k];
            f ^= this.sKey[--k];
            e -= this.sKey[--k];
            d -= this.sKey[--k];
            c ^= this.sKey[--k];
            b ^= this.sKey[--k];
            a -= this.sKey[--k];
            h = LOG[h & 0xFF] ^ this.sKey[--k];
            g = EXP[g & 0xFF] - this.sKey[--k];
            f = EXP[f & 0xFF] - this.sKey[--k];
            e = LOG[e & 0xFF] ^ this.sKey[--k];
            d = LOG[d & 0xFF] ^ this.sKey[--k];
            c = EXP[c & 0xFF] - this.sKey[--k];
            b = EXP[b & 0xFF] - this.sKey[--k];
            a = LOG[a & 0xFF] ^ this.sKey[--k];
            ++i;
        }
        out[outOff++] = (byte)a;
        out[outOff++] = (byte)b;
        out[outOff++] = (byte)c;
        out[outOff++] = (byte)d;
        out[outOff++] = (byte)e;
        out[outOff++] = (byte)f;
        out[outOff++] = (byte)g;
        out[outOff++] = (byte)h;
    }

    private void makeKey(byte[] keyBytes) {
        byte[] userKey = new byte[16];
        int keyLen = keyBytes.length;
        int len = 16;
        int userKeyLenSoFar = 0;
        while (len >= keyLen) {
            System.arraycopy(keyBytes, 0, userKey, userKeyLenSoFar, keyLen);
            len -= keyLen;
            userKeyLenSoFar += keyLen;
        }
        System.arraycopy(keyBytes, 0, userKey, userKeyLenSoFar, len);
        byte[] key1 = new byte[8];
        byte[] key2 = new byte[8];
        System.arraycopy(userKey, 0, key1, 0, 8);
        System.arraycopy(userKey, 8, key2, 0, 8);
        this.Safer_Expand_Userkey(key1, key2);
    }

    private void Safer_Expand_Userkey(byte[] userkey_1, byte[] userkey_2) {
        byte[] ka = new byte[9];
        byte[] kb = new byte[9];
        int k = 0;
        this.sKey[k++] = (byte)this.rounds;
        int j = 0;
        while (j < 8) {
            ka[j] = (byte)(userkey_1[j] << 5 | (userkey_1[j] & 0xFF) >>> 3);
            ka[8] = (byte)(ka[8] ^ ka[j]);
            this.sKey[k++] = userkey_2[j];
            kb[j] = userkey_2[j];
            kb[8] = (byte)(kb[8] ^ kb[j]);
            ++j;
        }
        int i = 1;
        while (i <= this.rounds) {
            int j2 = 0;
            while (j2 < 9) {
                ka[j2] = (byte)(ka[j2] << 6 | (ka[j2] & 0xFF) >>> 2);
                kb[j2] = (byte)(kb[j2] << 6 | (kb[j2] & 0xFF) >>> 2);
                ++j2;
            }
            j2 = 0;
            while (j2 < 8) {
                this.sKey[k++] = this.isStrong() ? ka[(j2 + 2 * i - 1) % 9] + EXP[EXP[18 * i + j2 + 1]] & 0xFF : ka[j2] + EXP[EXP[18 * i + j2 + 1]] & 0xFF;
                ++j2;
            }
            j2 = 0;
            while (j2 < 8) {
                this.sKey[k++] = this.isStrong() ? kb[(j2 + 2 * i) % 9] + EXP[EXP[18 * i + j2 + 10]] & 0xFF : kb[j2] + EXP[EXP[18 * i + j2 + 10]] & 0xFF;
                ++j2;
            }
            ++i;
        }
    }

    private boolean isStrong() {
        return !this.weak;
    }

    public void engineInitDecrypt(byte[] key, boolean useWeak) {
        this.encryptIfTrue = false;
        this.weak = useWeak;
        this.makeKey(key);
    }

    public void engineInitEncrypt(byte[] key, boolean useWeak) {
        this.encryptIfTrue = true;
        this.weak = useWeak;
        this.makeKey(key);
    }
}

