/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;

public class SigInputStream
extends ByteArrayInputStream {
    public SigInputStream(byte[] buffer) {
        super(buffer);
    }

    public int readAsciiInt() {
        int newByte;
        int value = 0;
        while ((newByte = this.read()) < 48 || newByte > 57) {
        }
        while (newByte >= 48 && newByte <= 57) {
            value *= 10;
            value += newByte - 48;
            this.mark(1);
            newByte = this.read();
        }
        this.reset();
        return value;
    }

    public int readBinaryShort() {
        int lsb = this.read();
        int msb = this.read();
        int value = msb << 8 | lsb;
        return value;
    }

    public int readBinaryByte() {
        int value = this.read();
        if (value > 128) {
            value -= 256;
        }
        return value;
    }

    public int readBinaryUnsignedByte() {
        byte b = (byte)this.read();
        return b;
    }

    public byte[] readBinaryByteArray(int count) {
        byte[] buffer = new byte[count];
        try {
            this.read(buffer);
        }
        catch (IOException e) {
            buffer = new byte[]{};
        }
        return buffer;
    }

    public int readBinaryByteBuffer(byte[] buffer, int count) {
        int numRead = 0;
        while (count > 0) {
            int v = this.read();
            if (v < 0) break;
            buffer[numRead++] = (byte)v;
            --count;
        }
        return numRead;
    }

    public int readBinaryInt() {
        int b0 = this.read();
        int b1 = this.read();
        int b2 = this.read();
        int b3 = this.read();
        int value = b3 << 24 | b2 << 16 | b1 << 8 | b0;
        return value;
    }
}

