/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

class ErrorDialog {
    private Throwable throwable;
    private Component component;

    public static void show(String message) {
        ErrorDialog.show(new Exception(message));
    }

    public static void show(Throwable throwable) {
        ErrorDialog.show(throwable, null);
    }

    public static void show(Throwable throwable, Component component) {
        ErrorDialog ed = new ErrorDialog(throwable, component);
        ed.show0();
    }

    private ErrorDialog(Throwable throwable, Component component) {
        this.throwable = throwable;
        this.component = component;
    }

    private void show0() {
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        CustomDialog cd = null;
        cd = win instanceof Dialog ? new CustomDialog((Dialog)win) : (win instanceof Frame ? new CustomDialog((Frame)win) : new CustomDialog((Frame)null));
        String msg = this.getMessage(this.throwable);
        cd.setMessage(msg != null ? msg : "");
        cd.setTitle("Error");
        cd.setResizable(true);
        cd.pack();
        if (this.component != null) {
            cd.setLocationRelativeTo(this.component);
        }
        this.centerWindow(cd);
        cd.setVisible(true);
    }

    private void centerWindow(Window win) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension winSize = win.getSize();
        int x = screenSize.width / 2 - winSize.width / 2;
        int y = screenSize.height / 2 - winSize.height / 2;
        win.setLocation(x, y);
    }

    private String getMessage(Throwable t) {
        if (t == null) {
            return null;
        }
        String msg = t.getMessage();
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            String s = cause.getMessage();
            if (s == null) continue;
            msg = s;
        }
        return msg;
    }

    private class CancelWindowAction
    implements ActionListener {
        JDialog dialog;
        KeyStroke keyStroke;

        CancelWindowAction(JDialog dialog) {
            this.dialog = dialog;
            this.keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        }

        public KeyStroke getKeyStroke() {
            return this.keyStroke;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.dialog.dispose();
        }
    }

    private class CustomWriter
    extends Writer {
        StringBuffer buffer = new StringBuffer();

        private CustomWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.buffer.append(cbuf, off, len);
        }

        public String getText() {
            return this.buffer.toString();
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class ThrowableView
    extends JScrollPane {
        JTextArea field = new JTextArea();

        ThrowableView() {
            this.field.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 0));
            this.field.setEditable(false);
            Font font = this.field.getFont();
            this.field.setFont(new Font(font.getFontName(), 0, 11));
            this.setViewportView(this.field);
        }

        void print(Throwable throwable) {
            CustomWriter writer = new CustomWriter();
            if (throwable != null) {
                throwable.printStackTrace(new PrintWriter(writer));
            }
            this.field.setText(writer.getText());
        }
    }

    private class CustomDialog
    extends JDialog {
        JPanel container;
        JLabel lblIcon;
        JLabel lblMessage;
        ThrowableView view;
        int maxWidth;

        CustomDialog(Dialog owner) {
            super(owner, true);
            this.maxWidth = 700;
            this.initComponents();
        }

        CustomDialog(Frame owner) {
            super(owner, true);
            this.maxWidth = 700;
            this.initComponents();
        }

        void setMessage(String message) {
            if (message != null) {
                StringBuffer sb = new StringBuffer();
                sb.append("<html>" + message.replaceAll("\\n", "<br>") + "</html>");
                this.lblMessage.setText(sb.toString());
                Dimension dim = this.lblMessage.getPreferredSize();
                if (dim.width > this.maxWidth) {
                    int parts = dim.width / this.maxWidth;
                    if (dim.width % this.maxWidth > 0) {
                        ++parts;
                    }
                    int height = dim.height * parts;
                    this.lblMessage.setPreferredSize(new Dimension(this.maxWidth, height));
                } else if (dim.width < 500) {
                    this.lblMessage.setPreferredSize(new Dimension(500, dim.height));
                }
            } else {
                this.lblMessage.setText("");
            }
        }

        private void initComponents() {
            this.container = new JPanel(new BorderLayout());
            this.view = new ThrowableView();
            JPanel pnlView = new JPanel(new BorderLayout());
            pnlView.setBorder(BorderFactory.createEmptyBorder(0, 15, 15, 15));
            pnlView.setPreferredSize(new Dimension(100, 200));
            pnlView.add(this.view);
            pnlView.setVisible(false);
            this.lblIcon = new JLabel();
            this.lblIcon.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
            this.lblIcon.setVerticalAlignment(1);
            this.lblMessage = new JLabel("Error Message");
            this.lblMessage.setVerticalAlignment(1);
            this.lblMessage.setBorder(BorderFactory.createEmptyBorder(3, 15, 0, 20));
            JPanel pnlIcon = new JPanel(new BorderLayout());
            pnlIcon.add((Component)this.lblIcon, "North");
            JPanel boxTop = new JPanel(new BorderLayout());
            this.container.add((Component)boxTop, "North");
            boxTop.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 0));
            boxTop.add((Component)pnlIcon, "West");
            boxTop.add(this.lblMessage);
            JPanel pnlSouth = new JPanel(new BorderLayout());
            this.container.add((Component)pnlSouth, "Center");
            Box boxButtons = new Box(2);
            pnlSouth.add((Component)boxButtons, "North");
            pnlSouth.add((Component)pnlView, "Center");
            boxButtons.setBorder(BorderFactory.createEmptyBorder(10, 15, 10, 20));
            boxButtons.add(this.createButton("Details >>", "showDetails", 'd', true));
            boxButtons.add(this.createButton("Details <<", "hideDetails", 'd', false));
            boxButtons.add(Box.createHorizontalGlue());
            JButton defaultButton = this.createButton("OK", "OK", '\u0000', true);
            defaultButton.setFocusable(true);
            this.getRootPane().setDefaultButton(defaultButton);
            boxButtons.add(defaultButton);
            Dimension btnDim = defaultButton.getPreferredSize();
            defaultButton.setPreferredSize(new Dimension(70, btnDim.height));
            this.setContentPane(this.container);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    JButton btn = CustomDialog.this.getRootPane().getDefaultButton();
                    if (btn == null) {
                        return;
                    }
                    btn.grabFocus();
                }
            });
            CancelWindowAction cwa = new CancelWindowAction(this);
            this.container.registerKeyboardAction(cwa, cwa.getKeyStroke(), 2);
        }

        private JButton createButton(String text, String actionCommand, char mnemonic, boolean visible) {
            JButton btn = new JButton(text);
            btn.setActionCommand(actionCommand);
            btn.setVisible(visible);
            btn.setFocusable(false);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomDialog.this.perform(e);
                }
            });
            if (mnemonic != '\u0000') {
                btn.setMnemonic(mnemonic);
            }
            this.container.putClientProperty("Button." + actionCommand, btn);
            return btn;
        }

        private void perform(ActionEvent e) {
            String cmd = e.getActionCommand();
            JButton btn = (JButton)e.getSource();
            if ("OK".equals(cmd)) {
                this.dispose();
            } else if ("showDetails".equals(cmd)) {
                this.view.getParent().setVisible(true);
                this.view.print(ErrorDialog.this.throwable);
                this.pack();
                btn.setVisible(false);
                ((JComponent)this.container.getClientProperty("Button.hideDetails")).setVisible(true);
                Dimension size = this.getSize();
                this.setSize(size.width, size.height);
            } else if ("hideDetails".equals(cmd)) {
                this.view.getParent().setVisible(false);
                this.pack();
                btn.setVisible(false);
                ((JComponent)this.container.getClientProperty("Button.showDetails")).setVisible(true);
                Dimension size = this.getSize();
                this.setSize(size.width, size.height);
            }
        }
    }
}

