/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.CipherUtil;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

final class OSPlatformIdentity {
    private static OSPlatformIdentity instance;
    private Map identity;
    private ImageIcon defaultIcon;

    public static OSPlatformIdentity getInstance() {
        if (instance == null) {
            instance = new OSPlatformIdentity();
        }
        return instance;
    }

    private OSPlatformIdentity() {
        URL url = OSPlatformIdentity.class.getResource(".identity");
        if (url == null) {
            throw new RuntimeException("Failed to load the platform identity");
        }
        this.load(url);
        HashMap map = new HashMap();
        if (this.identity != null) {
            map.putAll(this.identity);
        }
        System.getProperties().put("platform.identity", map);
    }

    public Object get(Object key) {
        return this.identity.get(key);
    }

    public byte[] getBytes(Object key) {
        return (byte[])this.get(key);
    }

    public String getString(Object key) {
        Object value = this.get(key);
        return value == null ? null : value.toString();
    }

    public ImageIcon getIcon(Object key) {
        byte[] bytes = this.getBytes(key);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new ImageIcon(bytes);
    }

    public ImageIcon getDefaultIcon() {
        try {
            if (this.defaultIcon == null) {
                URL url = OSPlatformIdentity.class.getResource("icon/os2-icon.png");
                this.defaultIcon = new ImageIcon(url);
            }
            return this.defaultIcon;
        }
        catch (Throwable x) {
            return null;
        }
    }

    private void load(URL url) {
        ObjectInputStream ois = null;
        InputStream inp = null;
        try {
            inp = url.openStream();
            ois = new ObjectInputStream(inp);
            Object o = ois.readObject();
            this.identity = (Map)CipherUtil.decode((Serializable)o);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception exception) {}
            try {
                inp.close();
            }
            catch (Exception exception) {}
        }
    }
}

