/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.report;

import com.rameses.osiris2.report.PrinterService;
import groovy.lang.Writable;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;

public class TextPrinter {
    private PrinterService printerService = new PrinterService();
    private String printerName;
    private Template template;

    public String getPrinterName() {
        return this.printerName;
    }

    public void setPrinterName(String printerName) {
        this.printerName = printerName;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public void setTemplate(InputStream is) {
        try {
            if (is == null) {
                throw new Exception("InputStream in setTemplate must not be null");
            }
            SimpleTemplateEngine se = new SimpleTemplateEngine();
            this.template = se.createTemplate((Reader)new InputStreamReader(is));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public void setTemplate(String str) {
        try {
            if (str == null) {
                throw new Exception("String in setTemplate must not be null");
            }
            SimpleTemplateEngine se = new SimpleTemplateEngine();
            this.template = se.createTemplate((Reader)new StringReader(str));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void print(Map data) throws Exception {
        List<String> printerList = this.printerService.getPrinters();
        if (printerList.size() == 0) {
            throw new Exception("There are no printer names registered in printer list");
        }
        if (this.printerName == null) {
            this.printerName = printerList.iterator().next();
        }
        Writable pw = this.template.make(data);
        this.printerService.printString(this.printerName, pw.toString());
    }
}

