/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2;

import com.rameses.osiris2.CodeProvider;
import com.rameses.osiris2.EnvMap;
import com.rameses.osiris2.FolderManager;
import com.rameses.osiris2.FolderParser;
import com.rameses.osiris2.Module;
import com.rameses.osiris2.ModuleParser;
import com.rameses.osiris2.SessionContext;
import com.rameses.osiris2.WorkUnit;
import com.rameses.util.ParserUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class AppContext {
    private static AppContext instance;
    protected Map env = new EnvMap();
    protected List invokers = new ArrayList();
    protected Map modules = new Hashtable();
    protected FolderManager folderManager;
    private final Object MODULES_LOCKED = new Object();
    private final Object INVOKERS_LOCKED = new Object();

    public static void setInstance(AppContext ctx) {
        instance = ctx;
    }

    public static AppContext getInstance() {
        if (instance == null) {
            throw new IllegalStateException("AppContext is null. You must call load(ClassLoader) at least once");
        }
        return instance;
    }

    public abstract ClassLoader getClassLoader();

    public abstract CodeProvider getCodeProvider();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            throw new IllegalStateException("ClassLoader is not specified");
        }
        this.invokers.clear();
        this.modules.clear();
        Enumeration<URL> e = loader.getResources("META-INF/module.conf");
        ExecutorService es = Executors.newCachedThreadPool();
        ArrayList<ModuleFuture> futures = new ArrayList<ModuleFuture>();
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            if (url == null) continue;
            ModuleLoader modLoader = new ModuleLoader(url);
            Future future = es.submit(modLoader);
            futures.add(new ModuleFuture(future, modLoader));
        }
        try {
            for (ModuleFuture fu : futures) {
                fu.get();
            }
        }
        finally {
            try {
                es.shutdown();
            }
            catch (Throwable throwable) {}
            futures.clear();
            futures = null;
            es = null;
            e = null;
        }
        Object object = this.INVOKERS_LOCKED;
        synchronized (object) {
            Collections.sort(this.invokers);
        }
        this.folderManager = new FolderManager(this);
        FolderParser.parseFolder(this.folderManager, loader);
    }

    public Module getModule(String name) {
        return (Module)this.modules.get(name);
    }

    public List getInvokers() {
        return this.invokers;
    }

    public WorkUnit getWorkUnit(String name) {
        if (!name.contains(":")) {
            throw new IllegalStateException("Workunit Name must have a namespace");
        }
        String[] arr = name.split(":");
        String namespace = arr[0];
        String workunitName = arr[1];
        return this.getModule(namespace).getWorkunit(workunitName);
    }

    public Map getEnv() {
        return this.env;
    }

    public void setEnv(Map env) {
        this.env = env;
    }

    public FolderManager getFolderManager() {
        return this.folderManager;
    }

    public SessionContext createSession() {
        return new SessionContext(this);
    }

    class ModuleFuture {
        Future future;
        ModuleLoader modLoader;

        ModuleFuture(Future future, ModuleLoader modLoader) {
            this.future = future;
            this.modLoader = modLoader;
        }

        URL getURL() {
            return this.modLoader.url;
        }

        Module get() {
            if (this.future == null) {
                return null;
            }
            try {
                this.future.get();
            }
            catch (InterruptedException ie) {
                System.out.println("[AppContext.ModuleLoader] failed to load URL " + this.modLoader.url);
                throw new RuntimeException(ie);
            }
            catch (ExecutionException ee) {
                System.out.println("[AppContext.ModuleLoader] failed to load URL " + this.modLoader.url);
                throw new RuntimeException(ee);
            }
            if (this.modLoader.error != null) {
                System.out.println("[AppContext.ModuleLoader] failed to load URL " + this.modLoader.url);
                Throwable err = this.modLoader.error;
                if (err instanceof RuntimeException) {
                    throw (RuntimeException)err;
                }
                throw new RuntimeException(err);
            }
            return this.modLoader.module;
        }
    }

    class ModuleLoader
    implements Callable {
        final AppContext root;
        private URL url;
        private Module module;
        private Throwable error;
        private String errmsg;

        ModuleLoader(URL url) {
            this.root = AppContext.this;
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call() throws Exception {
            Properties props = new Properties();
            InputStream inp = null;
            try {
                inp = this.url.openStream();
                props.load(inp);
            }
            catch (Throwable err) {
                this.error = err;
            }
            finally {
                try {
                    inp.close();
                }
                catch (Throwable throwable) {}
            }
            if (this.error != null) {
                return null;
            }
            try {
                Module mod = new Module(this.root, this.url, props);
                ParserUtil.updateAttributes((Object)mod, (Map)mod.getProperties(), (Map)props);
                Object object = this.root.MODULES_LOCKED;
                synchronized (object) {
                    this.root.modules.put(mod.getNamespace(), mod);
                }
                ModuleParser moduleParser = new ModuleParser(this.root.getClassLoader());
                moduleParser.parse(mod);
                Object object2 = this.root.INVOKERS_LOCKED;
                synchronized (object2) {
                    this.root.invokers.addAll(mod.getInvokers());
                }
                this.module = mod;
            }
            catch (Throwable err) {
                this.error = this.error;
            }
            finally {
                props.clear();
            }
            return null;
        }
    }
}

