/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2;

import com.rameses.osiris2.Invoker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Folder
implements Serializable,
Comparable {
    private String id;
    private String fullId;
    private String caption;
    private Folder parent;
    private List folders = new ArrayList();
    private Invoker invoker;
    private Integer index = new Integer(0);
    private Map properties = new HashMap();
    private boolean visible = false;

    public Folder(String id, String caption) {
        this.id = id;
        this.caption = caption;
        this.fullId = "/" + id;
    }

    public Folder(String id, String caption, Folder parent, Invoker invoker) {
        this.id = id;
        this.caption = caption;
        this.setParent(parent);
        this.fullId = this.getParent().getFullId() + "/" + id;
        this.invoker = invoker;
        this.index = invoker.getIndex();
        this.notifyVisible();
    }

    public String getId() {
        return this.id;
    }

    public String getFullId() {
        return this.fullId;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public Folder getParent() {
        return this.parent;
    }

    public List getFolders() {
        return this.folders;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Folder)) {
            return false;
        }
        if (super.equals(o)) {
            return true;
        }
        Folder f = (Folder)o;
        if (!this.getFullId().equals(f.getFullId())) {
            return false;
        }
        Invoker inv1 = this.getInvoker();
        Invoker inv2 = f.getInvoker();
        if (inv1 != null && inv2 != null && this.genKey(inv1).equals(this.genKey(inv2))) {
            return true;
        }
        return inv1 == null && inv2 == null;
    }

    private String genKey(Invoker inv) {
        StringBuilder sb = new StringBuilder();
        sb.append(inv.getType()).append("://").append(inv.getWorkunitid());
        sb.append("/").append(inv.getName()).append("/").append(inv.getAction());
        sb.append("/").append(inv.getCaption());
        return sb.toString().toLowerCase();
    }

    public void removeSelf() {
        this.getParent().getFolders().remove(this);
    }

    public void notifyVisible() {
        this.visible = true;
        for (Folder p = this.getParent(); p != null; p = p.getParent()) {
            p.visible = true;
        }
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<folder id=\"" + this.id + "\" caption=\"" + this.caption + "\" visible=\"" + this.visible + "\"  index=\"" + this.index + "\"");
        if (this.getFolders().size() > 0) {
            sb.append(">\n");
            for (Folder f : this.folders) {
                sb.append(f.toXml());
            }
            sb.append("</folder>\n");
        } else {
            sb.append("/>\n");
        }
        return sb.toString();
    }

    public void setParent(Folder parent) {
        this.parent = parent;
    }

    public int compareTo(Object o) {
        if (o instanceof Folder) {
            int idx2;
            Folder item2 = (Folder)o;
            int idx1 = this.getIndex() == null ? 0 : this.getIndex();
            int n = idx2 = item2.getIndex() == null ? 0 : item2.getIndex();
            if (idx1 < idx2) {
                return -1;
            }
            if (idx1 > idx2) {
                return 1;
            }
            return 0;
        }
        return 999999999;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setFullId(String fullId) {
        this.fullId = fullId;
    }
}

