/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2;

import com.rameses.osiris2.Folder;
import com.rameses.osiris2.FolderManager;
import com.rameses.util.ParserUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class FolderParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void parseFolder(FolderManager fm, ClassLoader loader) {
        try {
            SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
            FolderParseHandler fp = new FolderParseHandler(fm);
            Enumeration<URL> e = loader.getResources("META-INF/xfolders.xml");
            while (e.hasMoreElements()) {
                URL u = e.nextElement();
                InputStream is = null;
                try {
                    is = u.openStream();
                    sp.parse(is, (DefaultHandler)fp);
                }
                catch (Exception fex) {
                    System.out.println("failed to parse " + u);
                    fex.printStackTrace();
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public static class FolderParseHandler
    extends DefaultHandler {
        private FolderManager fm;
        private Stack stack = new Stack();
        private List invokers = null;

        public FolderParseHandler(FolderManager f) {
            this.fm = f;
        }

        @Override
        public void startElement(String string, String string0, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("folder")) {
                String caption;
                String _name = attributes.getValue("name");
                String _id = attributes.getValue("id");
                String _caption = attributes.getValue("caption");
                String id = _id;
                if (id == null) {
                    id = _name;
                }
                if (id == null) {
                    id = _caption;
                }
                if ((caption = _caption) == null) {
                    caption = _name;
                }
                if (caption == null) {
                    caption = _id;
                }
                Folder f = new Folder(id, caption);
                Folder parent = null;
                if (!this.stack.empty()) {
                    parent = (Folder)this.stack.peek();
                }
                ParserUtil.loadAttributes((Object)f, (Map)f.getProperties(), (Attributes)attributes);
                Folder ff = this.fm.addFolder(f, parent);
                this.stack.push(ff);
            }
        }

        @Override
        public void endElement(String string, String string0, String qName) throws SAXException {
            if (qName.equals("folder")) {
                Folder f = null;
                if (!this.stack.empty()) {
                    f = (Folder)this.stack.pop();
                }
            }
        }
    }
}

