/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2;

import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.Module;
import com.rameses.osiris2.Page;
import com.rameses.osiris2.WorkUnit;
import com.rameses.osiris2.flow.AbstractNode;
import com.rameses.osiris2.flow.EndNode;
import com.rameses.osiris2.flow.PageFlow;
import com.rameses.osiris2.flow.PageNode;
import com.rameses.osiris2.flow.ProcessNode;
import com.rameses.osiris2.flow.StartNode;
import com.rameses.osiris2.flow.SubProcessNode;
import com.rameses.osiris2.flow.Transition;
import com.rameses.util.AbortSAXException;
import com.rameses.util.ParserUtil;
import com.rameses.util.URLDirectory;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ModuleParser
implements URLDirectory.URLFilter {
    private ClassLoader loader;
    private WorkUnitParser workunitParser;
    private Module module;

    public ModuleParser(ClassLoader loader) {
        this.loader = loader;
        this.workunitParser = new WorkUnitParser();
    }

    public void parse(Module module) {
        this.module = module;
        try {
            URL url = new URL(module.getContextPath() + "/workunits");
            URLDirectory u = new URLDirectory(url);
            u.list((URLDirectory.URLFilter)this, this.loader);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(URL u, String filter) {
        String path = u.toExternalForm();
        if (path.endsWith(".xml")) {
            InputStream is = null;
            try {
                is = u.openStream();
                String workunitname = path.substring(path.lastIndexOf("/workunits/") + 11, path.lastIndexOf("."));
                WorkUnit workunit = new WorkUnit(workunitname, this.module);
                SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
                this.workunitParser.setWorkUnit(workunit);
                sp.parse(is, (DefaultHandler)this.workunitParser);
                this.module.getWorkUnits().put(workunit.getName(), workunit);
            }
            catch (AbortSAXException workunitname) {
            }
            catch (Throwable ex) {
                System.out.println("error parsing " + u.toExternalForm() + " " + ex.getMessage());
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable workunitname) {}
            }
        }
        return false;
    }

    private class WorkUnitParser
    extends DefaultHandler {
        private WorkUnit workunit;
        private StringBuilder buff;
        private PageFlow pageFlow = null;
        private AbstractNode abstractNode = null;
        private Invoker currentInvoker;

        public WorkUnitParser() {
            this.init();
        }

        public WorkUnitParser(WorkUnit wu) {
            this.setWorkUnit(wu);
        }

        void init() {
            this.buff = new StringBuilder();
            this.pageFlow = null;
            this.abstractNode = null;
        }

        public void setWorkUnit(WorkUnit wu) {
            this.workunit = wu;
            this.init();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.pageFlow == null) {
                if (qName.equals("workunit")) {
                    ParserUtil.loadAttributes((Object)this.workunit, (Map)this.workunit.getProperties(), (Attributes)attributes);
                    String s = (String)this.workunit.getProperties().remove("extends");
                    if (s != null && s.trim().length() > 0) {
                        String[] arr = s.split(",");
                        for (int i = 0; i < arr.length; ++i) {
                            String path = null;
                            String module_name = null;
                            try {
                                path = arr[i].trim();
                                if (path.matches("^[^/]+:/.+")) {
                                    String[] ss = path.split(":/");
                                    module_name = ss[0];
                                    path = ss[1];
                                }
                                URL u = null;
                                if (module_name == null) {
                                    u = ModuleParser.this.loader.getResource(path);
                                } else {
                                    Module m = this.workunit.getModule().getAppContext().getModule(module_name);
                                    if (m == null) {
                                        throw new RuntimeException("Module " + ModuleParser.this.module + " not found.");
                                    }
                                    u = m.getResource(path);
                                }
                                if (u == null) continue;
                                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                                WorkUnitParser wp = new WorkUnitParser(this.workunit);
                                parser.parse(u.openStream(), (DefaultHandler)wp);
                                continue;
                            }
                            catch (Throwable e) {
                                System.out.println("ERROR PARSING " + arr[i] + "! DETAILS: " + e.getMessage());
                            }
                        }
                    }
                } else if (qName.equals("invoker")) {
                    Invoker inv = new Invoker();
                    inv.setModule(ModuleParser.this.module);
                    inv.setWorkunitid(ModuleParser.this.module.getName() + ":" + this.workunit.getName());
                    inv.setWorkunitname(this.workunit.getName());
                    ParserUtil.loadAttributes((Object)inv, (Map)inv.getProperties(), (Attributes)attributes);
                    if (inv.getDomain() == null && ModuleParser.this.module.getDomain() != null) {
                        inv.setDomain(ModuleParser.this.module.getDomain());
                    }
                    ModuleParser.this.module.getInvokers().add(inv);
                    this.currentInvoker = inv;
                } else if (qName.equals("action") && this.currentInvoker != null) {
                    HashMap extended = new HashMap();
                    Invoker.Action ia = new Invoker.Action(attributes.getValue("name"));
                    ParserUtil.loadAttributes((Object)ia, extended, (Attributes)attributes);
                    ia.setProperties(extended);
                    this.currentInvoker.addAction(ia);
                } else if (qName.equals("code")) {
                    String className = attributes.getValue("class");
                    if (className != null) {
                        this.workunit.setClassName(className);
                    }
                    this.buff.delete(0, this.buff.length());
                } else if (qName.equals("pageflow")) {
                    this.pageFlow = new PageFlow();
                } else if (qName.equals("page")) {
                    Page p = new Page();
                    ParserUtil.loadAttributes((Object)p, (Map)p.getProperties(), (Attributes)attributes);
                    this.workunit.addPage(p);
                }
            } else if (qName.equals("start")) {
                this.abstractNode = new StartNode();
                ParserUtil.loadAttributes((Object)this.abstractNode, (Map)this.abstractNode.getProperties(), (Attributes)attributes);
                this.pageFlow.addNode(this.abstractNode);
            } else if (qName.equals("end")) {
                this.abstractNode = new EndNode();
                ParserUtil.loadAttributes((Object)this.abstractNode, (Map)this.abstractNode.getProperties(), (Attributes)attributes);
                this.pageFlow.addNode(this.abstractNode);
            } else if (qName.equals("page")) {
                this.abstractNode = new PageNode();
                ParserUtil.loadAttributes((Object)this.abstractNode, (Map)this.abstractNode.getProperties(), (Attributes)attributes);
                this.pageFlow.addNode(this.abstractNode);
            } else if (qName.equals("process")) {
                this.abstractNode = new ProcessNode();
                ParserUtil.loadAttributes((Object)this.abstractNode, (Map)this.abstractNode.getProperties(), (Attributes)attributes);
                this.pageFlow.addNode(this.abstractNode);
            } else if (qName.equals("subprocess")) {
                this.abstractNode = new SubProcessNode();
                ParserUtil.loadAttributes((Object)this.abstractNode, (Map)this.abstractNode.getProperties(), (Attributes)attributes);
                this.pageFlow.addNode(this.abstractNode);
            } else if (qName.equals("transition")) {
                Transition transition = new Transition();
                ParserUtil.loadAttributes((Object)transition, (Map)transition.getProperties(), (Attributes)attributes);
                this.abstractNode.getTransitions().add(transition);
            }
        }

        @Override
        public void characters(char[] c, int i, int i0) throws SAXException {
            this.buff.append(c, i, i0);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("invoker")) {
                this.currentInvoker = null;
            } else if (qName.equals("code")) {
                this.workunit.setCodeSource(this.buff.toString());
            } else if (qName.equals("pageflow")) {
                this.workunit.setPageFlow(this.pageFlow);
                this.pageFlow = null;
            }
        }
    }
}

