/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.client.notification;

import com.rameses.rcp.framework.ClientContext;
import com.rameses.service.ScriptServiceContext;
import com.rameses.service.ServiceProxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNotificationService {
    private static final Object LOCK = new Object();
    private ServiceProxy serviceProxy;

    public abstract String getName();

    protected ServiceProxy getProxy() {
        if (this.serviceProxy == null) {
            this.serviceProxy = this.create(this.getName());
        }
        return this.serviceProxy;
    }

    public void getNotified(Map params) {
        this.invoke("getNotified", params);
    }

    public void removeMessage(Map params) {
        this.invoke("removeMessage", params);
    }

    public List<Map> getList(Map params) {
        return (List)this.invoke("getList", params);
    }

    public Object invoke(String action) {
        return this.invoke(action, null);
    }

    public Object invoke(String action, Object arg) {
        try {
            Object[] params = new Object[]{};
            if (arg != null) {
                params = new Object[]{arg};
            }
            return this.getProxy().invoke(action, params);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceProxy create(String name) {
        Object object = LOCK;
        synchronized (object) {
            ClientContext cctx = ClientContext.getCurrentContext();
            Map appenv = cctx.getAppEnv();
            HashMap<String, String> newenv = new HashMap<String, String>();
            newenv.put("app.host", this.get(appenv, "notification.host", appenv.get("app.host")));
            newenv.put("app.context", this.get(appenv, "notification.context", appenv.get("app.context")));
            newenv.put("app.cluster", this.get(appenv, "app.cluster", appenv.get("app.cluster")));
            newenv.put("readTimeout", this.get(appenv, "readTimeout", "20000"));
            ScriptServiceContext ssc = new ScriptServiceContext(newenv);
            return (ServiceProxy)ssc.create(name, cctx.getHeaders());
        }
    }

    private String get(Map map, String name, Object defaultValue) {
        Object value;
        Object object = value = map == null ? null : (Object)map.get(name);
        if (value == null) {
            return defaultValue == null ? null : defaultValue.toString();
        }
        return value.toString();
    }
}

