/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.handles;

import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.interfaces.Handle;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public abstract class AbstractHandle
implements Handle {
    public static int HANDLE_SIZE = 8;
    public static Color HANDLE_BORDER_COLOR = new Color(150, 150, 150);
    public static Color HANDLE_FILL_COLOR = new Color(202, 234, 237);
    private Editor editor;
    private Figure owner;
    private double offsetX;
    private double offsetY;
    protected int startX;
    protected int startY;

    public AbstractHandle() {
    }

    public AbstractHandle(double offsetX, double offsetY) {
        this(null, offsetX, offsetY);
    }

    public AbstractHandle(Figure owner, double offsetX, double offsetY) {
        this.owner = owner;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    @Override
    public Editor getEditor() {
        return this.editor;
    }

    @Override
    public void setEditor(Editor editor) {
        this.editor = editor;
    }

    @Override
    public Figure getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Figure owner) {
        this.owner = owner;
    }

    @Override
    public void moveBy(int dx, int dy, MouseEvent e) {
        this.owner.moveBy(dx, dy, e);
    }

    @Override
    public void doStart(int dx, int dy, MouseEvent e) {
        this.startX = dx;
        this.startY = dy;
    }

    @Override
    public void doStep(int dx, int dy, MouseEvent e) {
    }

    @Override
    public void doEnd(int dx, int dy, MouseEvent e) {
    }

    @Override
    public Rectangle getDisplayBox() {
        Point center = this.getCenter();
        int offset = HANDLE_SIZE / 2;
        Point pt = new Point(center.x - offset, center.y - offset);
        return new Rectangle(pt, new Dimension(HANDLE_SIZE, HANDLE_SIZE));
    }

    @Override
    public Point getCenter() {
        Rectangle r = this.owner.getDisplayBox();
        int x = (int)((double)r.x + (double)r.width * this.offsetX);
        int y = (int)((double)r.y + (double)r.height * this.offsetY);
        return new Point(x, y);
    }

    @Override
    public boolean locate(int x, int y) {
        Rectangle r = this.getDisplayBox();
        return r.contains(x, y);
    }

    @Override
    public Cursor getCursor() {
        return new Cursor(0);
    }

    @Override
    public void draw(Graphics g) {
        Color oldColor = g.getColor();
        this.drawHandle(g);
        this.drawBorder(g);
        g.setColor(oldColor);
    }

    protected void drawHandle(Graphics g) {
        g.setColor(HANDLE_FILL_COLOR);
        Rectangle r = this.getDisplayBox();
        g.fillRect(r.x, r.y, r.width, r.height);
    }

    protected void drawBorder(Graphics g) {
        g.setColor(HANDLE_BORDER_COLOR);
        Rectangle r = this.getDisplayBox();
        g.drawRect(r.x, r.y, r.width, r.height);
    }
}

