/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.tools;

import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.tools.AbstractTool;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class SelectAreaTool
extends AbstractTool {
    private Rectangle selectedArea;
    private Color color;

    public SelectAreaTool() {
    }

    public SelectAreaTool(Editor editor) {
        super(editor);
        this.color = Color.BLACK;
    }

    @Override
    public void mousePressed(int x, int y, MouseEvent e) {
        super.mousePressed(x, y, e);
        this.marquee(this.getStartX(), this.getStartY(), this.getStartX(), this.getStartY());
    }

    @Override
    public void mouseDrag(int x, int y, MouseEvent e) {
        super.mouseDrag(x, y, e);
        this.clearMarquee();
        this.marquee(this.getStartX(), this.getStartY(), x, y);
    }

    @Override
    public void mouseReleased(int x, int y, MouseEvent e) {
        this.clearMarquee();
        this.selectGroup(e.isShiftDown());
        this.getCanvas().setSelectionArea(null);
        super.mouseReleased(x, y, e);
    }

    @Override
    public Cursor getToolCursor() {
        return new Cursor(0);
    }

    private void marquee(int x1, int y1, int x2, int y2) {
        this.selectedArea = new Rectangle(new Point(x1, y1));
        this.selectedArea.add(new Point(x2, y2));
        this.getCanvas().setSelectionArea(this.selectedArea);
    }

    private void clearMarquee() {
        this.getCanvas().setSelectionArea(this.selectedArea);
    }

    private void selectGroup(boolean toggle) {
        for (Figure figure : this.getDrawing().getFigures()) {
            Rectangle displayBox = figure.getDisplayBox();
            if (!this.selectedArea.contains(displayBox)) continue;
            if (toggle) {
                this.getDrawing().toggleSelection(figure);
                continue;
            }
            this.getDrawing().addSelection(figure);
        }
    }
}

