/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.tools;

import com.rameses.rcp.draw.figures.FloatingTextField;
import com.rameses.rcp.draw.figures.TextFigure;
import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.tools.AbstractTool;
import java.awt.event.MouseEvent;

public class TextTool
extends AbstractTool {
    private FloatingTextField floatingText;
    private TextFigure createdFigure;
    private TextFigure selectedFigure;
    private Figure prototype;
    private boolean newlyCreated;

    public TextTool() {
    }

    public TextTool(Editor editor) {
        this(editor, null);
    }

    public TextTool(Editor editor, TextFigure prototype) {
        super(editor);
        this.prototype = prototype;
    }

    @Override
    public void mousePressed(int x, int y, MouseEvent e) {
        Figure figure = this.getDrawing().figureAt(x, y);
        if (figure == null && this.floatingText != null) {
            this.endEdit();
            return;
        }
        if (figure instanceof TextFigure) {
            this.selectedFigure = (TextFigure)figure;
        }
        if (this.selectedFigure != null) {
            if (this.floatingText != null) {
                this.endEdit();
            }
            this.beginEdit(this.selectedFigure);
        } else if (this.floatingText == null) {
            this.createdFigure = this.createFigure(x, y);
            this.beginEdit(this.createdFigure);
        } else if (this.createdFigure != null || this.selectedFigure != null) {
            this.endEdit();
        }
    }

    public final void beginEdit(TextFigure f) {
        this.floatingText = new FloatingTextField();
        this.floatingText.createOverlay(this, this.getCanvas(), f);
    }

    public final void endEdit() {
        this.floatingText.endOverlay();
        if (this.createdFigure != null && !this.createdFigure.isEmpty()) {
            this.getEditor().addToDrawing(this.createdFigure);
            this.getEditor().figureAdded(this.createdFigure);
            this.getCanvas().revalidateRect(this.createdFigure.getDisplayBox());
        }
        this.floatingText = null;
    }

    private boolean isEditableFigure() {
        return this.selectedFigure != null && this.selectedFigure instanceof TextFigure;
    }

    private TextFigure createFigure(int x, int y) {
        try {
            return new TextFigure(null, x, y);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cancel() {
        this.getDrawing().removeFigure(this.createdFigure);
        this.createdFigure = null;
        if (this.floatingText != null) {
            this.floatingText.endOverlay();
            this.floatingText = null;
        }
        this.getEditor().setCurrentTool(this.getEditor().getDefaultTool());
        this.getCanvas().refresh();
    }
}

