/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.common.MethodResolver;
import com.rameses.rcp.common.ClickActionEvent;
import com.rameses.rcp.common.DocViewModel;
import com.rameses.rcp.common.HtmlViewModel;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PopupMenuOpener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.WebEngineProxy;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.jfx.WebViewPane;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Font;
import java.awt.Insets;
import java.util.Map;
import javafx.scene.web.WebEngine;

public class XWebView
extends WebViewPane
implements UIControl {
    private Binding binding;
    private String[] depends;
    private int index;
    private int stretchWidth;
    private int stretchHeight;
    private HtmlViewModel docModel;
    private String visibleWhen;
    private boolean dynamic;
    private ControlProperty controlProperty;

    public XWebView() {
        this.initComponents();
    }

    private void initComponents() {
    }

    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void load() {
    }

    public void refresh() {
        block13: {
            block12: {
                HtmlViewModel newModel = null;
                try {
                    Object value = UIControlUtil.getBeanValue((UIControl)this);
                    if (value instanceof HtmlViewModel) {
                        newModel = (HtmlViewModel)value;
                        value = newModel.getValue();
                    }
                    if (this.docModel != null) {
                        try {
                            this.docModel.setProvider(null);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (newModel == null) {
                        newModel = new WebViewModelImpl();
                    }
                    newModel.setProvider((DocViewModel.Provider)new ViewProviderImpl());
                    this.docModel = newModel;
                    this.setBindingBean(this.docModel);
                    this.setContextMenuEnabled(this.docModel.isContextMenuEnabled());
                    this.loadView(value);
                }
                catch (Throwable t) {
                    if (newModel != null) {
                        newModel.setProvider(null);
                    }
                    System.out.println("[WARN] refresh failed caused by " + t.getMessage());
                    if (!ClientContext.getCurrentContext().isDebugMode()) break block12;
                    t.printStackTrace();
                }
            }
            try {
                String visibleWhen = this.getVisibleWhen();
                if (visibleWhen == null || visibleWhen.trim().length() <= 0) break block13;
                Object bean = this.getBinding().getBean();
                boolean b = false;
                try {
                    b = UIControlUtil.evaluateExprBoolean((Object)bean, (String)visibleWhen);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.setVisible(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare((UIControl)this, (Object)o);
    }

    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    public Map getInfo() {
        return null;
    }

    public int getStretchWidth() {
        return this.stretchWidth;
    }

    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    public int getStretchHeight() {
        return this.stretchHeight;
    }

    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    public ControlProperty getControlProperty() {
        if (this.controlProperty == null) {
            this.controlProperty = new ControlProperty();
        }
        return this.controlProperty;
    }

    public boolean isRequired() {
        return this.getControlProperty().isRequired();
    }

    public void setRequired(boolean required) {
        this.getControlProperty().setRequired(required);
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.getControlProperty().setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    @Override
    protected void processAction(String name, Map param) {
        if (name == null || name.length() == 0) {
            return;
        }
        Object outcome = null;
        try {
            MethodResolver mresolver = MethodResolver.getInstance();
            outcome = mresolver.invoke(this.getBinding().getBean(), name, new Object[]{param});
        }
        catch (Throwable t) {
            System.out.println("[WARN] error invoking method '" + name + "' caused by " + t.getMessage());
            MsgBox.err((Throwable)t);
            return;
        }
        if (outcome instanceof Opener) {
            if (outcome instanceof PopupMenuOpener) {
                MsgBox.alert((Object)"PopupMenuOpener is not supported using XWebView");
                return;
            }
            Opener op = (Opener)outcome;
            String target = op.getTarget();
            if (target == null || target.trim().length() == 0 || target.equals("self")) {
                op.setTarget("window");
            }
            this.getBinding().fireNavigation((Object)op);
        }
    }

    @Override
    protected void processAction(ClickActionEvent cae) {
        if (this.docModel != null) {
            this.docModel.onClick((Object)cae);
        }
    }

    @Override
    protected void onSucceeded(WebEngine we) {
        if (this.docModel == null) {
            return;
        }
        this.docModel.setWebEngine((Object)new WebEngineProxy(we));
        this.docModel.onCompleted();
    }

    private class WebViewModelImpl
    extends HtmlViewModel {
        private WebViewModelImpl() {
        }
    }

    private class ViewProviderImpl
    implements HtmlViewModel.ViewProvider {
        XWebView root;

        private ViewProviderImpl() {
            this.root = XWebView.this;
        }

        public void insertText(String text) {
        }

        public void appendText(String text) {
        }

        public String getText() {
            return null;
        }

        public void setText(String text) {
            this.root.loadView(text == null ? "" : text);
        }

        public void load() {
        }

        public void refresh() {
            this.root.refresh();
        }

        public void requestFocus() {
        }

        public int getWidth() {
            return 0;
        }

        public int getHeight() {
            return 0;
        }
    }
}

