/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.camera;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamResolution;
import com.rameses.rcp.camera.WebcamPane;
import com.rameses.rcp.camera.WebcamPaneListener;
import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.common.CameraModel;
import com.rameses.rcp.common.MsgBox;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JDialog;

public final class WebcamViewer {
    public static final Properties CACHE = new Properties();
    public static Dimension PREFERRED_SIZE;
    private CameraModel model;
    private String title;
    private int width;
    private int height;
    private boolean autoCloseOnSelect;
    private boolean autoOpenMode;
    private boolean alwaysOnTop;
    private boolean modal;

    public static void open(Map options) {
        new WebcamViewer(options).open();
    }

    public static void open(CameraModel model) {
        new WebcamViewer(model).open();
    }

    public WebcamViewer() {
        this(new CameraModel());
    }

    public WebcamViewer(CameraModel model) {
        this.model = model == null ? new CameraModel() : model;
        this.init();
    }

    public WebcamViewer(Map options) {
        this.model = new CameraModelProxy(options);
        this.init();
    }

    private void init() {
        this.title = this.model.getTitle();
        this.width = this.model.getWidth();
        this.height = this.model.getHeight();
        this.autoCloseOnSelect = this.model.isAutoCloseOnSelect();
        this.autoOpenMode = this.model.isAutoOpenMode();
        this.alwaysOnTop = this.model.isAlwaysOnTop();
        this.modal = this.model.isModal();
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setAutoOpenMode(boolean autoOpenMode) {
        this.autoOpenMode = autoOpenMode;
    }

    public byte[] open() {
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        final WebcamPane pane = new WebcamPane(this);
        pane.setAutoCloseOnSelect(this.model.isAutoCloseOnSelect());
        JDialog dialog = null;
        dialog = win instanceof Frame ? new JDialog((Frame)win) : (win instanceof Dialog ? new JDialog((Dialog)win) : new JDialog());
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Camera");
        if (this.alwaysOnTop) {
            dialog.setAlwaysOnTop(true);
            dialog.setModal(false);
        } else {
            dialog.setAlwaysOnTop(true);
            dialog.setModal(true);
        }
        dialog.setContentPane(pane);
        dialog.pack();
        dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    pane.stop();
                }
                catch (Throwable t) {
                    MsgBox.err((Throwable)t);
                }
                WebcamViewer.this.onclose();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
                pane.start();
            }
        });
        this.centerWindow(dialog);
        pane.addListener(new WebcamPaneListenerImpl(dialog));
        this.model.setViewerProvider(new ViewerProviderImpl(dialog));
        dialog.setVisible(true);
        return null;
    }

    private void centerWindow(Window win) {
        Dimension windim = win.getSize();
        Dimension scrdim = Toolkit.getDefaultToolkit().getScreenSize();
        Insets margin = Toolkit.getDefaultToolkit().getScreenInsets(win.getGraphicsConfiguration());
        int scrwidth = scrdim.width - (margin.left + margin.right);
        int scrheight = scrdim.height - (margin.top + margin.bottom);
        int x = Math.max((scrwidth - windim.width) / 2, 0) + margin.left;
        int y = Math.max((scrheight - windim.height) / 2, 0) + margin.top;
        win.setLocation(x, y);
    }

    private Webcam whichWebcam(List<Webcam> webcams) {
        if (webcams.isEmpty()) {
            throw new RuntimeException("No available Webcam on your computer");
        }
        if (webcams.size() > 1) {
            return webcams.get(1);
        }
        return webcams.get(0);
    }

    private void onclose() {
        if (this.model != null) {
            this.model.onclose();
        }
    }

    private class ViewerProviderImpl
    implements CameraModel.ViewerProvider {
        WebcamViewer root;
        private JDialog dialog;

        ViewerProviderImpl(JDialog dialog) {
            this.root = WebcamViewer.this;
            this.dialog = dialog;
        }

        @Override
        public void close() {
            this.dialog.dispose();
            this.root.onclose();
        }
    }

    private class WebcamPaneListenerImpl
    implements WebcamPaneListener {
        WebcamViewer root;
        private JDialog dialog;

        WebcamPaneListenerImpl(JDialog dialog) {
            this.root = WebcamViewer.this;
            this.dialog = dialog;
        }

        @Override
        public void oncreate(Webcam webcam) {
            String title = this.root.title;
            if (title == null) {
                title = "Camera";
            }
            this.dialog.setTitle(title);
            Dimension[] customViewSizes = new Dimension[]{WebcamResolution.PAL.getSize(), new Dimension(1024, 768), WebcamResolution.HD720.getSize()};
            webcam.setCustomViewSizes(customViewSizes);
            webcam.setViewSize(WebcamResolution.HD720.getSize());
            try {
                Integer owidth = this.getInteger(CACHE, "webcam.width");
                Integer oheight = this.getInteger(CACHE, "webcam.height");
                webcam.setViewSize(new Dimension(owidth, oheight));
            }
            catch (Throwable owidth) {
                // empty catch block
            }
            Dimension dim = webcam.getViewSize();
            String deviceName = webcam.getDevice().getName();
            this.dialog.setTitle(deviceName + " (" + dim.width + " x " + dim.height + ")");
            Webcam.setAutoOpenMode((boolean)WebcamViewer.this.autoOpenMode);
        }

        @Override
        public void onchangeResolution(Dimension dim) {
            if (dim == null) {
                return;
            }
        }

        @Override
        public void onselect(byte[] bytes) {
            if (WebcamViewer.this.autoCloseOnSelect) {
                this.dialog.dispose();
            }
            if (this.root.model != null) {
                this.root.model.onselect(bytes);
            }
        }

        @Override
        public void oncancel() {
            this.dialog.dispose();
            this.root.onclose();
        }

        private Integer getInteger(Map data, String name) {
            try {
                int num = Integer.parseInt(data.get(name).toString());
                return new Integer(num);
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    private class CameraModelProxy
    extends CameraModel {
        private Map options;
        private String title;
        private Integer width;
        private Integer height;
        private Boolean autoOpenMode;
        private CallbackHandlerProxy onselectCallback;
        private CallbackHandlerProxy oncloseCallback;

        CameraModelProxy(Map options) {
            this.options = options;
            this.title = this.getString(options, "title");
            this.width = this.getInt(options, "width");
            this.height = this.getInt(options, "height");
            this.autoOpenMode = this.getBool(options, "autoOpenMode");
            Object source = this.get(options, "onselect");
            if (source != null) {
                this.onselectCallback = new CallbackHandlerProxy(source);
            }
            if ((source = this.get(options, "onclose")) != null) {
                this.oncloseCallback = new CallbackHandlerProxy(source);
            }
        }

        @Override
        public String getTitle() {
            if (this.title == null) {
                return super.getTitle();
            }
            return this.title;
        }

        @Override
        public int getWidth() {
            if (this.width == null) {
                return super.getWidth();
            }
            return this.width;
        }

        @Override
        public int getHeight() {
            if (this.height == null) {
                return super.getHeight();
            }
            return this.height;
        }

        @Override
        public boolean isAutoOpenMode() {
            if (this.autoOpenMode == null) {
                return super.isAutoOpenMode();
            }
            return this.autoOpenMode;
        }

        public void onselect(Object result) {
            if (this.onselectCallback == null) {
                return;
            }
            this.onselectCallback.call(result);
        }

        @Override
        public void onclose() {
            if (this.oncloseCallback == null) {
                return;
            }
            this.oncloseCallback.call();
        }

        private Integer getInt(Map map, String name) {
            try {
                return (Integer)map.get(name);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private String getString(Map map, String name) {
            try {
                Object o = map.get(name);
                return o == null ? null : o.toString();
            }
            catch (Throwable t) {
                return null;
            }
        }

        private Boolean getBool(Map map, String name) {
            try {
                return (Boolean)map.get(name);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private Object get(Map map, String name) {
            return map == null ? null : map.get(name);
        }
    }
}

