/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.fingerprint;

import com.rameses.rcp.fingerprint.ImageContext;
import java.util.ArrayList;
import java.util.List;

class FingerPrintDataModel {
    private List<Item> items = new ArrayList<Item>();
    private Item selectedItem;

    Item getItem(int index) {
        if (index >= 0 && index < this.items.size()) {
            return this.items.get(index);
        }
        return null;
    }

    int indexOf(Item item) {
        return this.items.indexOf(item);
    }

    void removeAll() {
        this.items.clear();
        this.selectedItem = null;
    }

    void remove(Item item) {
        if (item == null) {
            return;
        }
        this.items.remove(item);
        if (this.selectedItem != null && this.selectedItem.equals(item)) {
            this.selectedItem = null;
        }
        item.setModel(null);
    }

    void add(Item item) {
        if (item == null || this.items.contains(item)) {
            return;
        }
        item.setModel(this);
        this.items.add(item);
    }

    Item getSelectedItem() {
        return this.selectedItem;
    }

    void setSelectedItem(Item selectedItem) {
        this.selectedItem = selectedItem;
    }

    void setSelectedItem(int index) {
        this.selectedItem = this.getItem(index);
    }

    boolean isSelected(Item item) {
        if (item == null) {
            return false;
        }
        return this.selectedItem != null && this.selectedItem.equals(item);
    }

    void refresh() {
        for (Item item : this.items) {
            item.refresh();
        }
    }

    public static interface Item {
        public void setModel(FingerPrintDataModel var1);

        public void setImageContext(ImageContext var1);

        public void refresh();
    }
}

