/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.fingerprint;

import com.digitalpersona.uareu.Reader;
import com.digitalpersona.uareu.ReaderCollection;
import com.digitalpersona.uareu.UareUException;
import com.digitalpersona.uareu.UareUGlobal;
import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.common.FingerPrintModel;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.control.border.XEtchedBorder;
import com.rameses.rcp.fingerprint.FingerPrintPanel;
import com.rameses.rcp.fingerprint.FingerPrintResultInfo;
import com.rameses.rcp.fingerprint.ImageContext;
import com.rameses.rcp.support.ImageIconSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.Border;

public final class FingerPrintViewer {
    private FingerPrintModel model;
    private Reader reader;

    public static void open(Map options) {
        new FingerPrintViewer(options).open();
    }

    public static void open(FingerPrintModel model) {
        new FingerPrintViewer(model).open();
    }

    public FingerPrintViewer() {
        this(new FingerPrintModel());
    }

    public FingerPrintViewer(Map options) {
        this.model = new FingerPrintModelProxy(options);
    }

    public FingerPrintViewer(FingerPrintModel model) {
        this.model = model == null ? new FingerPrintModel() : model;
    }

    private Reader getReader() {
        if (this.reader == null) {
            try {
                ReaderCollection collection = UareUGlobal.GetReaderCollection();
                collection.GetReaders();
                this.reader = collection.isEmpty() ? null : (Reader)collection.get(0);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this.reader;
    }

    public byte[] open() {
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        final Reader reader = this.getReader();
        if (reader == null) {
            throw new NullPointerException("No available fingerprint reader");
        }
        try {
            reader.Open(Reader.Priority.COOPERATIVE);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (UareUException ue) {
            String str = String.format("%s returned DP error %d \n%s", "Reader.Open", ue.getCode() & 0xFFFF, ue.toString());
            throw new RuntimeException(str);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        final FingerPrintPanel panel = new FingerPrintPanel();
        panel.setFingerType(this.model.getFingerType());
        String title = this.model.getTitle();
        if (title == null) {
            title = "FingerPrint Capture";
        }
        JDialog dialog = null;
        dialog = win instanceof Frame ? new JDialog((Frame)win) : (win instanceof Dialog ? new JDialog((Dialog)win) : new JDialog());
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setTitle(title);
        Toolbar toolbar = new Toolbar(dialog, panel);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new DefaultLayout(panel, toolbar));
        contentPane.add(panel);
        contentPane.add(toolbar);
        dialog.setContentPane(contentPane);
        dialog.pack();
        dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                FingerPrintViewer.this.close(panel);
                FingerPrintViewer.this.fireOnClose();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
                panel.start(reader, false);
            }
        });
        this.centerWindow(dialog);
        dialog.setVisible(true);
        return null;
    }

    private void centerWindow(Window win) {
        Dimension windim = win.getSize();
        Dimension scrdim = Toolkit.getDefaultToolkit().getScreenSize();
        Insets margin = Toolkit.getDefaultToolkit().getScreenInsets(win.getGraphicsConfiguration());
        int scrwidth = scrdim.width - (margin.left + margin.right);
        int scrheight = scrdim.height - (margin.top + margin.bottom);
        int x = Math.max((scrwidth - windim.width) / 2, 0) + margin.left;
        int y = Math.max((scrheight - windim.height) / 2, 0) + margin.top;
        win.setLocation(x, y);
    }

    private void close(FingerPrintPanel panel) {
        try {
            panel.stop();
            panel.waitForCaptureThread();
        }
        catch (Throwable t) {
            MsgBox.err((Throwable)t);
        }
        try {
            this.reader.Close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void fireOnClose() {
        this.model.onclose();
    }

    private void fireOnSelect(ImageContext[] results) {
        this.model.onselect(new FingerPrintResultInfo(results));
    }

    private class FingerPrintModelProxy
    extends FingerPrintModel {
        private Map options;
        private String title;
        private Integer fingerType;
        private CallbackHandlerProxy onselectCallback;
        private CallbackHandlerProxy oncloseCallback;

        FingerPrintModelProxy(Map options) {
            this.options = options;
            this.title = this.getString(options, "title");
            this.fingerType = this.getInt(options, "fingerType");
            Object source = this.get(options, "onselect");
            if (source != null) {
                this.onselectCallback = new CallbackHandlerProxy(source);
            }
            if ((source = this.get(options, "onclose")) != null) {
                this.oncloseCallback = new CallbackHandlerProxy(source);
            }
        }

        @Override
        public String getTitle() {
            if (this.title == null) {
                return super.getTitle();
            }
            return this.title;
        }

        @Override
        public int getFingerType() {
            if (this.fingerType == null) {
                return super.getFingerType();
            }
            return this.fingerType;
        }

        @Override
        public void onselect(Object result) {
            if (this.onselectCallback == null) {
                return;
            }
            this.onselectCallback.call(result);
        }

        @Override
        public void onclose() {
            if (this.oncloseCallback == null) {
                return;
            }
            this.oncloseCallback.call();
        }

        private Integer getInt(Map map, String name) {
            try {
                return (Integer)map.get(name);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private String getString(Map map, String name) {
            try {
                Object o = map.get(name);
                return o == null ? null : o.toString();
            }
            catch (Throwable t) {
                return null;
            }
        }

        private Object get(Map map, String name) {
            return map == null ? null : map.get(name);
        }
    }

    private class ToolbarLayout
    implements LayoutManager {
        private ToolbarLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    w += dim.width + 3;
                    h = Math.max(dim.height, h);
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim;
                Component c;
                int i;
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                int size = 0;
                Component[] comps = parent.getComponents();
                for (i = 0; i < comps.length; ++i) {
                    c = comps[i];
                    if (!c.isVisible()) continue;
                    dim = c.getPreferredSize();
                    size += dim.width + 3;
                }
                x = Math.max((w - size) / 2, 0) + margin.left;
                for (i = 0; i < comps.length; ++i) {
                    c = comps[i];
                    if (!c.isVisible()) continue;
                    dim = c.getPreferredSize();
                    c.setBounds(x, y, dim.width, h);
                    x += dim.width + 3;
                }
            }
        }
    }

    private class Toolbar
    extends JPanel
    implements PropertyChangeListener {
        FingerPrintViewer root;
        private JDialog dialog;
        private FingerPrintPanel panel;
        private JButton btnOK;
        private JButton btnCancel;

        Toolbar(JDialog dialog, FingerPrintPanel panel) {
            this.root = FingerPrintViewer.this;
            this.dialog = dialog;
            this.panel = panel;
            this.setLayout(new ToolbarLayout());
            panel.removePropertyChangeListener(this);
            panel.addPropertyChangeListener(this);
            XEtchedBorder border = new XEtchedBorder();
            border.setPadding(new Insets(2, 5, 5, 5));
            border.setHideLeft(true);
            border.setHideBottom(true);
            border.setHideRight(true);
            this.setBorder((Border)border);
            this.initComponents();
        }

        private void initComponents() {
            this.btnOK = new JButton("Select");
            this.btnOK.setEnabled(false);
            this.btnOK.setMargin(new Insets(3, 7, 3, 7));
            this.btnOK.setIcon(ImageIconSupport.getInstance().getIcon("images/toolbars/approve.png"));
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Toolbar.this.doSelect(e);
                }
            });
            this.add(this.btnOK);
            this.btnCancel = new JButton("Cancel");
            this.btnCancel.setMargin(new Insets(3, 7, 3, 7));
            this.btnCancel.setIcon(ImageIconSupport.getInstance().getIcon("images/toolbars/cancel.png"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Toolbar.this.doCancel(e);
                }
            });
            this.add(this.btnCancel);
        }

        private void doSelect(ActionEvent e) {
            this.dialog.dispose();
            this.root.close(this.panel);
            this.root.fireOnSelect(this.panel.getImageContexts());
        }

        private void doCancel(ActionEvent e) {
            this.dialog.dispose();
            this.root.close(this.panel);
            this.root.fireOnClose();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("imageDataChanged".equals(name)) {
                this.btnOK.setEnabled(evt.getNewValue() instanceof byte[]);
                this.btnOK.repaint();
            }
        }
    }

    private class DefaultLayout
    implements LayoutManager {
        private JComponent panel;
        private JComponent toolbar;

        DefaultLayout(JComponent panel, JComponent toolbar) {
            this.panel = panel;
            this.toolbar = toolbar;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim;
                int w = 0;
                int h = 0;
                if (this.panel != null) {
                    dim = this.panel.getPreferredSize();
                    w = dim.width;
                    h = dim.height;
                }
                if (this.toolbar != null) {
                    dim = this.toolbar.getPreferredSize();
                    w = Math.max(dim.width, w);
                    h += dim.height;
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim;
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                if (this.panel != null) {
                    dim = this.panel.getPreferredSize();
                    this.panel.setBounds(x, y, w, dim.height);
                    y += dim.height;
                }
                if (this.toolbar != null) {
                    dim = this.toolbar.getPreferredSize();
                    this.toolbar.setBounds(x, y, w, dim.height);
                }
            }
        }
    }
}

