/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.sigid.device;

import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.SigIdModel;
import com.rameses.rcp.common.SigIdResult;
import com.rameses.rcp.sigid.SigIdDevice;
import com.rameses.rcp.sigid.SigIdParams;
import com.rameses.rcp.sigid.device.TopazPanel;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

class TopazDevice
implements SigIdDevice {
    private SigIdModel model;

    public TopazDevice(SigIdModel model) {
        this.model = model;
    }

    @Override
    public void open() {
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        final TopazPanel panel = new TopazPanel();
        panel.setParams(new SigIdParamsImpl(this.model));
        JDialog dialog = null;
        dialog = win instanceof Frame ? new JDialog((Frame)win) : (win instanceof Dialog ? new JDialog((Dialog)win) : new JDialog());
        final JDialog jdialog = dialog;
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setContentPane(panel);
        dialog.setTitle(this.model.getTitle());
        dialog.setSize(this.model.getWidth(), this.model.getHeight());
        dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    panel.stop();
                }
                catch (Throwable t) {
                    JOptionPane.showMessageDialog(jdialog, "[ERROR] " + t.getClass().getName() + ": " + t.getMessage());
                }
                TopazDevice.this.doCloseImpl();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
                try {
                    panel.start();
                }
                catch (Throwable t) {
                    MsgBox.err((Throwable)t);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jdialog.dispose();
                        }
                    });
                }
            }
        });
        panel.add(new SelectionListenerImpl(jdialog));
        this.centerWindow(dialog);
        dialog.setVisible(true);
    }

    private void doCloseImpl() {
        if (this.model != null) {
            this.model.onclose();
        }
    }

    private void doSelectImpl(SigIdResult info) {
        if (this.model != null) {
            this.model.onselect(info);
        }
    }

    private void centerWindow(Window win) {
        Dimension windim = win.getSize();
        Dimension scrdim = Toolkit.getDefaultToolkit().getScreenSize();
        Insets margin = Toolkit.getDefaultToolkit().getScreenInsets(win.getGraphicsConfiguration());
        int scrwidth = scrdim.width - (margin.left + margin.right);
        int scrheight = scrdim.height - (margin.top + margin.bottom);
        int x = Math.max((scrwidth - windim.width) / 2, 0) + margin.left;
        int y = Math.max((scrheight - windim.height) / 2, 0) + margin.top;
        win.setLocation(x, y);
    }

    private class SelectionListenerImpl
    implements TopazPanel.SelectionListener {
        private JDialog jdialog;

        SelectionListenerImpl(JDialog jdialog) {
            this.jdialog = jdialog;
        }

        @Override
        public void onselect(SigIdResult info) {
            this.jdialog.dispose();
            TopazDevice.this.doSelectImpl(info);
        }

        @Override
        public void onclose() {
            this.jdialog.dispose();
            TopazDevice.this.doCloseImpl();
        }
    }

    private class SigIdParamsImpl
    implements SigIdParams {
        private SigIdModel model;

        SigIdParamsImpl(SigIdModel model) {
            this.model = model;
        }

        @Override
        public int getPenWidth() {
            return this.model.getPenWidth();
        }

        @Override
        public int getImageXSize() {
            return this.model.getImageXSize();
        }

        @Override
        public int getImageYSize() {
            return this.model.getImageYSize();
        }

        @Override
        public String getKey() {
            return this.model.getKey();
        }
    }
}

