/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.custom.impl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

public final class JsonUtil {
    private static final Format tsf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Format df = new SimpleDateFormat("yyyy-MM-dd");

    public static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        JsonUtil.parseDateToString(o);
        if (o instanceof Map) {
            return JSONObject.fromObject((Object)o).toString();
        }
        if (o instanceof List) {
            return JSONArray.fromObject((Object)o).toString();
        }
        if (o instanceof String || o instanceof Date) {
            return "\"" + o.toString() + "\"";
        }
        return o.toString();
    }

    private static void parseDateToString(Object obj) {
        block6: {
            block5: {
                if (!(obj instanceof List)) break block5;
                for (Object o : (List)obj) {
                    JsonUtil.parseDateToString(o);
                }
                break block6;
            }
            if (!(obj instanceof Map)) break block6;
            Map m = (Map)obj;
            Object value = null;
            for (Map.Entry me : m.entrySet()) {
                value = me.getValue();
                if (value instanceof List) {
                    JsonUtil.parseDateToString(value);
                    continue;
                }
                if (value instanceof Map) {
                    JsonUtil.parseDateToString(value);
                    continue;
                }
                if (value instanceof Timestamp) {
                    m.put(me.getKey(), tsf.format(value));
                    continue;
                }
                if (!(value instanceof Date)) continue;
                m.put(me.getKey(), df.format(value));
            }
        }
    }

    public static Object toObject(String s) {
        if (s.trim().startsWith("{")) {
            return JsonUtil.toMap(s);
        }
        if (s.trim().startsWith("[")) {
            return JsonUtil.toList(s);
        }
        throw new RuntimeException("Expression not supported. " + s);
    }

    public static Object[] toObjectArray(String s) {
        if (s.trim().startsWith("{")) {
            return new Object[]{JsonUtil.toMap(s)};
        }
        if (s.trim().startsWith("[")) {
            return JsonUtil.toList(s).toArray(new Object[0]);
        }
        throw new RuntimeException("Expression not supported. " + s);
    }

    public static Map toMap(String s) {
        JSONObject jo = JSONObject.fromObject((Object)s);
        return JsonUtil.toMap(jo);
    }

    public static Map toMap(JSONObject jo) {
        JsonConfig conf = new JsonConfig();
        conf.setJavaPropertyFilter((PropertyFilter)new JsonFilter());
        return (Map)JSONObject.toBean((JSONObject)jo, new LinkedHashMap(), (JsonConfig)conf);
    }

    public static List toList(String s) {
        JSONArray arr = JSONArray.fromObject((Object)s);
        return JsonUtil.toList(arr);
    }

    public static List toList(JSONArray arr) {
        Iterator iter = arr.iterator();
        ArrayList<Object> list = new ArrayList<Object>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof JSONObject) {
                JSONObject jo = (JSONObject)o;
                list.add(JsonUtil.toMap(jo));
                continue;
            }
            if (o instanceof JSONArray) {
                List ja = JsonUtil.toList((JSONArray)o);
                list.add(ja);
                continue;
            }
            list.add(o);
        }
        return list;
    }

    public static class JsonFilter
    implements PropertyFilter {
        public boolean apply(Object object, String field, Object value) {
            Map map = (Map)object;
            if (value == null) {
                map.put(field, null);
            } else if (value instanceof JSONNull) {
                map.put(field, null);
            } else if (value instanceof JSONArray) {
                List list = JsonUtil.toList((JSONArray)value);
                map.put(field, list);
            } else if (value instanceof JSONObject) {
                JSONObject o = (JSONObject)value;
                Map bean = JsonUtil.toMap(o);
                map.put(field, bean);
            } else if (value instanceof Double) {
                map.put(field, new BigDecimal(value + ""));
            } else {
                map.put(field, value);
            }
            return true;
        }
    }
}

