/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.reports;

import com.rameses.osiris2.client.Inv;
import com.rameses.osiris2.reports.JRPrinter;
import com.rameses.osiris2.reports.ReportDataSource;
import com.rameses.osiris2.reports.ReportModel;
import com.rameses.osiris2.reports.ReportURLStreamHandlerFactory;
import com.rameses.rcp.common.Opener;
import com.rameses.util.URLStreamHandlers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JasperViewer;

public final class ReportUtil {
    public static final String REPORT_FILE_NAME = "REPORT_FILE_NAME";
    public static final ReportURLStreamHandlerFactory factory = new ReportURLStreamHandlerFactory();
    private static boolean developerMode;

    public static JasperPrint generateJasper(Object data, Map conf) throws Exception {
        JasperReport r = (JasperReport)conf.get("main");
        ReportDataSource md = new ReportDataSource(data);
        try {
            return JasperFillManager.fillReport((JasperReport)r, (Map)conf, (JRDataSource)md);
        }
        catch (JRException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static InputStream generatePdf(Object data, Map conf) throws Exception {
        JasperPrint jp = ReportUtil.generateJasper(data, conf);
        ReportDataSource md = new ReportDataSource(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        JasperExportManager.exportReportToPdfStream((JasperPrint)jp, (OutputStream)bos);
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public static InputStream generateHtml(Object data, Map conf) throws Exception {
        JasperPrint jp = ReportUtil.generateJasper(data, conf);
        ReportDataSource md = new ReportDataSource(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        JRHtmlExporter jhtml = new JRHtmlExporter();
        jhtml.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jp);
        jhtml.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)bos);
        jhtml.exportReport();
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public static void view(JasperPrint p) {
        JasperViewer.viewReport((JasperPrint)p);
    }

    public static boolean print(JasperPrint jp) throws Exception {
        return ReportUtil.print(jp, true);
    }

    public static boolean print(JasperPrint jp, boolean withPrintDialog) throws Exception {
        Float ratio = JRPrinter.newConfig().getZoomRatio(jp);
        if (ratio == null) {
            return JasperPrintManager.printReport((JasperPrint)jp, (boolean)withPrintDialog);
        }
        JRPrinter printer = new JRPrinter(jp);
        return printer.print(withPrintDialog);
    }

    public static boolean print(String reportName, Object reportData) throws Exception {
        return ReportUtil.print(reportName, reportData, true);
    }

    public static boolean print(String reportName, Object reportData, boolean withPrintDialog) throws Exception {
        if (reportName == null || reportName.trim().length() == 0) {
            throw new RuntimeException("reportName parameter is required");
        }
        if (reportData == null) {
            throw new RuntimeException("reportData must not be null");
        }
        ReportModelImpl rmi = new ReportModelImpl(reportName, reportData);
        rmi.viewReport();
        return ReportUtil.print(rmi.getReport(), withPrintDialog);
    }

    public static JasperReport getJasperReport(String name) {
        if (name.endsWith(".jrxml")) {
            String reportPath = System.getProperty("user.dir") + "/reports/";
            URLConnection uc = null;
            InputStream is = null;
            FileOutputStream fos = null;
            try {
                String srptname = reportPath + name.replaceAll("jrxml", "jasper");
                String dirPath = srptname.substring(0, srptname.lastIndexOf("/"));
                File fd = new File(dirPath);
                if (!fd.exists()) {
                    fd.mkdirs();
                }
                File f = new File(srptname);
                URL u = ReportUtil.class.getClassLoader().getResource(name);
                is = u.openStream();
                uc = u.openConnection();
                long newModified = uc.getLastModified();
                if (f.exists()) {
                    long oldModified = f.lastModified();
                    if (newModified != oldModified) {
                        f.delete();
                        fos = new FileOutputStream(f);
                        JasperCompileManager.compileReportToStream((InputStream)is, (OutputStream)fos);
                        fos.flush();
                        f.setLastModified(newModified);
                    }
                } else {
                    fos = new FileOutputStream(f);
                    JasperCompileManager.compileReportToStream((InputStream)is, (OutputStream)fos);
                    fos.flush();
                    f.setLastModified(newModified);
                }
                JasperReport jr = (JasperReport)JRLoader.loadObject((File)f);
                jr.setProperty(REPORT_FILE_NAME, f.getName().substring(0, f.getName().lastIndexOf(".jrxml")));
                JasperReport jasperReport = jr;
                return jasperReport;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
        if (name.endsWith(".jasper")) {
            try {
                URL res = ReportUtil.getResource(name);
                if (res == null) {
                    throw new Exception("Report name " + name + " not recognized");
                }
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)res);
                int idx = res.toString().lastIndexOf("/");
                if (idx > 0) {
                    String sname = res.toString().substring(idx + 1);
                    idx = sname.lastIndexOf(".jasper");
                    if (idx > 0) {
                        sname = sname.substring(0, idx);
                    }
                    jr.setProperty(REPORT_FILE_NAME, sname);
                }
                return jr;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
        throw new IllegalStateException("Report name " + name + " not recognized");
    }

    public static URL getResource(String name) {
        return factory.getResource(name);
    }

    public static InputStream getResourceAsStream(String name) {
        try {
            URL res = ReportUtil.getResource(name);
            return res == null ? null : res.openStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URL getImage(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        String resname = "images/" + name;
        URL result = factory.getWebResource("images/" + name);
        if (result == null) {
            return ReportUtil.getResource(resname);
        }
        return null;
    }

    public static InputStream getImageAsStream(String name) {
        try {
            URL res = ReportUtil.getImage(name);
            return res == null ? null : res.openStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean hasReport(String name) {
        URL url = ReportUtil.getResource(name);
        return url != null;
    }

    public static boolean isDeveloperMode() {
        return developerMode;
    }

    public static File getDefaultCustomFolder() {
        File userdir = new File(System.getProperty("user.dir"));
        File outputdir = new File(userdir, "customreport");
        if (!outputdir.exists()) {
            outputdir.mkdir();
        }
        return outputdir;
    }

    public static File getCustomFolder() {
        return factory.getDeveloperCustomFolder();
    }

    public static void setCustomFolder(File folder) {
        factory.setDeveloperCustomFolder(folder);
    }

    public static String join(String delim, Object ... args) {
        if (args == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (sb.length() > 0) {
                sb.append(delim == null ? "" : delim);
            }
            sb.append(args[i].toString());
        }
        return sb.toString();
    }

    public static String capitalize(String value) {
        if (value == null) {
            return value;
        }
        char prevchar = ' ';
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (Character.isLetter(ch)) {
                chars[i] = Character.isWhitespace(prevchar) ? Character.toUpperCase(ch) : Character.toLowerCase(ch);
            }
            prevchar = ch;
        }
        return new String(chars);
    }

    static {
        System.out.println("Starting cache resource cleaner...");
        new Thread(new CacheResourceCleaner()).start();
        try {
            Opener opener = Inv.lookupOpener((String)"sysreport:edit", new HashMap());
            developerMode = opener != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        factory.setDeveloperMode(developerMode);
        try {
            URL.setURLStreamHandlerFactory(URLStreamHandlers.getFactory());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class ReportModelImpl
    extends ReportModel {
        private String name;
        private Object data;

        ReportModelImpl(String name, Object data) {
            this.name = name;
            this.data = data;
        }

        @Override
        public Object getReportData() {
            return this.data;
        }

        @Override
        public String getReportName() {
            return this.name;
        }
    }

    private static class CacheResourceCleaner
    implements Runnable {
        private CacheResourceCleaner() {
        }

        @Override
        public void run() {
            String cacheName = ReportURLStreamHandlerFactory.CACHE_NAME;
            File dir = ReportURLStreamHandlerFactory.getCacheDir();
            if (!dir.isDirectory()) {
                return;
            }
            File bakdir = new File(dir.getParentFile(), cacheName + "_" + System.currentTimeMillis());
            dir.renameTo(bakdir);
            for (File f : bakdir.listFiles()) {
                try {
                    if (!f.isFile()) continue;
                    f.delete();
                }
                catch (Throwable t) {
                    System.out.println("[CacheResourceCleaner] " + t.getMessage());
                }
            }
            try {
                bakdir.delete();
            }
            catch (Throwable t) {
                System.out.println("[CacheResourceCleaner] " + t.getMessage());
            }
        }
    }
}

