/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.reports;

import com.rameses.io.IOStream;
import com.rameses.osiris2.reports.SysReportTemplateSource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;

public class SysReportTemplate {
    static final int DEFAULT_BUFFER_SIZE = 4096;
    private File rootDir;
    private File contextDir;
    private String filename;
    private String fileseparator;
    public boolean debug;

    public SysReportTemplate(String rootPath) {
        File basedir;
        if (rootPath == null || rootPath.trim().length() == 0) {
            throw new IllegalArgumentException("rootPath must not be null or empty");
        }
        this.fileseparator = System.getProperty("file.separator", File.separator);
        this.contextDir = new File(this.fileseparator);
        this.rootDir = this.isLinuxEnv() ? new File(rootPath) : ((basedir = this.getBaseDir()) == null ? new File(rootPath) : new File(basedir, rootPath));
    }

    public SysReportTemplate(String rootPath, String filepath) {
        File basedir;
        if (rootPath == null || rootPath.trim().length() == 0) {
            throw new IllegalArgumentException("rootPath must not be null or empty");
        }
        if (filepath == null || filepath.trim().length() == 0) {
            throw new IllegalArgumentException("filepath must not be null or empty");
        }
        this.fileseparator = System.getProperty("file.separator", File.separator);
        File file = new File(filepath.replace("\\", this.fileseparator).replace("/", this.fileseparator));
        file = new File(this.fileseparator, file.getPath());
        this.filename = file.getName();
        this.contextDir = file.getParentFile();
        this.rootDir = this.isLinuxEnv() ? new File(rootPath) : ((basedir = this.getBaseDir()) == null ? new File(rootPath) : new File(basedir, rootPath));
    }

    private boolean isLinuxEnv() {
        String sbasedir = System.getProperty("osiris.base.dir");
        if (sbasedir == null || sbasedir.length() == 0) {
            sbasedir = System.getProperty("user.home.dir", "");
        }
        return sbasedir.startsWith("/");
    }

    private File getBaseDir() {
        String sbasedir = System.getProperty("osiris.base.dir");
        if (sbasedir == null || sbasedir.length() == 0) {
            sbasedir = System.getProperty("user.home.dir");
        }
        if (sbasedir == null || sbasedir.length() == 0) {
            return null;
        }
        return new File(sbasedir);
    }

    public String getRootPath() {
        return this.rootDir.getPath();
    }

    public String getContextPath() {
        return this.contextDir.getPath();
    }

    public String getFilename() {
        return this.filename;
    }

    public String formatResourceName(String fname) {
        return this.formatResourceName(fname, this.getContextPath());
    }

    public String formatResourceName(String fname, String ctxPath) {
        String _ctxPath;
        String _fname = this.resolveFilePath(fname);
        String string = _ctxPath = ctxPath == null ? "" : this.resolveFilePath(ctxPath);
        if (_fname.startsWith(this.fileseparator)) {
            return _fname;
        }
        if (_fname.startsWith(_ctxPath)) {
            return _fname;
        }
        return new File(ctxPath, fname).getPath();
    }

    private void fetchResources(String ctxPath, String fname, Set<Map> files, boolean for_upload) throws Exception {
        String fpath = this.formatResourceName(fname, ctxPath);
        fpath = fpath.replace(".jasper", ".jrxml");
        File file = new File(this.getRootPath(), fpath);
        if (!file.exists()) {
            return;
        }
        if (fpath.endsWith(".jrxml")) {
            byte[] bytes = IOStream.toByteArray((File)file);
            if (bytes == null || bytes.length == 0) {
                throw new Exception("no content found from " + file.getPath());
            }
            String str = new String(bytes, StandardCharsets.UTF_8);
            Pattern pttn = Pattern.compile("<imageExpression.*>.*?</imageExpression>|<subreportExpression.*>.*?</subreportExpression>");
            Matcher matcher = pttn.matcher(str);
            ArrayList<String[]> xlist = new ArrayList<String[]>();
            while (matcher.find()) {
                String g = matcher.group();
                int index = g.indexOf("![CDATA[");
                boolean isImage = g.startsWith("<imageExpression");
                String pref = g.substring(index + 8).trim();
                pref = pref.substring(0, pref.indexOf("]"));
                pref = this.resolveFilePath(pref);
                if (isImage && pref.matches("^\\$[FPV]{1,1}\\{.*\\}$")) continue;
                if (pref.startsWith(this.fileseparator)) {
                    xlist.add(new String[]{"", pref});
                    continue;
                }
                xlist.add(new String[]{ctxPath, pref});
            }
            for (String[] arr : xlist) {
                this.fetchResources(arr[0], arr[1], files, for_upload);
            }
            this.fetchResources(ctxPath, "headerinfo", files, false);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", fname);
        map.put("lastmodified", file.lastModified());
        files.add(map);
    }

    public List<Map> getResources() throws Exception {
        return this.getResourcesImpl(false);
    }

    public List<Map> getResourcesImpl(boolean for_upload) throws Exception {
        HashSet<Map> files = new HashSet<Map>();
        File file = new File(this.getContextPath(), this.getFilename());
        this.fetchResources(file.getParentFile().getPath(), file.getName(), files, for_upload);
        ArrayList<Map> list = new ArrayList<Map>();
        for (Map m : files) {
            list.add(m);
        }
        return list;
    }

    public List<Map> getResources(Object handler) {
        ArrayList<Map> results = new ArrayList<Map>();
        File dir = new File(this.getRootPath());
        ResourceFilter filter = new ResourceFilter(handler);
        this.scanResources(dir.listFiles(), filter, results);
        return results;
    }

    public boolean removeResource(String name) {
        if (name == null) {
            return false;
        }
        File file = new File(this.getRootPath(), this.resolveFilePath(name));
        if (!file.exists()) {
            return false;
        }
        try {
            this.scanDelete(name);
            return true;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void saveResource(String name, byte[] bytes) {
        if (name == null) {
            throw new IllegalArgumentException("name  parameter is required");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("bytes  parameter is required for resource '" + name + "'");
        }
        ByteArrayInputStream bais = null;
        FileOutputStream fos = null;
        try {
            File file = new File(this.getRootPath(), this.resolveFilePath(name));
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (this.debug) {
                System.out.println("[saveResource] file ==> " + file);
            }
            bais = new ByteArrayInputStream(bytes);
            fos = new FileOutputStream(file);
            IOStream.write((InputStream)bais, (OutputStream)fos);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
            try {
                bais.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void scanResources(File[] files, ResourceFilter filter, List<Map> results) {
        if (files == null || files.length == 0) {
            return;
        }
        String sroot = this.getRootPath();
        for (File file : files) {
            if (file.isDirectory()) {
                this.scanResources(file.listFiles(), filter, results);
                continue;
            }
            if (!filter.accept(file, file.getName())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", file.getPath().substring(sroot.length()));
            map.put("rootpath", sroot);
            results.add(map);
        }
    }

    private void verifyJasperFile(File file) throws Exception {
        if (!file.getPath().endsWith(".jasper")) {
            throw new IllegalStateException("'" + file.getPath() + "'  must be a jasper file");
        }
        if (file.exists() && file.isDirectory()) {
            throw new IllegalStateException("'" + file.getPath() + "'  should not be a directory");
        }
        File srcFile = new File(file.getPath().replace(".jasper", ".jrxml"));
        if (srcFile.exists() && (!file.exists() || srcFile.lastModified() != file.lastModified())) {
            JasperCompileManager.compileReportToFile((String)srcFile.getAbsolutePath(), (String)file.getAbsolutePath());
            file.setLastModified(srcFile.lastModified());
        }
        if (!file.exists()) {
            throw new IOException("'" + file.getPath() + "'  file not found");
        }
    }

    public URL getResource(String path) throws Exception {
        File file = new File(this.getRootPath(), this.formatResourceName(path));
        return this.getResource(file);
    }

    public URL getResource(File file) throws Exception {
        if (file.getPath().endsWith(".jasper")) {
            this.verifyJasperFile(file);
        }
        if (file.exists()) {
            return file.toURI().toURL();
        }
        return null;
    }

    public byte[] getContent(String path) throws Exception {
        File file = new File(this.getRootPath(), this.formatResourceName(path));
        if (file.getPath().endsWith(".jasper")) {
            this.verifyJasperFile(file);
            if (file.exists()) {
                return IOStream.toByteArray((File)file);
            }
        }
        if (file.exists()) {
            return IOStream.toByteArray((File)file);
        }
        return null;
    }

    public void saveContent(String path, byte[] bytes, long lastModified) throws Exception {
        File file = new File(this.getRootPath(), this.formatResourceName(path));
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(bytes);
            fos = new FileOutputStream(file);
            IOStream.write((InputStream)bis, (OutputStream)fos);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
            try {
                bis.close();
            }
            catch (Throwable throwable) {}
        }
        file.setLastModified(lastModified);
    }

    public List<Map> sync(SysReportTemplateSource src) throws Exception {
        File file = new File(this.getContextPath(), this.getFilename());
        return this.sync(src, file.getPath(), false);
    }

    public List<Map> sync(SysReportTemplateSource src, boolean sourceFile) throws Exception {
        File file = new File(this.getContextPath(), this.getFilename());
        return this.sync(src, file.getPath(), sourceFile);
    }

    public List<Map> sync(SysReportTemplateSource src, String filepath) throws Exception {
        return this.sync(src, filepath, false);
    }

    public List<Map> sync(SysReportTemplateSource src, String filepath, boolean sourceFile) throws Exception {
        File srcFile = new File(this.fileseparator, filepath.replace("\\", this.fileseparator));
        filepath = srcFile.getPath();
        String _contextPath = srcFile.getParent();
        ArrayList<Map> stores = new ArrayList<Map>();
        List<Map> resources = src.getResources(filepath);
        for (Map map : resources) {
            File file;
            String _name = (String)map.get("name");
            long lastmodified = (Long)map.get("lastmodified");
            boolean isReportName = filepath.endsWith(_name);
            String saveFileName = null;
            saveFileName = isReportName ? new File(this.getContextPath(), this.getFilename()).getPath() : this.formatResourceName(_name, this.getContextPath());
            if (sourceFile) {
                saveFileName = saveFileName.replace(".jasper", ".jrxml");
            }
            if (!(file = new File(this.getRootPath(), saveFileName)).exists() || file.lastModified() != lastmodified) {
                byte[] bytes;
                String resname = this.formatResourceName(_name, _contextPath);
                if (sourceFile) {
                    resname = resname.replace(".jasper", ".jrxml");
                }
                if ((bytes = src.getContent(resname)) == null) {
                    if (!saveFileName.endsWith(".jrxml")) continue;
                    throw new IOException("'" + resname + "'  resouce not found");
                }
                this.saveContent(saveFileName, bytes, lastmodified);
                HashMap<String, Object> store = new HashMap<String, Object>();
                store.put("name", saveFileName);
                store.put("main", isReportName ? 1 : 0);
                stores.add(store);
                continue;
            }
            HashMap<String, Object> store = new HashMap<String, Object>();
            store.put("name", saveFileName);
            store.put("main", isReportName ? 1 : 0);
            stores.add(store);
        }
        return stores;
    }

    public void upload(SysReportTemplateSource src) throws Exception {
        this.upload(src, true);
    }

    public void upload(SysReportTemplateSource src, boolean sourceFile) throws Exception {
        File file = new File(this.getContextPath(), this.getFilename());
        HashMap<String, Map> oldResMap = new HashMap<String, Map>();
        List<Map> oldRes = src.getResources(file.getPath());
        if (oldRes != null) {
            for (Map mo : oldRes) {
                String sname = this.resolveFilePath((String)mo.get("name"));
                oldResMap.put(sname, mo);
            }
        }
        List<Map> resources = this.getResourcesImpl(true);
        ArrayList<String> forDeletion = new ArrayList<String>();
        for (Map map : resources) {
            Object olm;
            long lastmodified = (Long)map.get("lastmodified");
            String _name = this.resolveFilePath((String)map.get("name"));
            map.put("name", _name);
            String ctxpath = _name.startsWith(this.fileseparator) ? "" : this.getContextPath();
            String fname = this.formatResourceName(_name, ctxpath);
            if (sourceFile) {
                fname = fname.replace(".jasper", ".jrxml");
            }
            forDeletion.add(fname);
            Map d = (Map)oldResMap.get(_name);
            if (d != null && ((olm = d.get("lastmodified")) == null || olm.equals(map.get("lastmodified")))) continue;
            byte[] bytes = this.getContent(fname);
            if (bytes == null) {
                throw new IOException("'" + fname + "'  resource not found");
            }
            src.saveContent(fname, bytes, lastmodified);
        }
        for (String s : forDeletion) {
            this.scanDelete(s);
        }
    }

    private void scanDelete(String sfile) throws Exception {
        File root = new File(this.getRootPath());
        for (File file = new File(root, this.resolveFilePath(sfile)); file != null && !file.getPath().equals(root.getPath()); file = file.getParentFile()) {
            File ff;
            if (file.getName().endsWith(".jrxml")) {
                ff = new File(file.getParent(), file.getName().replace(".jrxml", ".jasper"));
                if (ff.exists()) {
                    ff.delete();
                }
            } else if (file.getName().endsWith(".jasper") && (ff = new File(file.getParent(), file.getName().replace(".jasper", ".jrxml"))).exists()) {
                ff.delete();
            }
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                if (children != null && children.length != 0) continue;
                file.delete();
                continue;
            }
            file.delete();
        }
    }

    public JasperReport getReport() throws Exception {
        File dir = new File(this.getRootPath(), this.getContextPath());
        File file = new File(dir, this.getFilename());
        return (JasperReport)JRLoader.loadObject((URL)this.getResource(file));
    }

    public JasperReport getReport(SysReportTemplateSource src) throws Exception {
        File file = new File(this.getContextPath(), this.getFilename());
        this.sync(src, file.getPath());
        return this.getReport();
    }

    private void writeBytes(InputStream iis, OutputStream oos) throws Exception {
        byte[] buffer = new byte[4096];
        int EOF = -1;
        int len = 0;
        while ((len = iis.read(buffer)) != EOF) {
            oos.write(buffer, 0, len);
        }
        oos.flush();
    }

    private String resolveFilePath(String path) {
        if (path == null) {
            return path;
        }
        if ((path = path.replace("\\", this.fileseparator).replace("/", this.fileseparator)).startsWith("\"") && path.endsWith("\"")) {
            return path.substring(1, path.length() - 1);
        }
        return path;
    }

    private class ResourceFilter
    implements FilenameFilter {
        FileFilter fileFilter;
        FilenameFilter filenameFilter;
        Object closure;

        ResourceFilter(Object handler) {
            if (handler != null) {
                if (handler instanceof FileFilter) {
                    this.fileFilter = (FileFilter)handler;
                } else if (handler instanceof FilenameFilter) {
                    this.filenameFilter = (FilenameFilter)handler;
                } else if (this.isClosure(handler.getClass())) {
                    this.closure = handler;
                }
            }
        }

        boolean isClosure(Class clazz) {
            if (clazz == null) {
                return false;
            }
            if (clazz.getName().equals("groovy.lang.Closure")) {
                return true;
            }
            return this.isClosure(clazz.getSuperclass());
        }

        @Override
        public boolean accept(File file, String name) {
            if (file == null || file.isDirectory()) {
                return false;
            }
            if (this.fileFilter != null) {
                return this.fileFilter.accept(file);
            }
            if (this.filenameFilter != null) {
                return this.filenameFilter.accept(file, file.getName());
            }
            if (this.closure != null) {
                return this.call(file);
            }
            return false;
        }

        boolean call(File file) {
            try {
                Method m = this.closure.getClass().getMethod("call", Object.class);
                Object o = m.invoke(this.closure, file);
                if (o instanceof Boolean) {
                    return (Boolean)o;
                }
                return false;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }
}

