/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class CustomFileFilter
extends FileFilter {
    private String name;
    private String desc;
    private String ext_filter;

    public CustomFileFilter(String name, String[] args) {
        this.name = name;
        StringBuilder ext = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || args[i].trim().length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(",");
                ext.append("|");
            }
            sb.append("*.").append(args[i].toLowerCase());
            ext.append(args[i].toLowerCase());
        }
        this.desc = name + " (" + sb.toString() + ")";
        this.ext_filter = ext.toString();
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String sname = file.getName().toLowerCase();
            int idx = sname.lastIndexOf(".");
            if (idx > 0) {
                String ext = sname.substring(idx + 1);
                return ext.matches(this.ext_filter);
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }
}

