/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt;

import com.rameses.filemgmt.FileLocationConf;
import com.rameses.filemgmt.FileLocationRegistry;
import com.rameses.io.FileLocTypeProvider;
import com.rameses.io.FileTransferSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class FileSysLocTypeProvider
implements FileLocTypeProvider,
FileLocationRegistry {
    private static final Map<String, FileLocationConf> confs = new HashMap<String, FileLocationConf>();
    private static final String PROVIDER_NAME = "file";

    public String getName() {
        return PROVIDER_NAME;
    }

    public FileTransferSession createUploadSession() {
        return new UploadSession();
    }

    public FileTransferSession createDownloadSession() {
        return null;
    }

    public void deleteFile(String name, String locationConfigId) {
    }

    @Override
    public void register(FileLocationConf conf) {
        FileLocationConf cc;
        if (conf == null) {
            return;
        }
        if (PROVIDER_NAME.equals(conf.getType()) && (cc = confs.get(conf.getName())) == null) {
            confs.put(conf.getName(), conf);
        }
    }

    private FileLocationConf getDefaultConf() {
        FileLocationConf[] values;
        for (FileLocationConf c : values = confs.values().toArray(new FileLocationConf[0])) {
            if (!c.isDefaulted()) continue;
            return c;
        }
        return null;
    }

    private class UploadSession
    extends FileTransferSession {
        private UploadSession() {
        }

        public void run() {
            if (this.isCancelled()) {
                return;
            }
            FileLocationConf c = FileSysLocTypeProvider.this.getDefaultConf();
            if (c == null) {
                System.out.println("No default file location conf");
                return;
            }
            String rootdir = c.getRootDir();
            if (rootdir == null) {
                rootdir = "";
            }
            File dir = null;
            try {
                dir = new File(new URL(c.getUrl()).toURI());
            }
            catch (MalformedURLException e1) {
                throw new RuntimeException(e1.getMessage(), e1);
            }
            catch (URISyntaxException e2) {
                throw new RuntimeException(e2.getMessage(), e2);
            }
            if (rootdir.trim().length() > 0) {
                dir = new File(dir, rootdir.trim());
            }
            File destfile = new File(dir, this.getTargetName());
            File srcfile = this.getFile();
            FileTransferSession.Handler handler = this.getHandler();
            long filesize = this.getFileSize(srcfile);
            int len = 0;
            long bytesprocessed = 0L;
            boolean finished = false;
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(destfile);
                fis = new FileInputStream(srcfile);
                byte[] buffer = new byte[102400];
                while ((len = fis.read(buffer)) != -1) {
                    fos.write(buffer, 0, len);
                    bytesprocessed += (long)len;
                    if (handler == null) continue;
                    handler.ontransfer(filesize, bytesprocessed);
                }
                finished = true;
            }
            catch (FileNotFoundException ff) {
                throw new RuntimeException(ff.getMessage(), ff);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.getMessage(), ioe);
            }
            finally {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
            if (finished && handler != null) {
                handler.oncomplete();
            }
        }

        private long getFileSize(File file) {
            int len = 0;
            int bytesprocessed = 0;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                byte[] buffer = new byte[102400];
                while ((len = fis.read(buffer)) != -1) {
                    bytesprocessed += len;
                }
                long l = bytesprocessed;
                return l;
            }
            catch (FileNotFoundException ff) {
                throw new RuntimeException(ff.getMessage(), ff);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.getMessage(), ioe);
            }
            finally {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

