/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt;

import com.rameses.filemgmt.FileItem;
import com.rameses.filemgmt.FileLocationConf;
import com.rameses.filemgmt.FileLocationRegistry;
import com.rameses.filemgmt.FileManager;
import com.rameses.filemgmt.FileUploadItemProc;
import com.rameses.filemgmt.FileUploadManager;
import com.rameses.io.FileLocTypeProvider;
import com.rameses.io.FileTransferSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class FileUploadItem
implements FileItem {
    public static final String MODE_TEMP_COPY = "TEMP";
    public static final String MODE_UPLOAD = "UPLOAD";
    public static final String MODE_COMPLETED = "COMPLETED";
    public static final String CONF_FILE_DIR = "filedir";
    public static final String CONF_FILE_LOC_ID = "filelocid";
    public static final String CONF_FILE_SOURCE = "source";
    public static final String CONF_FILE_SIZE = "filesize";
    public static final String CONF_FILE_TYPE = "filetype";
    public static final String CONF_FILE_ID = "fileid";
    public static final String CONF_FILE_GROUP_ID = "filegroupid";
    public static final String CONF_CONNECTION = "connection";
    private File folder;
    private ConfigFile confFile;
    private ContentFile contentFile;
    private boolean immediate;

    public static synchronized FileUploadItem create(File folder, Map conf) throws Exception {
        FileUploadItem fui = new FileUploadItem(folder);
        fui.createImpl(conf);
        return fui;
    }

    public static synchronized FileUploadItem open(File folder) throws Exception {
        FileUploadItem fui = new FileUploadItem(folder);
        fui.openImpl();
        return fui;
    }

    private FileUploadItem(File file) {
        this.folder = file;
    }

    @Override
    public String getName() {
        return this.folder.getName();
    }

    public ConfigFile getConfigFile() {
        return this.confFile;
    }

    public ContentFile getContentFile() {
        return this.contentFile;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    private void createImpl(Map conf) throws Exception {
        this.verifyFolder();
        this.confFile = new ConfigFile(this.folder, ".conf");
        this.confFile.create(conf);
        Number filesize = this.confFile.getPropertyAsNumber(CONF_FILE_SIZE);
        if (filesize == null) {
            filesize = 0;
        }
        String str = "TEMP," + filesize + ",0";
        this.contentFile = new ContentFile(this.folder, "content");
        this.contentFile.getStatusFile().create(str);
        this.createTempFile(".tempcopy");
        this.createTempFile(".ready");
        Object val = conf.get("immediate");
        this.immediate = val != null && val.toString().matches("true|1");
        FileUploadManager.getInstance().getFileHandlers().register(this);
    }

    private void openImpl() {
        this.verifyFolder();
        this.confFile = new ConfigFile(this.folder, ".conf");
        this.confFile.read();
        this.contentFile = new ContentFile(this.folder, "content");
        this.contentFile.getStatusFile().read();
    }

    public String getMode() {
        if (this.isModeTempCopy()) {
            return MODE_TEMP_COPY;
        }
        if (this.isModeUpload()) {
            return MODE_UPLOAD;
        }
        if (this.isModeCompleted()) {
            return MODE_COMPLETED;
        }
        return "";
    }

    public boolean isModeReady() {
        File file = new File(this.folder, ".ready");
        return file.exists() && !file.isDirectory();
    }

    public boolean isModeTempCopy() {
        File file = new File(this.folder, ".tempcopy");
        return file.exists() && !file.isDirectory();
    }

    public boolean isModeCompleted() {
        File file = new File(this.folder, ".completed");
        return file.exists() && !file.isDirectory();
    }

    public boolean isModeUpload() {
        File file = new File(this.folder, ".upload");
        return file.exists() && !file.isDirectory();
    }

    public FileUploadItemProc createProcessHandler() {
        if (this.isMarkedForRemoval()) {
            return new ModeRemovalProcess();
        }
        if (this.isModeReady()) {
            return new ModeReadyProcess();
        }
        if (this.isModeTempCopy()) {
            return new ModeTempCopyProcess();
        }
        if (this.isModeUpload()) {
            return new ModeUploadProcess();
        }
        return null;
    }

    public void markForRemoval() {
        this.createTempFile(".forremoval");
    }

    public boolean isMarkedForRemoval() {
        File file = new File(this.folder, ".forremoval");
        return file.exists() && !file.isDirectory();
    }

    public void remove() {
        this.remove(this.folder);
    }

    private void remove(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File child : files = file.listFiles()) {
                this.remove(child);
            }
        }
        try {
            file.delete();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void verifyFolder() {
        if (!this.folder.exists()) {
            this.folder.mkdir();
        } else if (!this.folder.isDirectory()) {
            this.folder.delete();
            this.folder.mkdir();
        }
    }

    public void createTempFile(String name) {
        this.createTempFile(name, null);
    }

    public void createTempFile(String name, String content) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(this.folder, name));
            fos.write((content == null ? "" : content).getBytes());
            fos.flush();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean removeTempFile(String name) {
        try {
            File tmp = new File(this.folder, name);
            return tmp.exists() ? tmp.delete() : true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void recreateConfigFile(Map conf) {
        this.verifyFolder();
        this.confFile = new ConfigFile(this.folder, ".conf");
        this.confFile.create(conf);
    }

    private class TransferHandler
    implements FileTransferSession.Handler {
        FileUploadItem root;
        FileUploadItemProc proc;

        private TransferHandler() {
            this.root = FileUploadItem.this;
        }

        public void ontransfer(long filesize, long bytesprocessed) {
            if (this.root.isMarkedForRemoval() && this.proc != null) {
                this.proc.cancel();
                return;
            }
            StatusFile sf = this.root.getContentFile().getStatusFile().read();
            sf.setPos(bytesprocessed);
            sf.update();
            FileUploadManager.getInstance().getFileHandlers().notifyOnTransfer(this.root, filesize, bytesprocessed);
        }

        public void oncomplete() {
            this.root.getContentFile().getStatusFile().changeMode(FileUploadItem.MODE_COMPLETED);
            FileUploadManager.getInstance().getFileHandlers().notifyOnCompleted(this.root);
            FileUploadManager.getInstance().getFileHandlers().unregister(this.root);
        }

        public void ontransfer(long bytesprocessed) {
        }
    }

    private class ModeRemovalProcess
    extends FileUploadItemProc {
        FileUploadItem root;

        private ModeRemovalProcess() {
            this.root = FileUploadItem.this;
        }

        @Override
        public void run() {
            try {
                if (!this.isCancelled()) {
                    this.runImpl();
                }
            }
            catch (Throwable t) {
                Throwable c = this.getNonRuntimeException(t);
                System.out.println("[ModeRemovalProcess] error -> " + c.getMessage());
            }
        }

        private void runImpl() throws Exception {
            ConfigFile conf = this.root.getConfigFile().read();
            String filelocid = conf.getProperty(FileUploadItem.CONF_FILE_LOC_ID);
            String connection = conf.getProperty(FileUploadItem.CONF_CONNECTION);
            FileUploadManager fum = FileUploadManager.getInstance();
            FileLocationConf fileloc = FileManager.getInstance().getLocation(connection, filelocid);
            if (fileloc == null) {
                System.out.println("[ModeRemovalProcess] '" + filelocid + "' file location config not found for " + this.root.getName());
                return;
            }
            FileLocTypeProvider loctype = fum.getLocType(fileloc.getType());
            if (loctype == null) {
                System.out.println("[ModeRemovalProcess] '" + fileloc.getType() + "' file location type not found for " + this.root.getName());
                return;
            }
            String filetype = conf.getProperty(FileUploadItem.CONF_FILE_TYPE);
            StringBuilder sb = new StringBuilder();
            sb.append(this.root.getName());
            if (filetype != null && filetype.trim().length() > 0) {
                sb.append(".").append(filetype.trim());
            }
            fum.remove(this.root);
            try {
                loctype.deleteFile(sb.toString(), filelocid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private Throwable getNonRuntimeException(Throwable t) {
            if (t instanceof RuntimeException) {
                Throwable c = t.getCause();
                if (c == null) {
                    return t;
                }
                return this.getNonRuntimeException(c);
            }
            return t;
        }
    }

    private class ModeUploadProcess
    extends FileUploadItemProc {
        private final int STAT_SUCCESS = 1;
        private final int STAT_PROCESSING = 2;
        private final int STAT_FILE_LOC_CONF_NOT_FOUND = 3;
        private final int STAT_FILE_LOC_TYPE_NOT_FOUND = 4;
        FileUploadItem root = FileUploadItem.this;
        FileTransferSession sess;
        LinkedBlockingQueue queue;

        private ModeUploadProcess() {
        }

        @Override
        public void cancel() {
            super.cancel();
            try {
                this.sess.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.sess = null;
        }

        @Override
        public void run() {
            boolean completed = false;
            boolean success = false;
            String message = null;
            while (true) {
                block9: {
                    try {
                        if (this.isCancelled()) {
                            throw new InterruptedException();
                        }
                        int stat = this.runImpl();
                        if (stat == 1) {
                            message = "success";
                            this.root.createTempFile(".completed");
                            this.root.removeTempFile(".upload");
                            this.root.removeTempFile(".error");
                            success = true;
                            completed = true;
                            break;
                        }
                        if (stat == 3) {
                            message = "file location config not found";
                            this.root.createTempFile(".error", message);
                            this.root.removeTempFile(".upload");
                            completed = true;
                            break;
                        }
                        if (stat == 4) {
                            message = "file location type not found";
                            this.root.createTempFile(".error", message);
                            this.root.removeTempFile(".upload");
                            completed = true;
                        }
                        break block9;
                    }
                    catch (InterruptedException ie) {
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        Throwable c = this.getNonRuntimeException(t);
                        System.out.println("[ModeUploadProcess] error -> " + c.getMessage());
                        if (this.root.folder.exists()) break block9;
                        System.out.println("[ModeUploadProcess] file item " + this.root.getName() + " has been deleted manually");
                        FileUploadManager.getInstance().remove(this.root);
                    }
                    break;
                }
                this.pause(1000L);
            }
            if (completed) {
                this.fireOnCompleted(success, message);
            }
        }

        private int runImpl() throws Exception {
            long filesize;
            ConfigFile conf = this.root.getConfigFile().read();
            StatusFile sf = this.root.getContentFile().getStatusFile().read();
            long filepos = sf.getPos();
            if (filepos >= (filesize = sf.getSize())) {
                sf.changeMode(FileUploadItem.MODE_COMPLETED);
                return 1;
            }
            FileUploadManager fum = FileUploadManager.getInstance();
            String filedir = conf.getProperty(FileUploadItem.CONF_FILE_DIR);
            String filelocid = conf.getProperty(FileUploadItem.CONF_FILE_LOC_ID);
            String connection = conf.getProperty(FileUploadItem.CONF_CONNECTION);
            FileLocationConf fileloc = FileManager.getInstance().getLocation(connection, filelocid);
            if (fileloc == null) {
                System.out.println("[ModeUploadProcess] '" + filelocid + "' file location config not found for " + this.root.getName());
                return 3;
            }
            FileLocTypeProvider loctype = fum.getLocType(fileloc.getType());
            if (loctype == null) {
                System.out.println("[ModeUploadProcess] '" + fileloc.getType() + "' file location type not found for " + this.root.getName());
                return 4;
            }
            FileLocTypeProvider oloctype = loctype;
            if (oloctype instanceof FileLocationRegistry) {
                ((FileLocationRegistry)oloctype).register(fileloc);
            }
            String filetype = conf.getProperty(FileUploadItem.CONF_FILE_TYPE);
            StringBuilder sb = new StringBuilder();
            if (filedir != null && filedir.trim().length() > 0) {
                sb.append(filedir.trim());
            }
            if (sb.length() > 0 && !sb.toString().endsWith("/")) {
                sb.append("/");
            }
            sb.append(this.root.getName());
            if (filetype != null && filetype.trim().length() > 0 && !filetype.trim().equals("*")) {
                sb.append(".").append(filetype.trim());
            }
            this.sess = loctype.createUploadSession();
            this.sess.setFile(this.root.getContentFile().getFile());
            this.sess.setLocationConfigId(filelocid);
            this.sess.setTargetName(sb.toString());
            this.sess.setOffset(filepos);
            TransferHandler th = new TransferHandler();
            th.proc = this;
            this.sess.setHandler((FileTransferSession.Handler)th);
            this.sess.run();
            return 1;
        }

        private Throwable getNonRuntimeException(Throwable t) {
            if (t instanceof RuntimeException) {
                Throwable c = t.getCause();
                if (c == null) {
                    return t;
                }
                return this.getNonRuntimeException(c);
            }
            return t;
        }

        private void pause(long millis) {
            try {
                if (this.queue == null) {
                    this.queue = new LinkedBlockingQueue();
                }
                this.queue.poll(millis, TimeUnit.MILLISECONDS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class ModeTempCopyProcess
    extends FileUploadItemProc {
        FileUploadItem root;

        private ModeTempCopyProcess() {
            this.root = FileUploadItem.this;
        }

        @Override
        public void run() {
            boolean completed = false;
            boolean success = false;
            String message = null;
            block3: while (true) {
                try {
                    String status;
                    do {
                        if (this.isCancelled()) {
                            throw new InterruptedException();
                        }
                        status = this.runImpl();
                        if ("no_file_source".equals(status)) {
                            message = "no source file specified in the conf";
                            this.root.createTempFile(".error", message);
                            this.root.removeTempFile(".tempcopy");
                            completed = true;
                            break block3;
                        }
                        if (!"source_file_not_exist".equals(status)) continue;
                        message = "source file does not exist";
                        this.root.createTempFile(".error", message);
                        this.root.removeTempFile(".tempcopy");
                        completed = true;
                        break block3;
                    } while (!"success".equals(status));
                    this.root.createTempFile(".upload");
                    this.root.removeTempFile(".tempcopy");
                    this.root.removeTempFile(".error");
                    message = "success";
                    completed = true;
                    success = true;
                }
                catch (InterruptedException ie) {
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
            if (completed) {
                this.fireOnCompleted(success, message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String runImpl() throws Exception {
            ConfigFile conf = this.root.getConfigFile();
            String strsource = conf.getProperty(FileUploadItem.CONF_FILE_SOURCE);
            if (strsource == null || strsource.trim().length() == 0) {
                return "no_file_source";
            }
            File sourcefile = new File(strsource = strsource.replace('\\', '/'));
            if (!sourcefile.exists()) {
                return "source_file_not_exist";
            }
            File targetfile = this.root.getContentFile().getFile();
            FileInputStream inp = null;
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(targetfile);
                inp = new FileInputStream(sourcefile);
                byte[] bytes = new byte[102400];
                int read = -1;
                while ((read = inp.read(bytes)) != -1) {
                    if (this.isCancelled()) {
                        throw new InterruptedException();
                    }
                    out.write(bytes, 0, read);
                }
                out.flush();
                StatusFile sf = this.root.getContentFile().getStatusFile();
                sf.setPos(0L);
                sf.changeMode(FileUploadItem.MODE_UPLOAD);
                String string = "success";
                return string;
            }
            finally {
                try {
                    inp.close();
                }
                catch (Throwable throwable) {}
                try {
                    out.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private class ModeReadyProcess
    extends FileUploadItemProc {
        FileUploadItem root;

        private ModeReadyProcess() {
            this.root = FileUploadItem.this;
        }

        @Override
        public void run() {
            boolean completed = false;
            boolean success = false;
            String message = null;
            try {
                if (this.isCancelled()) {
                    throw new InterruptedException();
                }
                this.root.createTempFile(".started");
                this.root.removeTempFile(".ready");
                success = true;
                completed = true;
                message = "success";
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (completed) {
                this.fireOnCompleted(success, message);
            }
        }
    }

    private class StatusFile {
        private File folder;
        private File file;
        private String mode;
        private Number numSize;
        private Number numPos;

        StatusFile(File folder, String name) {
            this.folder = folder;
            this.file = new File(folder, name);
        }

        String getMode() {
            return this.mode == null || this.mode.trim().length() == 0 ? FileUploadItem.MODE_TEMP_COPY : this.mode;
        }

        long getSize() {
            return this.numSize == null ? 0L : this.numSize.longValue();
        }

        long getPos() {
            return this.numPos == null ? 0L : this.numPos.longValue();
        }

        void setPos(long pos) {
            this.numPos = pos;
        }

        void create(String data) {
            OutputStream out = null;
            try {
                out = new FileOutputStream(this.file);
                out.write(data.getBytes());
                out.flush();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                try {
                    out.close();
                }
                catch (Throwable throwable) {}
            }
            this.read();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StatusFile read() {
            FileInputStream inp = null;
            try {
                inp = new FileInputStream(this.file);
                StringBuilder sb = new StringBuilder();
                byte[] bytes = new byte[1024];
                int read = -1;
                while ((read = inp.read(bytes)) != -1) {
                    sb.append(new String(bytes, 0, read));
                }
                this.mode = null;
                this.numSize = null;
                this.numPos = null;
                String[] arrs = sb.toString().replaceAll("[\\s]{1,}", "").split(",");
                if (arrs.length >= 1) {
                    this.mode = arrs[0];
                }
                if (arrs.length >= 2) {
                    this.numSize = this.convertNumber(arrs[1]);
                }
                if (arrs.length >= 3) {
                    this.numPos = this.convertNumber(arrs[2]);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    inp.close();
                }
                catch (Throwable throwable) {}
            }
            return this;
        }

        void update() {
            OutputStream out = null;
            try {
                String str = this.getMode() + "," + this.getSize() + "," + this.getPos();
                out = new FileOutputStream(this.file);
                out.write(str.getBytes());
                out.flush();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                try {
                    out.close();
                }
                catch (Throwable throwable) {}
            }
        }

        void changeMode(String mode) {
            if (mode == null) {
                mode = "";
            }
            this.mode = FileUploadItem.MODE_UPLOAD.equalsIgnoreCase(mode) ? FileUploadItem.MODE_UPLOAD : (FileUploadItem.MODE_COMPLETED.equalsIgnoreCase(mode) ? FileUploadItem.MODE_COMPLETED : FileUploadItem.MODE_TEMP_COPY);
            this.update();
        }

        Number convertNumber(Object value) {
            try {
                if (value instanceof Number) {
                    return (Number)value;
                }
                return new Long(value.toString());
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    public class ContentFile {
        private File folder;
        private File child;
        private StatusFile statusFile;

        ContentFile(File folder, String name) {
            this.folder = folder;
            this.child = new File(folder, name);
            this.statusFile = new StatusFile(folder, name + ".index");
        }

        public File getFile() {
            return this.child;
        }

        StatusFile getStatusFile() {
            return this.statusFile;
        }

        public boolean isModeTempCopy() {
            String sval = this.getStatusFile().getMode();
            if (sval == null || sval.trim().length() == 0) {
                return true;
            }
            return FileUploadItem.MODE_TEMP_COPY.equalsIgnoreCase(sval);
        }

        public boolean isModeUpload() {
            String sval = this.getStatusFile().getMode();
            return FileUploadItem.MODE_UPLOAD.equalsIgnoreCase(sval + "");
        }

        public boolean isModeCompleted() {
            String sval = this.getStatusFile().getMode();
            return FileUploadItem.MODE_COMPLETED.equalsIgnoreCase(sval + "");
        }
    }

    public class ConfigFile {
        private File folder;
        private File idxfile;
        private Map conf;

        ConfigFile(File folder, String name) {
            this.folder = folder;
            this.idxfile = new File(folder, name);
            this.conf = new HashMap();
        }

        void create(Map conf) {
            if (conf == null || conf.isEmpty()) {
                return;
            }
            this.conf.clear();
            this.conf.putAll(conf);
            this.update();
        }

        Map copyData() {
            HashMap<String, Number> data = new HashMap<String, Number>();
            data.putAll(this.conf);
            data.put(FileUploadItem.CONF_FILE_SIZE, this.getPropertyAsNumber(FileUploadItem.CONF_FILE_SIZE));
            return data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConfigFile read() {
            FileInputStream inp = null;
            try {
                inp = new FileInputStream(this.idxfile);
                Properties props = new Properties();
                props.load(inp);
                this.conf.clear();
                this.conf.putAll(props);
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    inp.close();
                }
                catch (Throwable throwable) {}
            }
            return this;
        }

        public void update() {
            FileOutputStream fos = null;
            try {
                StringBuilder sb = new StringBuilder();
                Set sets = this.conf.entrySet();
                for (Map.Entry entry : sets) {
                    String skey = entry.getKey() == null ? null : entry.getKey().toString();
                    if (skey == null || skey.trim().length() <= 0) continue;
                    String sval = entry.getValue() == null ? "" : entry.getValue().toString();
                    sb.append(skey).append("=").append(sval).append("\n");
                }
                fos = new FileOutputStream(this.idxfile);
                fos.write(sb.toString().replace('\\', '/').getBytes());
                fos.flush();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }

        public String getProperty(String name) {
            Object value = this.conf.get(name);
            return value == null ? null : value.toString();
        }

        public Number getPropertyAsNumber(String name) {
            try {
                String value = this.getProperty(name);
                return new Long(value);
            }
            catch (Throwable t) {
                return null;
            }
        }

        public void setProperty(String name, Object value) {
            this.conf.put(name, value);
        }
    }
}

