/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt;

import com.rameses.filemgmt.FileLocationConf;
import com.rameses.filemgmt.FileLocationProvider;
import com.rameses.filemgmt.FileManager;
import com.rameses.filemgmt.FileUploadItem;
import com.rameses.filemgmt.FileUploadItemProc;
import com.rameses.filemgmt.FileUploadProvider;
import com.rameses.filemgmt.FileUploadProviderImpl;
import com.rameses.filemgmt.RunProc;
import com.rameses.io.FileLocType;
import com.rameses.io.FileLocTypeProvider;
import com.rameses.io.FileTransferSession;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;

public final class FileUploadManager {
    private static final Object INIT_LOCKED = new Object();
    private static FileUploadManager instance = null;
    private File tempdir;
    private Helper helper = new Helper();
    private FileUploadProvider fileUploadProvider;
    private FileHandlers fileHandlers;
    private ExecutorService threadPool;
    private ScheduledExecutorService scheduler;
    private Map<String, String> cache = new HashMap<String, String>();
    private static final Object STATUS_LOCKED = new Object();
    private static final Object CACHE_LOCKED = new Object();
    private boolean started;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileUploadManager getInstance() {
        Object object = INIT_LOCKED;
        synchronized (object) {
            if (instance == null) {
                instance = new FileUploadManager();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reset() {
        Object object = INIT_LOCKED;
        synchronized (object) {
            FileUploadManager fum = new FileUploadManager();
            if (instance != null) {
                instance.stop();
            }
            instance = fum;
        }
    }

    private FileUploadManager() {
        this.fileHandlers = new FileHandlers();
        this.threadPool = Executors.newFixedThreadPool(100);
        this.scheduler = Executors.newScheduledThreadPool(10);
        this.fileUploadProvider = new FileUploadProviderImpl();
    }

    @Deprecated
    public boolean isEnabled() {
        return FileManager.getInstance().isEnableUpload();
    }

    @Deprecated
    public void setEnabled(boolean enabled) {
        FileManager.getInstance().setEnableUpload(enabled);
    }

    public void setTempDir(File tempdir) {
        this.tempdir = tempdir;
    }

    public File getTempDir() {
        return this.getTempDir("fileupload");
    }

    File getTempDir(String group) {
        return FileManager.getInstance().getHelper().getTempDir(group);
    }

    @Deprecated
    public FileLocationProvider getLocationProvider() {
        return FileManager.getInstance().getLocationProvider();
    }

    @Deprecated
    public void setLocationProvider(FileLocationProvider fileLocProvider) {
        FileManager.getInstance().setLocationProvider(fileLocProvider);
    }

    public FileUploadProvider getUploadProvider() {
        return this.fileUploadProvider;
    }

    public void setUploadProvider(FileUploadProvider fileUploadProvider) {
        this.fileUploadProvider = fileUploadProvider;
    }

    public Helper getHelper() {
        return this.helper;
    }

    public FileHandlers getFileHandlers() {
        return this.fileHandlers;
    }

    public FileLocTypeProvider getLocType(String name) {
        return FileManager.getInstance().getLocType(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Object object = STATUS_LOCKED;
        synchronized (object) {
            if (!this.isEnabled()) {
                System.out.println("FileUploadManager has been disabled");
                return;
            }
            if (this.started) {
                System.out.println("FileUploadManager has already been started");
                return;
            }
            System.out.println("Starting FileUploadManager...");
            new FileScanner().schedule();
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = STATUS_LOCKED;
        synchronized (object) {
            if (!this.isEnabled()) {
                System.out.println("FileUploadManager has been disabled");
                return;
            }
            System.out.println("Stopping FileUploadManager...");
            if (!this.started) {
                return;
            }
            this.shutdown(this.scheduler.shutdownNow());
            this.shutdown(this.threadPool.shutdownNow());
            this.cache.clear();
            this.started = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(FileUploadItem fui) {
        Object object = CACHE_LOCKED;
        synchronized (object) {
            if (fui == null) {
                return;
            }
            if (!fui.isImmediate() && !this.isEnabled()) {
                return;
            }
            FileUploadItemProc proc = null;
            String keyname = fui.getName();
            if (fui.isMarkedForRemoval()) {
                this.cache.remove(keyname);
                this.getFileHandlers().unregister(fui);
                proc = fui.createProcessHandler();
                if (proc != null) {
                    this.threadPool.submit(proc);
                }
                return;
            }
            if (fui.isModeCompleted()) {
                this.cache.remove(keyname);
                this.getFileHandlers().notifyOnCompleted(fui);
                this.getFileHandlers().unregister(fui);
                fui.remove();
                return;
            }
            proc = fui.createProcessHandler();
            if (proc == null) {
                this.cache.remove(keyname);
                this.getFileHandlers().unregister(fui);
                return;
            }
            if (this.cache.containsKey(keyname)) {
                return;
            }
            if (fui.isModeUpload()) {
                proc.setHandler(new FileItemProcHandler(fui));
            } else {
                proc.setHandler(new FileItemProcHandler(fui));
            }
            this.cache.put(keyname, keyname);
            this.threadPool.submit(proc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(FileUploadItem item) {
        Object object = CACHE_LOCKED;
        synchronized (object) {
            if (item == null) {
                return;
            }
            String keyname = item.getName();
            item.remove();
            this.cache.remove(keyname);
            this.getFileHandlers().unregister(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCache(String name) {
        Object object = CACHE_LOCKED;
        synchronized (object) {
            if (name != null) {
                this.cache.remove(name);
            }
        }
    }

    private void shutdown(List<Runnable> procs) {
        if (procs == null) {
            return;
        }
        while (!procs.isEmpty()) {
            Runnable r = procs.remove(0);
            if (!(r instanceof RunProc)) continue;
            try {
                ((RunProc)r).cancel();
            }
            catch (Throwable throwable) {}
        }
    }

    public class Helper {
        private FileUploadManager getRoot() {
            return FileUploadManager.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getFileSize(File file) throws Exception {
            RandomAccessFile raf = null;
            AbstractInterruptibleChannel fc = null;
            try {
                raf = new RandomAccessFile(file, "r");
                fc = raf.getChannel();
                long l = ((FileChannel)fc).size();
                return l;
            }
            finally {
                try {
                    fc.close();
                }
                catch (Throwable throwable) {}
                try {
                    raf.close();
                }
                catch (Throwable throwable) {}
            }
        }

        public File download(String filelocid, final String remoteName, String filetype) {
            File file = this.getDownloadFile(remoteName);
            String status = this.getDownloadStatus(remoteName);
            if ("completed".equals(status)) {
                return file;
            }
            FileLocationConf fileloc = FileManager.getInstance().getLocationConfs().get(filelocid);
            FileLocTypeProvider provider = FileLocType.getProvider((String)fileloc.getType());
            FileTransferSession sess = provider.createDownloadSession();
            sess.setLocationConfigId(filelocid);
            sess.setTargetName(remoteName + "." + filetype);
            sess.setFile(file);
            sess.setHandler(new FileTransferSession.Handler(){

                public void ontransfer(long bytesprocessed) {
                }

                public void ontransfer(long filesize, long bytesprocessed) {
                }

                public void oncomplete() {
                    try {
                        Helper.this.removeDownloadStatus(remoteName, "processing");
                        Helper.this.createDownloadStatus(remoteName, "completed");
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
            sess.run();
            return null;
        }

        public String getDownloadStatus(String name) {
            File file = new File(this.getRoot().getTempDir("filedownload"), name);
            if (!file.exists()) {
                return null;
            }
            if (new File(file, ".processing").exists()) {
                return "processing";
            }
            if (new File(file, ".completed").exists()) {
                return "completed";
            }
            return null;
        }

        public File createDownloadStatus(String name, String status) throws Exception {
            File file = new File(this.getRoot().getTempDir("filedownload"), name + "/." + status);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            return file;
        }

        public void removeDownloadStatus(String name, String status) throws Exception {
            File file = new File(this.getRoot().getTempDir("filedownload"), name + "/." + status);
            if (file.exists()) {
                file.delete();
            }
        }

        public File createDownloadFile(String name) throws Exception {
            this.createDownloadStatus(name, "processing");
            File file = new File(this.getRoot().getTempDir("filedownload"), name + "/content");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            return file;
        }

        public File getDownloadFile(String name) {
            return new File(this.getRoot().getTempDir("filedownload"), name + "/content");
        }

        void write(File file, String data) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                ((OutputStream)out).write(data.getBytes());
                out.flush();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                try {
                    ((OutputStream)out).close();
                }
                catch (Throwable throwable) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String read(File file) {
            String string;
            FileInputStream inp = null;
            try {
                inp = new FileInputStream(file);
                StringBuilder sb = new StringBuilder();
                byte[] bytes = new byte[1024];
                int read = -1;
                while ((read = inp.read(bytes)) != -1) {
                    sb.append(new String(bytes, 0, read));
                }
                string = sb.toString();
            }
            catch (Throwable t) {
                try {
                    String string2 = null;
                    return string2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        inp.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            try {
                inp.close();
                return string;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return string;
        }

        public ImageIcon getDownloadImage(String name) throws Exception {
            File file = this.getDownloadFile(name);
            return new ImageIcon(file.toURI().toURL());
        }
    }

    private class ValidFileFilter
    implements FileFilter {
        FileUploadManager root;

        private ValidFileFilter() {
            this.root = FileUploadManager.this;
        }

        @Override
        public boolean accept(File file) {
            if (!file.isDirectory()) {
                return false;
            }
            if (file.getName().endsWith("~")) {
                return false;
            }
            if (this.root.cache.containsKey(file.getName())) {
                return false;
            }
            File child = new File(file, ".error");
            if (child.exists()) {
                return false;
            }
            child = new File(file, ".ready");
            if (child.exists()) {
                return false;
            }
            child = new File(file, ".forremoval");
            if (child.exists()) {
                return true;
            }
            child = new File(file, ".completed");
            if (child.exists()) {
                return false;
            }
            child = new File(file, ".conf");
            if (!child.exists()) {
                return false;
            }
            child = new File(file, "content.index");
            if (!child.exists()) {
                return false;
            }
            child = new File(file, ".started");
            return child.exists();
        }
    }

    private class FileScanner
    implements RunProc {
        FileUploadManager root;
        boolean cancelled;

        private FileScanner() {
            this.root = FileUploadManager.this;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        void schedule() {
            this.root.scheduler.schedule(this, 1000L, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.cancelled) {
                    return;
                }
                this.runImpl();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                if (this.cancelled) {
                    return;
                }
                new FileScanner().schedule();
            }
        }

        private void runImpl() throws Exception {
            File[] files;
            if (FileManager.getInstance().getLocationConfs().isEmpty()) {
                return;
            }
            File tempdir = this.root.getTempDir();
            for (File file : files = tempdir.listFiles(new ValidFileFilter())) {
                FileUploadItem fui = FileUploadItem.open(file);
                this.root.schedule(fui);
            }
        }
    }

    private class FileHandlerProxy
    implements FileHandler {
        ArrayList<FileHandler> handlers = new ArrayList();

        private FileHandlerProxy() {
        }

        void clear() {
            this.handlers.clear();
        }

        void add(FileHandler handler) {
            if (handler != null && !this.handlers.contains(handler)) {
                this.handlers.add(handler);
            }
        }

        void remove(FileHandler handler) {
            if (handler != null) {
                this.handlers.remove(handler);
            }
        }

        @Override
        public void onTransfer(FileUploadItem item, long filesize, long bytesprocessed) {
            FileHandler[] arr = this.handlers.toArray(new FileHandler[0]);
            for (int i = 0; i < arr.length; ++i) {
                try {
                    arr[i].onTransfer(item, filesize, bytesprocessed);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void onCompleted(FileUploadItem item) {
            FileHandler[] arr = this.handlers.toArray(new FileHandler[0]);
            for (int i = 0; i < arr.length; ++i) {
                try {
                    arr[i].onCompleted(item);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static interface FileHandler {
        public void onTransfer(FileUploadItem var1, long var2, long var4);

        public void onCompleted(FileUploadItem var1);
    }

    public class FileHandlers {
        private final Object LOCKED = new Object();
        private final Map<String, FileHandlerProxy> handlers = new HashMap<String, FileHandlerProxy>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register(FileUploadItem item) {
            Object object = this.LOCKED;
            synchronized (object) {
                if (item == null) {
                    return;
                }
                this.handlers.put(item.getName(), new FileHandlerProxy());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregister(FileUploadItem item) {
            Object object = this.LOCKED;
            synchronized (object) {
                if (item == null) {
                    return;
                }
                FileHandlerProxy proxy = this.handlers.remove(item.getName());
                if (proxy != null) {
                    proxy.clear();
                }
            }
        }

        public void add(FileUploadItem item, FileHandler handler) {
            if (item == null || handler == null) {
                return;
            }
            FileHandlerProxy proxy = this.handlers.get(item.getName());
            if (proxy != null) {
                proxy.add(handler);
            }
        }

        public void remove(FileUploadItem item, FileHandler handler) {
            if (item == null || handler == null) {
                return;
            }
            FileHandlerProxy proxy = this.handlers.get(item.getName());
            if (proxy != null) {
                proxy.remove(handler);
            }
        }

        public void notifyOnTransfer(FileUploadItem item, long filesize, long bytesprocessed) {
            FileHandlerProxy proxy = this.handlers.get(item.getName());
            if (proxy != null) {
                proxy.onTransfer(item, filesize, bytesprocessed);
            }
        }

        public void notifyOnCompleted(FileUploadItem item) {
            FileHandlerProxy proxy = this.handlers.get(item.getName());
            if (proxy != null) {
                proxy.onCompleted(item);
            }
        }
    }

    private class FileItemProcHandler
    implements FileUploadItemProc.Handler {
        private FileUploadItem item;

        FileItemProcHandler(FileUploadItem item) {
            this.item = item;
        }

        @Override
        public void onCompleted(boolean success, String message) {
            if (this.item == null) {
                return;
            }
            FileUploadManager.this.removeCache(this.item.getName());
            if (success) {
                FileUploadManager.this.schedule(this.item);
            }
        }
    }
}

