/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt.components;

import com.rameses.rcp.control.layout.SplitterLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class SplitterPanel
extends JPanel
implements SplitterLayout.Canvas {
    private Rectangle viewRect;
    private Rectangle dividerRect;
    private Point targetPoint;
    private SplitterLayout layout;

    public SplitterPanel() {
        this.initComponents();
    }

    public int getDividerSize() {
        return this.layout == null ? 0 : this.layout.getDividerSize();
    }

    public void setDividerSize(int dividerSize) {
        if (this.layout != null) {
            this.layout.setDividerSize(dividerSize);
            this.revalidate();
            this.repaint();
        }
    }

    public int getDividerLocation() {
        return this.layout == null ? 0 : this.layout.getDividerLocation();
    }

    public void setDividerLocation(int dividerLocation) {
        if (this.layout != null) {
            this.layout.setDividerLocation(dividerLocation);
            this.revalidate();
            this.repaint();
        }
    }

    public void setSideView(Component comp) {
        if (comp == null) {
            return;
        }
        this.add("sideview", comp);
    }

    public void setContentView(Component comp) {
        if (comp == null) {
            return;
        }
        this.add("contentview", comp);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.dividerRect != null && this.targetPoint != null) {
            Rectangle newRect = new Rectangle();
            newRect.x = this.dividerRect.x;
            newRect.y = this.dividerRect.y;
            newRect.width = this.dividerRect.width;
            newRect.height = this.dividerRect.height;
            newRect.x = this.dividerRect.x + this.targetPoint.x;
            Color oldColor = g.getColor();
            Color newColor = this.getBackground();
            newColor = newColor == null ? Color.DARK_GRAY : newColor.darker();
            Graphics gg = g.create();
            gg.setColor(newColor);
            gg.fillRect(newRect.x, newRect.y, newRect.width, newRect.height);
            gg.setColor(oldColor);
            this.dividerRect = null;
            this.targetPoint = null;
        }
    }

    public void paintDividerHandle(Rectangle viewRect, Rectangle dividerRect, Point targetPoint) {
        this.viewRect = viewRect;
        this.dividerRect = dividerRect;
        this.targetPoint = targetPoint;
        this.repaint();
    }

    private void initComponents() {
        this.layout = new SplitterLayout();
        this.setLayout((LayoutManager)this.layout);
    }
}

