/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt.components;

import com.rameses.filemgmt.FileManager;
import com.rameses.osiris2.client.Inv;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.ThumbnailViewModel;
import com.rameses.rcp.control.XPanel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.Base64Cipher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ThumbnailViewPanel
extends XPanel {
    private Dimension cellSize;
    private int cellSpacing;
    private Object selectedItem;
    private String handler;
    private boolean multiSelect;
    private ListModelImpl listModel;
    private ThumbnailViewModel model;
    private JScrollPane jscroll;
    private JList jlist;

    public ThumbnailViewPanel() {
        this.initComponents();
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public final Dimension getDefaultCellSize() {
        return new Dimension(75, 75);
    }

    public Dimension getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(Dimension cellSize) {
        if (cellSize == null) {
            cellSize = this.getDefaultCellSize();
        }
        this.cellSize = cellSize;
        this.updateFixedCellSize();
    }

    public int getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellSpacing(int cellSpacing) {
        this.cellSpacing = Math.max(cellSpacing, 0);
        this.updateFixedCellSize();
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
        if (this.jlist != null) {
            this.jlist.setSelectionMode(this.isMultiSelect() ? 2 : 0);
        }
    }

    private void updateFixedCellSize() {
        if (this.jlist != null) {
            Dimension size = this.getCellSize();
            int spacing = this.getCellSpacing();
            this.jlist.setFixedCellWidth(size.width + spacing);
            this.jlist.setFixedCellHeight(size.height + spacing);
        }
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(Object selectedItem) {
        this.selectedItem = selectedItem;
    }

    public ThumbnailViewModel getModel() {
        return this.model;
    }

    public void setModel(ThumbnailViewModel newModel) {
        if (newModel == null) {
            newModel = new ThumbnailViewModel();
        }
        newModel.setProvider(new ProviderImpl());
        this.model = newModel;
        this.listModel = new ListModelImpl();
        this.listModel.init();
        this.jlist.setModel(this.listModel);
    }

    public void clearItems() {
        this.setSelectedItem(null);
        this.removeAll();
        this.revalidate();
        this.repaint();
    }

    public void load() {
        super.load();
        Object handlerObj = null;
        String shandler = this.getHandler();
        if (shandler != null && shandler.trim().length() > 0) {
            handlerObj = UIControlUtil.getBeanValue((Binding)this.getBinding(), (String)shandler);
        }
        if (handlerObj instanceof ThumbnailViewModel) {
            this.setModel((ThumbnailViewModel)handlerObj);
        } else {
            this.setModel(null);
        }
    }

    public void refresh() {
        super.refresh();
        if (this.listModel != null) {
            this.listModel.init();
            this.listModel.fireDataChanged();
        }
    }

    private void selectedItemChanged(final Object value) {
        Runnable proc = new Runnable(){

            @Override
            public void run() {
                String sname = ThumbnailViewPanel.this.getName();
                if (sname == null || sname.trim().length() == 0) {
                    return;
                }
                Binding binding = ThumbnailViewPanel.this.getBinding();
                if (binding == null) {
                    return;
                }
                UIControlUtil.setBeanValue((Binding)binding, (String)sname, (Object)value);
                binding.getValueChangeSupport().notify(sname, value);
                binding.notifyDepends(sname);
            }
        };
        EventQueue.invokeLater(proc);
    }

    private void initComponents() {
        this.setLayout(new MainLayoutManager());
        this.setPreferredSize(new Dimension(200, 100));
        this.listModel = new ListModelImpl();
        this.model = new ThumbnailViewModel();
        this.jlist = new JList();
        this.jlist.setVisibleRowCount(-1);
        this.jlist.setLayoutOrientation(2);
        this.jlist.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jlist.setCellRenderer(new ListRendererImpl());
        this.jlist.setSelectionMode(0);
        this.jlist.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object[] values;
                boolean multi = ThumbnailViewPanel.this.jlist.getSelectionMode() == 2;
                ArrayList<Object> list = new ArrayList<Object>();
                for (Object v : values = ThumbnailViewPanel.this.jlist.getSelectedValues()) {
                    if (v instanceof ItemInfo) {
                        v = ((ItemInfo)v).userObject;
                    }
                    list.add(v);
                }
                ArrayList<Object> value = null;
                if (!list.isEmpty()) {
                    value = multi ? list : list.remove(0);
                }
                ThumbnailViewPanel.this.setSelectedItem(value);
                ThumbnailViewPanel.this.selectedItemChanged(value);
            }
        });
        ListMouseHandler mouseHandler = new ListMouseHandler();
        this.jlist.addMouseListener(mouseHandler);
        this.jlist.addMouseMotionListener(mouseHandler);
        this.jscroll = new JScrollPane();
        this.jscroll.setViewportView(this.jlist);
        this.setCellSize(new Dimension(100, 100));
        this.setCellSpacing(5);
        this.add(this.jscroll);
        if (Beans.isDesignTime()) {
            this.setModel(new TestViewModel());
        }
    }

    private class MainLayoutManager
    implements LayoutManager {
        ThumbnailViewPanel root;

        private MainLayoutManager() {
            this.root = ThumbnailViewPanel.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return this.getLayoutSize(parent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return this.getLayoutSize(parent);
            }
        }

        private Dimension getLayoutSize(Container parent) {
            Dimension dim = this.root.getCellSize();
            int w = dim.width;
            int h = dim.height;
            Insets margin = parent.getInsets();
            return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                ThumbnailViewPanel.this.jscroll.setBounds(x, y, w, h);
            }
        }
    }

    private class ThumbnailItem
    extends JLabel {
        ThumbnailViewPanel root;
        private Color focusInBorderColor;
        private Color focusOutBorderColor;
        private Color hoverBorderColor;
        private boolean hasfocus;
        private boolean hasMouseFocus;
        private ItemInfo info;
        private boolean selected;
        private int labelHeight;
        private JLabel label;

        ThumbnailItem() {
            this.root = ThumbnailViewPanel.this;
            this.setHorizontalAlignment(0);
            this.labelHeight = 20;
            this.focusInBorderColor = Color.BLUE;
            this.focusOutBorderColor = Color.decode("#afafaf");
            this.hoverBorderColor = Color.decode("#D3D8FF");
            this.label = new JLabel();
            this.label.setHorizontalAlignment(0);
            this.label.setVerticalAlignment(1);
            Font font = this.getFont();
            if (font != null) {
                this.label.setFont(font.deriveFont(10.0f));
            }
        }

        public ItemInfo getInfo() {
            return this.info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            int spacing = ThumbnailViewPanel.this.getCellSpacing();
            int w = this.getWidth() - spacing;
            int h = this.getHeight() - spacing;
            Graphics2D g2 = null;
            ItemInfo info = this.getInfo();
            if (info.hasImage()) {
                Rectangle rect = this.scaleToFitRect();
                g2 = (Graphics2D)g.create();
                try {
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.drawImage(info.image.getImage(), rect.x, rect.y, rect.width, rect.height, null);
                }
                finally {
                    g2.dispose();
                }
            }
            g2 = (Graphics2D)g.create();
            try {
                if (this.selected) {
                    g2.setColor(this.focusInBorderColor);
                } else {
                    g2.setColor(this.focusOutBorderColor);
                }
                g2.drawRect(0, 0, w - 1, h - 1);
                if (this.selected) {
                    g2.setColor(this.hoverBorderColor);
                    g2.drawRect(1, 1, w - 3, h - 3);
                }
            }
            finally {
                g2.dispose();
            }
        }

        private Rectangle scaleToFitRect() {
            int cw;
            double scaleX;
            ImageIcon iicon = this.getInfo().image;
            if (iicon == null) {
                return null;
            }
            Dimension cellsize = this.root.getCellSize();
            int iw = iicon.getIconWidth();
            int ch = cellsize.height;
            int ih = iicon.getIconHeight();
            double scaleY = (double)ch / (double)ih;
            double scale = scaleY > (scaleX = (double)(cw = cellsize.width) / (double)iw) ? scaleX : scaleY;
            int nw = (int)((double)iw * scale);
            int nh = (int)((double)ih * scale);
            int nx = cw / 2 - nw / 2;
            int ny = ch / 2 - nh / 2;
            return new Rectangle(nx, ny, nw, nh);
        }
    }

    public class ItemInfo {
        public String title;
        public String filetype;
        public Object thumbnail;
        public Object userObject;
        private ImageIcon image;

        boolean hasImage() {
            return this.image != null;
        }
    }

    private class TestViewModel
    extends ThumbnailViewModel {
        private List<Map> items = new ArrayList<Map>();

        TestViewModel() {
            this.items.add(this.createData("item1", "Document 1"));
            this.items.add(this.createData("item2", "Document 2"));
            this.items.add(this.createData("item3", "Document 3"));
        }

        private Map createData(String objid, String caption) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("objid", objid);
            m.put("caption", caption);
            return m;
        }

        @Override
        public List fetchList(Map params) {
            return this.items;
        }

        @Override
        public String getFileType(Object item) {
            return "docx";
        }
    }

    private class ProviderImpl
    implements ThumbnailViewModel.Provider {
        ThumbnailViewPanel root;

        private ProviderImpl() {
            this.root = ThumbnailViewPanel.this;
        }

        @Override
        public Binding getBinding() {
            return this.root.getBinding();
        }

        @Override
        public void addItem(Object item) {
            int index = this.root.listModel.addItem(item);
            if (index >= 0) {
                this.root.listModel.fireItemAdded(index);
            }
        }
    }

    private class ListRendererImpl
    implements ListCellRenderer {
        private ThumbnailItem comp;

        ListRendererImpl() {
            this.comp = new ThumbnailItem();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.comp.info = (ItemInfo)value;
            this.comp.selected = isSelected;
            this.comp.hasfocus = cellHasFocus;
            return this.comp;
        }
    }

    private class ListModelImpl
    extends AbstractListModel {
        ThumbnailViewPanel root;
        ArrayList<ItemInfo> items;
        ThumbnailViewModel tvm;
        Base64Cipher base64;
        List sourcelist;

        private ListModelImpl() {
            this.root = ThumbnailViewPanel.this;
            this.items = new ArrayList();
        }

        void clear() {
            this.items.clear();
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        @Override
        public Object getElementAt(int index) {
            if (index >= 0 && index < this.getSize()) {
                return this.items.get(index);
            }
            return null;
        }

        void init() {
            this.clear();
            this.tvm = this.root.getModel();
            this.sourcelist = this.tvm.fetchList(new HashMap());
            if (this.sourcelist == null) {
                return;
            }
            this.base64 = new Base64Cipher();
            for (int i = 0; i < this.sourcelist.size(); ++i) {
                Object item = this.sourcelist.get(i);
                if (item == null) continue;
                this.addItem(item);
            }
        }

        void fireDataChanged() {
            this.fireContentsChanged(this.root.jlist, 0, this.getSize());
        }

        void fireItemAdded(int index) {
            if (index >= 0 && index < this.getSize()) {
                this.fireIntervalAdded(this.root.jlist, index, index);
            }
        }

        int addItem(Object item) {
            ItemInfo info = new ItemInfo();
            info.userObject = item;
            info.title = this.tvm.getTitle(item);
            info.filetype = this.tvm.getFileType(item);
            Object thumbnailObj = this.tvm.getThumbnail(item);
            if (thumbnailObj instanceof String) {
                thumbnailObj = this.base64.isEncoded(thumbnailObj.toString()) ? this.base64.decode(thumbnailObj.toString(), false) : null;
            } else if (!(thumbnailObj instanceof byte[]) && !(thumbnailObj instanceof Image)) {
                thumbnailObj = null;
            }
            if (thumbnailObj instanceof byte[]) {
                info.image = new ImageIcon((byte[])thumbnailObj);
            } else if (thumbnailObj instanceof Image) {
                info.image = new ImageIcon((Image)thumbnailObj);
            } else {
                info.image = FileManager.getInstance().getFileTypeIcon(info.filetype);
            }
            this.items.add(info);
            return this.items.size() - 1;
        }
    }

    private class ListMouseHandler
    extends MouseAdapter {
        ThumbnailViewPanel root;

        private ListMouseHandler() {
            this.root = ThumbnailViewPanel.this;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                Point p = e.getPoint();
                int index = this.root.jlist.locationToIndex(p);
                if (index < 0) {
                    return;
                }
                if (e.isControlDown()) {
                    return;
                }
                Rectangle rect = this.root.jlist.getCellBounds(index, index);
                if (!rect.contains(p)) {
                    return;
                }
                int[] indexes = this.root.jlist.getSelectedIndices();
                if (indexes.length > 1) {
                    return;
                }
                this.openItem(index);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = e.getPoint();
            int index = this.root.jlist.locationToIndex(p);
            if (index < 0) {
                return;
            }
            Rectangle rect = this.root.jlist.getCellBounds(index, index);
            if (!rect.contains(p)) {
                return;
            }
        }

        void openItem(int index) {
            Object data = ((ThumbnailViewPanel)this.root).listModel.items.get((int)index).userObject;
            Object outcome = this.root.getModel().openItem(data);
            if (outcome instanceof Opener) {
                Opener op = (Opener)outcome;
                String target = op.getTarget();
                if (target == null || target.trim().length() == 0) {
                    op.setTarget("popup");
                }
                try {
                    Inv.invoke((Opener)op);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

