/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt.controls;

import com.rameses.filemgmt.controls.IconListPaneModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class IconListPaneRenderer
extends JPanel
implements ListCellRenderer {
    private Cell cell;

    public IconListPaneRenderer() {
        super(new BorderLayout());
        this.setOpaque(false);
        this.setBorder(new EmptyBorder(10, 10, 5, 0));
        this.cell = new Cell();
        this.add((Component)this.cell, "North");
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setFont(list.getFont());
        IconListPaneModel.Item item = (IconListPaneModel.Item)value;
        IconListPaneModel model = (IconListPaneModel)list.getModel();
        this.cell.update(list, item, model, index, isSelected, cellHasFocus);
        return this;
    }

    class CellBorder
    extends AbstractBorder {
        private Color color;
        private Color shadow;

        public CellBorder(Color color) {
            this(color, null);
        }

        public CellBorder(Color color, Color shadow) {
            this.color = color;
            this.shadow = shadow;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, null);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets ins) {
            if (ins == null) {
                ins = new Insets(0, 0, 0, 0);
            }
            int top = ins.top + 2;
            int left = ins.left + 2;
            int bottom = ins.bottom + 2;
            int right = ins.right + 2;
            return new Insets(top, left, bottom, right);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.color == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.color);
            g2.drawLine(x, y, width - 1, y);
            g2.drawLine(x, y, x, height - 1);
            g2.drawLine(x, height - 1, width - 1, height - 1);
            g2.drawLine(width - 1, y, width - 1, height - 1);
            if (this.shadow != null) {
                g2.setColor(this.shadow);
                g2.drawLine(x + 1, y + 1, width - 2, y + 1);
                g2.drawLine(x + 1, y + 1, x + 1, height - 2);
                g2.drawLine(x + 1, height - 2, width - 2, height - 2);
                g2.drawLine(width - 2, y + 1, width - 2, height - 2);
            }
            g2.dispose();
        }
    }

    class Cell
    extends JPanel {
        private JLabel lblTitle;
        private JLabel lblIcon;
        private Border defaultBorder;
        private Border selectionBorder;

        public Cell() {
            super(new BorderLayout());
            this.initComponent();
        }

        void initComponent() {
            this.setOpaque(false);
            this.lblIcon = new JLabel();
            this.lblIcon.setHorizontalAlignment(0);
            this.add((Component)this.lblIcon, "North");
            this.lblTitle = new JLabel();
            this.lblTitle.setHorizontalAlignment(0);
            this.lblTitle.setBorder(new EmptyBorder(5, 3, 5, 3));
            this.add((Component)this.lblTitle, "South");
            this.defaultBorder = new CellBorder(new Color(180, 180, 180));
            this.setBorder(this.defaultBorder);
            Color color = Color.decode("#1967d2");
            Color color2 = new Color(180, 180, 180, 100);
            this.selectionBorder = new CellBorder(color, color2);
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 40);
            this.lblTitle.setBackground(color);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.lblIcon != null) {
                this.lblIcon.setFont(font);
            }
            if (this.lblTitle != null) {
                this.lblTitle.setFont(font);
            }
        }

        void update(JList list, IconListPaneModel.Item item, IconListPaneModel model, int index, boolean isSelected, boolean cellHasFocus) {
            this.setFont(list.getFont());
            Dimension dim = model.getConf().getCellSize();
            this.lblIcon.setPreferredSize(dim);
            this.lblIcon.setMinimumSize(dim);
            this.lblIcon.setMaximumSize(dim);
            this.lblIcon.setIcon(item.getIcon());
            if (isSelected) {
                this.setBorder(this.selectionBorder);
            } else {
                this.setBorder(this.defaultBorder);
            }
            this.lblTitle.setOpaque(isSelected);
            this.lblTitle.setText(item.getTitle());
            this.lblTitle.setVisible(model.getConf().isShowCaption());
        }
    }
}

