/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.io.IOStream;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public abstract class AbstractFileDownloader {
    private JFileChooser jfc;
    final Map<String, FileFilterImpl> file_filters = new HashMap<String, FileFilterImpl>();

    public abstract void save(File var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(URL url, File file) throws Exception {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            IOStream.write((URL)url, (OutputStream)fos);
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(InputStream inp, File file) throws Exception {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            IOStream.write((InputStream)inp, (OutputStream)fos);
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    final JFileChooser getFileChooser() {
        if (this.jfc == null) {
            this.jfc = new JFileChooser();
            this.jfc.setDialogTitle("Select Download Location");
            this.jfc.setMultiSelectionEnabled(false);
        }
        return this.jfc;
    }

    final File showSaveDialog(String filetype, String filename) {
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (win == null) {
            win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        File file = null;
        FileFilterImpl filter = null;
        String skey = filetype == null ? "" : filetype.toLowerCase();
        this.getFileChooser().setSelectedFile(null);
        if (filename != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(filename);
            if (!filename.endsWith("." + skey)) {
                sb.append(".").append(skey);
            }
            File dir = new File(System.getProperty("user.dir", System.getProperty("user.home")));
            file = new File(dir, sb.toString());
        }
        if (skey.equals("") || skey.equals("*")) {
            this.getFileChooser().setAcceptAllFileFilterUsed(true);
        } else {
            filter = this.file_filters.get(skey);
            if (filter == null) {
                filter = new FileFilterImpl();
                filter.filetype = filetype;
                filter.searchkey = "*." + skey;
                filter.title = filetype.toUpperCase() + " (" + filter.searchkey + ")";
                this.file_filters.put(skey, filter);
            }
            this.getFileChooser().setAcceptAllFileFilterUsed(false);
        }
        for (FileFilterImpl ff : this.file_filters.values()) {
            this.getFileChooser().removeChoosableFileFilter(ff);
        }
        if (filter != null) {
            this.getFileChooser().addChoosableFileFilter(filter);
        }
        if (file != null) {
            this.getFileChooser().setSelectedFile(file);
        }
        int opt = this.getFileChooser().showSaveDialog(win);
        if (filter != null) {
            this.getFileChooser().removeChoosableFileFilter(filter);
        }
        if (opt == 0) {
            return this.getFileChooser().getSelectedFile();
        }
        return null;
    }

    class FileFilterImpl
    extends FileFilter {
        private String title;
        private String filetype;
        private String searchkey;

        FileFilterImpl() {
        }

        @Override
        public String getDescription() {
            return this.title;
        }

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(this.searchkey);
        }
    }
}

