/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.gov.etracs.rptis.util;

import com.rameses.util.Base64Cipher;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;

public class ObjectWriter {
    private File file;
    private Writer writer;

    public ObjectWriter(File file) throws Exception {
        this.file = file;
        if (file.exists()) {
            file.delete();
            file.createNewFile();
        }
        this.writer = new FileWriter(file, true);
    }

    public void writeObject(Object obj) throws Exception {
        String base64Str = this.toBase64(obj);
        this.writer.write(base64Str);
    }

    public void close() throws Exception {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public void cancel() throws Exception {
        this.close();
        if (this.file.exists()) {
            System.out.println("deleting...");
            System.out.println(this.file.delete());
        }
    }

    private String toBase64(Object obj) {
        String s = new Base64Cipher().encode(obj);
        s = s + "\n";
        return s;
    }
}

