/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.common.PropertyResolver;
import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.common.Column;
import com.rameses.rcp.common.ComboBoxColumnHandler;
import com.rameses.rcp.common.ListItem;
import com.rameses.rcp.common.ListItemStatus;
import com.rameses.rcp.common.LookupColumnHandler;
import com.rameses.rcp.common.MultiSelectionSupport;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.OpenerColumnHandler;
import com.rameses.rcp.common.PropertyChangeHandler;
import com.rameses.rcp.common.PropertyChangeSupport;
import com.rameses.rcp.common.TableModelHandler;
import com.rameses.rcp.common.TableModelSupport;
import com.rameses.rcp.framework.ActionProvider;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.BreakException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractListDataProvider {
    public static final int FETCH_MODE_LOAD = 0;
    public static final int FETCH_MODE_REFRESH = 1;
    public static final int FETCH_MODE_RELOAD = 2;
    public static final int FETCH_MODE_RELOAD_ALL = 3;
    protected MultiSelectionSupport multiSelectionSupport;
    protected PropertyChangeSupport propertySupport;
    protected TableModelSupport tableModelSupport;
    protected MessageSupport messageSupport;
    private ListItemHandler listItemHandler;
    private Set checkedItems = new HashSet();
    private int fetchMode = 0;
    private String selectedColumn;
    private Column[] columns;
    private List dataList;
    private int fetchedRows;
    private int totalRows;
    private boolean processing;
    private boolean forceUpdate;
    private boolean autoResize = true;
    private boolean multiSelect;
    private Object multiSelectHandler;
    private String multiSelectFieldName;
    private List<ListItem> itemList = new ArrayList<ListItem>();
    private ListItem selectedItem;
    private Object selectedElement;
    private ListSelectionSupport selectionSupport;
    private ActionProvider actionProvider;
    private UIProvider _uiprovider;

    public AbstractListDataProvider() {
        this.propertySupport = new PropertyChangeSupport();
        this.tableModelSupport = new TableModelSupport();
        this.listItemHandler = new ListItemHandler();
        this.messageSupport = new MessageSupport();
    }

    public abstract List fetchList(Map var1);

    public final ListSelectionSupport getSelectionSupport() {
        if (this.selectionSupport == null) {
            this.selectionSupport = new ListSelectionSupport();
        }
        return this.selectionSupport;
    }

    public List<Map> getColumnList() {
        return null;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public void setColumns(Column[] columns) {
        this.columns = columns;
    }

    public Column[] initColumns(Column[] columns) {
        return columns;
    }

    public List<Map> getContextMenu(Object item, String columnName) {
        return null;
    }

    public Object callContextMenu(Object item, Object menuItem) {
        return null;
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    public MultiSelectionSupport getMultiSelectionSupport() {
        if (this.multiSelectionSupport == null) {
            this.multiSelectionSupport = new MultiSelectionSupport();
        }
        return this.multiSelectionSupport;
    }

    public int getMultiSelectMode() {
        return this.getMultiSelectionSupport().getSelectionMode();
    }

    public void setMultiSelectMode(int multiSelectMode) {
        this.getMultiSelectionSupport().setSelectionMode(multiSelectMode);
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public Object getMultiSelectHandler() {
        return this.multiSelectHandler;
    }

    public void setMultiSelectHandler(Object multiSelectHandler) {
        this.multiSelectHandler = multiSelectHandler;
    }

    public String getMultiSelectFieldName() {
        return this.multiSelectFieldName;
    }

    public void setMultiSelectFieldName(String multiSelectFieldName) {
        this.multiSelectFieldName = multiSelectFieldName;
    }

    public Column getPrimaryColumn() {
        return null;
    }

    public void removeHandler(TableModelHandler handler) {
        this.tableModelSupport.remove(handler);
    }

    public void addHandler(TableModelHandler handler) {
        this.tableModelSupport.add(handler);
    }

    public void removeHandler(PropertyChangeHandler handler) {
        this.propertySupport.remove(handler);
    }

    public void addHandler(PropertyChangeHandler handler) {
        this.propertySupport.add(handler);
    }

    protected void fetch(boolean forceLoad) {
        if (this.dataList == null || forceLoad) {
            HashMap params = new HashMap();
            this.onbeforeFetchList(params);
            ArrayList resultList = this.fetchList(params);
            if (resultList == null) {
                resultList = new ArrayList();
            }
            this.onafterFetchList(resultList);
            this.setDataList(resultList);
            this.fetchedRows = resultList.size();
        } else {
            this.fetchedRows = this.dataList == null ? 0 : this.dataList.size();
        }
        this.totalRows = this.fetchedRows;
        this.fillListItems(this.dataList, 0);
        if (this.selectedItem != null) {
            this.setSelectedItem(this.selectedItem.getIndex());
        }
        if (this.selectedItem == null) {
            this.setSelectedItem(0);
        }
    }

    private void fetchImpl() {
        try {
            this.propertySupport.firePropertyChange("loading", true);
            this.processing = true;
            boolean forceLoad = this.fetchMode == 0 || this.fetchMode == 2 || this.fetchMode == 3;
            this.fetch(forceLoad);
            if (this.fetchMode == 3) {
                this.tableModelSupport.fireTableDataProviderChanged();
            } else {
                this.tableModelSupport.fireTableDataChanged();
            }
            int index = this.selectedItem == null ? 0 : this.selectedItem.getIndex();
            this.tableModelSupport.fireTableRowSelected(index, false);
            this.tableModelSupport.fireTableRowsUpdated(index, index);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.processing = false;
            this.propertySupport.firePropertyChange("loading", false);
        }
    }

    public final boolean isProcessing() {
        return this.processing;
    }

    protected void onbeforeFetchList(Map params) {
    }

    protected void onafterFetchList(List resultList) {
    }

    public int getTopRow() {
        return 0;
    }

    public void setTopRow(int topRow) {
    }

    public int getMaxRows() {
        return this.getRowCount();
    }

    public int getRowCount() {
        return this.fetchedRows;
    }

    public int getRows() {
        return -1;
    }

    public boolean validRange(int index) {
        return index >= 0 && index < this.itemList.size();
    }

    public int getListItemCount() {
        return this.itemList.size();
    }

    public List<ListItem> getListItems() {
        return this.itemList;
    }

    public Object getListItemData(int index) {
        ListItem li = this.getListItem(index);
        return li == null ? null : li.getItem();
    }

    public ListItem getListItem(int index) {
        if (index >= 0 && index < this.itemList.size()) {
            return this.itemList.get(index);
        }
        return null;
    }

    public ListItem getListItemByRownum(int rownum) {
        for (int i = 0; i < this.itemList.size(); ++i) {
            if (this.itemList.get(i).getRownum() != rownum) continue;
            return this.itemList.get(i);
        }
        return null;
    }

    public ListItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(ListItem li) {
        int index = li == null ? -1 : li.getIndex();
        this.setSelectedItem(index);
    }

    public Object getSelectedElement() {
        return this.selectedElement;
    }

    public void setSelectedElement(Object selectedElement) {
        this.selectedElement = selectedElement;
    }

    protected void onselectedItemChanged(ListItem li) {
    }

    public void setSelectedItem(int index) {
        this.selectedItem = index >= 0 && index < this.itemList.size() ? this.itemList.get(index) : null;
        this.onselectedItemChanged(this.selectedItem);
        this.fireSelectedItemChanged();
    }

    protected ActionProvider getActionProvider() {
        if (this.actionProvider == null) {
            this.actionProvider = ClientContext.getCurrentContext().getActionProvider();
        }
        return this.actionProvider;
    }

    public boolean isAllowOpen() {
        return true;
    }

    protected Object openItem(Object item, String columnName) {
        return null;
    }

    @Deprecated
    protected Object onOpenItem(Object item, String columnName) {
        return this.openItem(item, columnName);
    }

    protected Map getOpenerParams(Object item) {
        return null;
    }

    protected Object lookupOpener(String actionType, Object item) {
        if (actionType == null || actionType.length() == 0) {
            return null;
        }
        ActionProvider aprovider = this.getActionProvider();
        if (aprovider == null) {
            return null;
        }
        HashMap<String, Object> actionParams = new HashMap<String, Object>();
        Map udfParams = this.getOpenerParams(item);
        if (udfParams != null) {
            actionParams.putAll(udfParams);
        }
        actionParams.put("entity", item);
        Opener opener = aprovider.lookupOpener(actionType, actionParams);
        if (opener == null) {
            return null;
        }
        String target = opener.getTarget();
        if (target == null) {
            opener.setTarget("popup");
        }
        return opener;
    }

    public final Object openSelectedItem() {
        Object item;
        if (!this.isAllowOpen()) {
            return null;
        }
        Object object = item = this.selectedItem == null ? null : this.selectedItem.getItem();
        if (item == null) {
            return null;
        }
        if (item instanceof Map) {
            Object opener;
            String sv;
            Object ov = ((Map)item).get("_filetype");
            String string = sv = ov == null ? null : ov.toString();
            if (sv != null && sv.length() > 0 && (opener = this.lookupOpener(sv.toLowerCase() + ":open", item)) != null) {
                return opener;
            }
        }
        return this.onOpenItem(item, this.selectedColumn);
    }

    public final void removeSelectedItem() {
        if (this.selectedItem == null) {
            return;
        }
        if (this.selectedItem.getState() == 0) {
            return;
        }
        int index = this.selectedItem.getIndex();
        this.messageSupport.removeErrorMessage(index);
        if (this.selectedItem.getState() == 2) {
            this.selectedItem.loadItem(null, 0);
            this.tableModelSupport.fireTableRowsUpdated(index, index);
        } else {
            ListItem firstLI = this.getListItem(0);
            int rownum = this.selectedItem.getRownum();
            this.dataList.remove(rownum);
            this.itemList.remove(index);
            rownum = firstLI == null ? 0 : firstLI.getRownum();
            this.fillListItems(this.dataList, rownum);
            this.selectedItem = null;
            this.tableModelSupport.fireTableDataChanged();
            this.tableModelSupport.fireTableRowSelected(index, true);
        }
    }

    public final void removeListItem(int index) {
        if (index >= 0 && index < this.itemList.size()) {
            this.itemList.remove(index);
            this.rebuildIndexes();
            this.tableModelSupport.fireTableRowsDeleted(index, index);
        }
    }

    public final String getSelectedColumn() {
        return this.selectedColumn;
    }

    public final void setSelectedColumn(String selectedColumn) {
        this.selectedColumn = selectedColumn;
    }

    protected void beforeLoad() {
    }

    protected void afterLoad() {
    }

    protected void dataChanged(Object stat) {
    }

    private void fireDataChanged() {
        ListItemStatus stat = this.createListItemStatus(null);
        this.dataChanged(stat);
    }

    private void loadImpl(int fetchModeOption) {
        this.beforeLoad();
        this.checkedItems.clear();
        this.fetchMode = fetchModeOption;
        this.selectionSupport = null;
        this.totalRows = 0;
        this.fetchImpl();
        this.fireDataChanged();
        this.afterLoad();
    }

    public void load() {
        this.loadImpl(0);
    }

    public void reload() {
        this.refresh(true);
    }

    public void reloadAll() {
        this.loadImpl(3);
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean forceLoad) {
        this.refreshImpl(forceLoad ? 2 : 1);
    }

    private void refreshImpl(int fetchMode) {
        this.fetchMode = fetchMode;
        this.fetchImpl();
        this.fireDataChanged();
    }

    public void fireStuctureChanged() {
        this.tableModelSupport.fireTableStructureChanged();
    }

    public final int getDataIndexByRownum(int rownum) {
        ListItem li = this.getListItemByRownum(rownum);
        if (li == null || li.getItem() == null) {
            return -1;
        }
        return this.dataList.indexOf(li.getItem());
    }

    public final int getDataListSize() {
        return this.dataList == null ? 0 : this.dataList.size();
    }

    public final List getDataList() {
        return this.dataList;
    }

    public final Object getData(int index) {
        if (this.dataList != null && index >= 0 && index < this.dataList.size()) {
            return this.dataList.get(index);
        }
        return null;
    }

    protected final void setDataList(List dataList) {
        this.dataList = dataList;
    }

    protected final void initDataListWhenNull() {
        if (this.dataList == null) {
            this.dataList = new ArrayList();
        }
    }

    public void moveBackRecord() {
        if (this.messageSupport.hasErrorMessages()) {
            return;
        }
        if (this.selectedItem == null) {
            return;
        }
        int idx = this.itemList.indexOf(this.selectedItem);
        if (idx - 1 >= 0) {
            this.setSelectedItem(idx - 1);
            this.refreshSelectedItem();
        }
    }

    public void moveNextRecord() {
        this.moveNextRecord(false);
    }

    public void moveNextRecord(boolean includesEmptyItem) {
        if (this.messageSupport.hasErrorMessages()) {
            return;
        }
        if (this.selectedItem == null) {
            return;
        }
        int idx = this.itemList.indexOf(this.selectedItem);
        if (idx >= 0 && idx + 1 < this.itemList.size() && (this.getListItemData(idx + 1) != null || includesEmptyItem)) {
            this.setSelectedItem(idx + 1);
            this.refreshSelectedItem();
        }
    }

    protected void finalize() throws Throwable {
        this.propertySupport.removeAll();
        this.tableModelSupport.removeAll();
        this.checkedItems.clear();
        this.itemList.clear();
        this.dataList = null;
        this.onfinalize();
    }

    protected void onfinalize() throws Throwable {
    }

    public MessageSupport getMessageSupport() {
        return this.messageSupport;
    }

    protected void onreplaceSelectedItem(Object oldItem, Object newItem) {
    }

    public void fireSelectedItemChanged() {
        this.propertySupport.firePropertyChange("selectedItemChanged", this.selectedItem);
    }

    public void fireFocusSelectedItem() {
        this.propertySupport.firePropertyChange("focusSelectedItem", this.selectedItem);
    }

    public boolean hasSelections() {
        return this.getSelectionSupport().hasSelections();
    }

    protected void beforeSelectItem(Object fact) {
    }

    protected void beforeSelectItem(Object item, boolean selected, int rowIndex) {
        HashMap<String, Object> fact = new HashMap<String, Object>();
        fact.put("selected", selected);
        fact.put("index", rowIndex);
        fact.put("data", item);
        this.beforeSelectItem(fact);
    }

    protected void afterSelectItem(Object fact) {
    }

    protected void afterSelectItem(Object item, boolean selected, int rowIndex) {
        HashMap<String, Object> fact = new HashMap<String, Object>();
        fact.put("selected", selected);
        fact.put("index", rowIndex);
        fact.put("data", item);
        this.afterSelectItem(fact);
    }

    protected void beforeSelectionChange(Object o) {
    }

    protected void afterSelectionChange(Object o) {
    }

    protected Object buildSelectionKey(Object o) {
        String str = this.getMultiSelectFieldName();
        if (str != null && str.trim().length() > 0) {
            String[] names = str.trim().split(",");
            if (names.length == 0) {
                return o;
            }
            PropertyResolver pr = PropertyResolver.getInstance();
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String sname : names) {
                sname = sname.trim();
                try {
                    map.put(sname, pr.getProperty(o, sname));
                }
                catch (Throwable t) {
                    map.put(sname, null);
                }
            }
            return map;
        }
        return o;
    }

    public final void fireBeforeSelectItem(Object item, boolean selected, int rowIndex) {
        this.beforeSelectItem(item, selected, rowIndex);
    }

    public final void fireAfterSelectItem(Object item, boolean selected, int rowIndex) {
        this.afterSelectItem(item, selected, rowIndex);
    }

    public void selectAll() {
        this.getMultiSelectionSupport().selectAll();
    }

    public void deselectAll() {
        this.getMultiSelectionSupport().deselectAll();
    }

    public boolean isColumnEditable(Object item, String columnName) {
        return false;
    }

    public Object onInvokeAction(Object item, String columnName, Map props) {
        return null;
    }

    public ListItemStatus createListItemStatus(ListItem oListItem) {
        ListItemStatus stat = new ListItemStatus(oListItem);
        stat.setPageIndex(1);
        stat.setPageCount(1);
        stat.setIsLastPage(true);
        stat.setHasNextPage(false);
        stat.setTotalRows(this.totalRows);
        return stat;
    }

    protected ListItem createCustomListItem() {
        return new ListItem();
    }

    public final ListItem createListItem() {
        ListItem li = this.createCustomListItem();
        li.addHandler(this.listItemHandler);
        return li;
    }

    protected ListItem getFirstItem() {
        try {
            return this.itemList.get(0);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isFirstItem(ListItem li) {
        if (li == null) {
            return false;
        }
        return this.isFirstItem(li.getIndex());
    }

    public boolean isFirstItem(int index) {
        return index == 0;
    }

    protected ListItem getLastItem() {
        try {
            return this.itemList.get(this.itemList.size() - 1);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isLastItem(ListItem li) {
        if (li == null) {
            return false;
        }
        return this.isLastItem(li.getIndex());
    }

    public boolean isLastItem(int index) {
        return index >= 0 && index == this.itemList.size() - 1;
    }

    public final void addEmptyItem() {
        ListItem lastLI = this.getLastItem();
        int index = lastLI == null ? 0 : lastLI.getIndex() + 1;
        int rownum = lastLI == null ? 0 : lastLI.getRownum() + 1;
        ListItem li = this.createListItem();
        li.setIndex(index);
        li.setRownum(rownum);
        li.loadItem(null, 0);
        this.itemList.add(li);
        this.tableModelSupport.fireTableRowsInserted(index, index);
    }

    protected final void buildListItems() {
        boolean dynamic;
        boolean bl = dynamic = this.getRows() == -1;
        if (!dynamic && this.itemList.size() == this.getRows()) {
            return;
        }
        this.itemList.clear();
        int rowSize = this.getRows();
        if (dynamic) {
            rowSize = this.getRowCount() + 1;
        }
        rowSize = Math.max(rowSize, 1);
        for (int i = 0; i < rowSize; ++i) {
            ListItem li = this.createListItem();
            li.setIndex(i);
            li.setRownum(i);
            li.loadItem(null);
            this.itemList.add(li);
        }
    }

    protected final void fillListItems(List list, int toprow) {
        this.buildListItems();
        int dataSize = list.size();
        int itemSize = this.itemList.size();
        for (int i = 0; i < itemSize; ++i) {
            ListItem li = this.itemList.get(i);
            li.setIndex(i);
            li.setRownum(toprow + i);
            if (i < dataSize) {
                Object item = list.get(i);
                li.loadItem(item);
                li.setState(1);
                continue;
            }
            li.loadItem(null);
            li.setState(0);
        }
    }

    public final void rebuildIndexes() {
        for (int i = 0; i < this.itemList.size(); ++i) {
            this.itemList.get(i).setIndex(i);
        }
    }

    public boolean isItemSelected(Object item) {
        ListSelectionSupport lss = this.getSelectionSupport();
        Object callback = this.getMultiSelectHandler();
        if (callback != null) {
            return lss.isItemCheckedFromHandler(callback, item);
        }
        SelectionEvent se = new SelectionEvent(item, -1);
        lss.resolveKey(se);
        int idx = lss.checkedItems.indexOf(se);
        se = idx < 0 ? null : (SelectionEvent)lss.checkedItems.get(idx);
        return se == null ? false : se.isSelected();
    }

    public void refreshSelectedItem() {
        this.fireFocusSelectedItem();
    }

    public void refreshItem(Object o) {
        this.refreshItem(o, -1);
    }

    public void refreshItem(Object o, int colIndex) {
        if (o == null) {
            return;
        }
        if (this.getDataListSize() == 0) {
            return;
        }
        if (o instanceof Number) {
            int idx = ((Number)o).intValue();
            Object data = this.getData(idx);
            if (data == null) {
                return;
            }
            this.propertySupport.firePropertyChange("refreshItem", new Integer[]{idx, colIndex});
        } else {
            int idx = this.getDataList().indexOf(o);
            if (idx < 0) {
                return;
            }
            this.propertySupport.firePropertyChange("refreshItem", new Integer[]{idx, colIndex});
        }
    }

    public final Object getSelectedValue() {
        if (this.isMultiSelect()) {
            return this.getSelectionSupport().getSelectedValues();
        }
        if (this.getSelectedItem() == null) {
            return null;
        }
        return this.getSelectedItem().getItem();
    }

    public void setUIProvider(UIProvider uiprovider) {
        this._uiprovider = uiprovider;
    }

    public final Object getBindingObject() {
        return this._uiprovider == null ? null : this._uiprovider.getBinding();
    }

    public final Column getSelectedColumnObject() {
        return this._uiprovider == null ? null : this._uiprovider.getSelectedColumn();
    }

    public final Map getSelectedColumnProperties() {
        Column.TypeHandler thandler;
        Column column = this.getSelectedColumnObject();
        if (column == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(column.getProperties());
        if (column.getName() != null) {
            map.put("name", column.getName());
        }
        if (column.getCaption() != null) {
            map.put("caption", column.getCaption());
        }
        if (column.getExpression() != null) {
            map.put("expression", column.getExpression());
        }
        if (column.getType() != null) {
            map.put("type", column.getType());
        }
        if (column.getEditableWhen() != null) {
            map.put("editableWhen", column.getEditableWhen());
        }
        if (column.getVisibleWhen() != null) {
            map.put("visibleWhen", column.getVisibleWhen());
        }
        if ((thandler = column.getTypeHandler()) instanceof LookupColumnHandler) {
            LookupColumnHandler hnd = (LookupColumnHandler)thandler;
            if (hnd.getExpression() != null) {
                map.put("expression", hnd.getExpression());
            }
            if (hnd.getHandler() != null) {
                map.put("handler", hnd.getHandler());
            }
        } else if (thandler instanceof OpenerColumnHandler) {
            OpenerColumnHandler hnd = (OpenerColumnHandler)thandler;
            if (hnd.getExpression() != null) {
                map.put("expression", hnd.getExpression());
            }
            if (hnd.getHandler() != null) {
                map.put("handler", hnd.getHandler());
            }
        } else if (thandler instanceof ComboBoxColumnHandler) {
            ComboBoxColumnHandler hnd = (ComboBoxColumnHandler)thandler;
            if (hnd.getExpression() != null) {
                map.put("expression", hnd.getExpression());
            }
            if (hnd.getItemKey() != null) {
                map.put("itemKey", hnd.getItemKey());
            }
            if (hnd.getItems() != null) {
                map.put("items", hnd.getItems());
            }
        }
        return map;
    }

    public static interface UIProvider {
        public Object getBinding();

        public Column getSelectedColumn();
    }

    public class ListSelectionSupport {
        AbstractListDataProvider root;
        private ArrayList<SelectionEvent> checkedItems;
        private CallbackHandlerProxy callbackProxy;

        public ListSelectionSupport() {
            this.root = AbstractListDataProvider.this;
            this.checkedItems = new ArrayList();
            this.callbackProxy = new CallbackHandlerProxy(null);
        }

        protected void finalize() throws Throwable {
            this.checkedItems.clear();
        }

        void resolveKey(SelectionEvent se) {
            if (se == null || se.key != null) {
                return;
            }
            if (se.getData() == null) {
                return;
            }
            se.key = this.root.buildSelectionKey(se.getData());
        }

        public boolean contains(Object data) {
            return this.contains(new SelectionEvent(data, -1));
        }

        public boolean contains(SelectionEvent se) {
            if (se == null || se.getData() == null) {
                return false;
            }
            this.resolveKey(se);
            return this.checkedItems.contains(se);
        }

        public boolean isItemChecked(Object data) {
            return this.isItemChecked(new SelectionEvent(data, -1));
        }

        public boolean isItemChecked(SelectionEvent se) {
            if (se == null || se.getData() == null) {
                return false;
            }
            this.resolveKey(se);
            boolean checked = false;
            try {
                checked = this.root.isItemSelected(se.getData());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.checkedItems.remove(se);
            if (checked) {
                this.checkedItems.add(se);
                se.selected = checked;
            }
            return checked;
        }

        public boolean isItemCheckedFromHandler(Object itemData) {
            Object callback = this.root.getMultiSelectHandler();
            return this.isItemCheckedFromHandler(callback, itemData);
        }

        public boolean isItemCheckedFromHandler(Object callback, Object itemData) {
            try {
                if (callback == null) {
                    return false;
                }
                Object res = this.callbackProxy.invoke(callback, itemData);
                if (res instanceof Boolean) {
                    return (Boolean)res;
                }
                return "true".equals(res + "");
            }
            catch (Throwable ex) {
                if (ClientContext.getCurrentContext().isDebugMode()) {
                    ex.printStackTrace();
                }
                return false;
            }
        }

        public synchronized void setItemChecked(Object data, boolean checked) {
            this.setItemChecked(data, checked, -1);
        }

        public synchronized void setItemChecked(Object data, boolean checked, int index) {
            this.setItemChecked(new SelectionEvent(data, index), checked);
        }

        public synchronized void setItemChecked(SelectionEvent se, boolean checked) {
            this.setItemChecked(se, checked, true);
        }

        public synchronized void setItemChecked(SelectionEvent se, boolean checked, boolean withEvents) {
            if (se == null || se.getData() == null) {
                return;
            }
            this.resolveKey(se);
            se.selected = checked;
            if (withEvents && se.getIndex() >= 0) {
                try {
                    AbstractListDataProvider.this.beforeSelectionChange(se);
                }
                catch (BreakException be) {
                    return;
                }
            }
            this.checkedItems.remove(se);
            if (checked) {
                this.checkedItems.add(se);
            }
            if (withEvents && se.getIndex() >= 0) {
                try {
                    AbstractListDataProvider.this.afterSelectionChange(se);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public List getSelectedValues() {
            ArrayList<Object> list = new ArrayList<Object>();
            SelectionEvent[] arr = this.checkedItems.toArray(new SelectionEvent[0]);
            for (int i = 0; i < arr.length; ++i) {
                SelectionEvent se = arr[i];
                if (!se.isSelected()) continue;
                list.add(se.getData());
            }
            return list;
        }

        public Object getSelectedValue() {
            List values = this.getSelectedValues();
            if (values == null || values.isEmpty()) {
                return null;
            }
            return values.get(0);
        }

        public boolean hasSelections() {
            return !this.checkedItems.isEmpty();
        }
    }

    public class SelectionEvent {
        private Object key;
        private Object data;
        private boolean selected;
        private int index;

        public SelectionEvent(Object data, int index) {
            this(data, index, false);
        }

        public SelectionEvent(Object data, int index, boolean selected) {
            this.data = data;
            this.index = index;
            this.selected = selected;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getData() {
            return this.data;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean equals(Object o) {
            if (super.equals(o)) {
                return true;
            }
            boolean matched = false;
            matched = o instanceof SelectionEvent ? this.isEquals(this.key, ((SelectionEvent)o).key) : this.isEquals(this.key, o);
            return matched;
        }

        private boolean isEquals(Object o1, Object o2) {
            if (o1 == null || o2 == null) {
                return true;
            }
            return o1 != null && o2 != null && o1.equals(o2);
        }
    }

    private class ListItemHandler
    implements ListItem.Handler {
        private ListItemHandler() {
        }

        @Override
        public void setSelected(ListItem li, boolean selected) {
        }

        @Override
        public void replaceSelectedItem(ListItem li, Object newData) {
        }

        @Override
        public void refreshItemUpdated(ListItem li) {
        }
    }

    public class MessageSupport {
        private Map<ListItem, String> errors = new HashMap<ListItem, String>();

        public boolean hasErrorMessages() {
            return !this.errors.isEmpty();
        }

        public void addErrorMessage(int index, String message) {
            ListItem li = AbstractListDataProvider.this.getListItem(index);
            if (li == null || li.getItem() == null) {
                return;
            }
            this.errors.put(li.clone(), message);
        }

        public String getErrorMessage(int index) {
            ListItem li = AbstractListDataProvider.this.getListItem(index);
            if (li == null || li.getItem() == null) {
                return null;
            }
            return this.errors.get(li);
        }

        public void removeErrorMessage(int index) {
            ListItem li = AbstractListDataProvider.this.getListItem(index);
            if (li == null || li.getItem() == null) {
                return;
            }
            this.errors.remove(li);
        }

        public String getErrorMessages() {
            if (this.errors.isEmpty()) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (Map.Entry<ListItem, String> me : this.errors.entrySet()) {
                if (!first) {
                    sb.append("\n");
                } else {
                    first = false;
                }
                sb.append("Row " + (me.getKey().getRownum() + 1) + ": " + me.getValue());
            }
            return sb.toString();
        }
    }
}

