/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.Node;
import com.rameses.rcp.common.NodeFilter;
import com.rameses.rcp.common.PopupMenuOpener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTreeNodeModel {
    private static final long serialVersionUID = 1L;
    private Provider provider;
    private Node selectedNode;

    public abstract Node[] fetchNodes(Node var1);

    public Object fetchNodeItem(Node node) {
        return null;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public String getIcon() {
        return null;
    }

    public boolean isRootVisible() {
        return true;
    }

    public boolean isAllowOpenOnSingleClick() {
        return true;
    }

    public boolean isAutoSelect() {
        return false;
    }

    public Node getRootNode() {
        return new Node("root", "All");
    }

    public Node getSelectedNode() {
        return this.provider == null ? null : this.provider.getSelectedNode();
    }

    public Object openLeaf(Node node) {
        return null;
    }

    public Object openFolder(Node node) {
        return null;
    }

    public Object openSelected() {
        if (this.selectedNode == null) {
            return null;
        }
        if (this.selectedNode.isLeaf()) {
            return this.openLeaf(this.selectedNode);
        }
        return this.openFolder(this.selectedNode);
    }

    public final Node findNode(NodeFilter filter) {
        return this.provider == null ? null : this.provider.findNode(filter);
    }

    public final List<Node> findNodes(NodeFilter filter) {
        return this.provider == null ? new ArrayList() : this.provider.findNodes(filter);
    }

    public final List<Node> children() {
        return this.provider == null ? new ArrayList() : this.provider.children();
    }

    public final Object getBinding() {
        return this.provider == null ? null : this.provider.getBinding();
    }

    public final void reloadTree() {
        if (this.provider != null) {
            this.provider.reloadTree();
        }
    }

    public final void reloadSelectedNode() {
        if (this.provider != null) {
            this.provider.reloadSelectedNode();
        }
    }

    public final void reloadParentNode() {
        if (this.provider != null) {
            this.provider.reloadParentNode();
        }
    }

    public final Node getRoot() {
        return this.provider == null ? null : this.provider.getRoot();
    }

    public PopupMenuOpener getContextMenu(Node node) {
        return null;
    }

    public void onUpdate(Node node) {
    }

    public final void update() {
        if (this.provider != null) {
            this.provider.update();
        }
    }

    public static interface Provider {
        public Object getBinding();

        public Node getSelectedNode();

        public Node getRoot();

        public Node findNode(NodeFilter var1);

        public List<Node> findNodes(NodeFilter var1);

        public List<Node> children();

        public void refresh();

        public void reloadTree();

        public void reloadSelectedNode();

        public void reloadParentNode();

        public void update();
    }
}

