/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.CallbackHandler;
import com.rameses.util.BreakException;
import com.rameses.util.ExceptionManager;
import com.rameses.util.IgnoreException;
import java.lang.reflect.Method;

public class CallbackHandlerProxy
implements CallbackHandler {
    private Object source;
    private boolean handleBreakException;

    public CallbackHandlerProxy(Object source) {
        this.source = source;
        this.handleBreakException = true;
    }

    public boolean isHandleBreakException() {
        return this.handleBreakException;
    }

    public void setHandleBreakException(boolean handleBreakException) {
        this.handleBreakException = handleBreakException;
    }

    @Override
    public Object call() {
        return this.invoke(this.source);
    }

    @Override
    public Object call(Object value) {
        return this.invoke(this.source, value);
    }

    @Override
    public Object call(Object[] values) {
        return this.invoke(this.source, values);
    }

    public Object invoke(Object source) {
        if (source instanceof CallbackHandler) {
            return ((CallbackHandler)source).call();
        }
        return this.invokeMethod(source, new Object[0]);
    }

    public Object invoke(Object source, Object value) {
        if (source instanceof CallbackHandler) {
            return ((CallbackHandler)source).call(value);
        }
        return this.invokeMethod(source, new Object[]{value});
    }

    public Object invoke(Object source, Object[] values) {
        if (source instanceof CallbackHandler) {
            return ((CallbackHandler)source).call(values);
        }
        return this.invokeMethod(source, new Object[]{values});
    }

    private Object invokeMethod(Object source, Object[] args) {
        try {
            if (source == null) {
                throw new NullPointerException("failed to invoke method call caused by source object null");
            }
            Object[] params = args == null ? new Object[]{} : args;
            Class[] classes = new Class[params.length];
            if (params.length > 0) {
                classes[0] = params[0] instanceof Object[] ? Object[].class : Object.class;
            }
            Class<?> sourceClass = source.getClass();
            Method m = sourceClass.getMethod("call", classes);
            return m.invoke(source, params);
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                Exception e = ExceptionManager.getOriginal((Exception)((Exception)t));
                if (e instanceof IgnoreException) {
                    if (this.isHandleBreakException()) {
                        return null;
                    }
                    throw (IgnoreException)e;
                }
                if (e instanceof BreakException) {
                    if (this.isHandleBreakException()) {
                        return null;
                    }
                    throw (BreakException)((Object)e);
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
            }
            throw new RuntimeException(t.getMessage(), t);
        }
    }
}

