/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.control.image.ImageCropPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ImageCropper {
    private int cropWidth = 200;
    private int cropHeight = 200;
    private int windowWidth = 640;
    private int windowHeight = 480;
    private String title = "Image Cropper";
    private Object image;
    private Object handler;

    public static void show(Map data) {
        new ImageCropper(data).show();
    }

    public ImageCropper() {
    }

    public ImageCropper(Map data) {
        if (data.containsKey("cropWidth")) {
            this.cropWidth = this.getNumber(data, "cropWidth").intValue();
        }
        if (data.containsKey("cropHeight")) {
            this.cropHeight = this.getNumber(data, "cropHeight").intValue();
        }
        if (data.containsKey("windowWidth")) {
            this.windowWidth = this.getNumber(data, "windowWidth").intValue();
        }
        if (data.containsKey("windowHeight")) {
            this.windowHeight = this.getNumber(data, "windowHeight").intValue();
        }
        if (data.containsKey("title")) {
            this.title = this.getString(data, "title");
        }
        this.image = data.get("image");
        this.handler = data.get("handler");
    }

    public void setWindowSize(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
    }

    public void setCropSize(int width, int height) {
        this.cropWidth = width;
        this.cropHeight = height;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setImage(Object image) {
        this.image = image;
    }

    public void setHandler(Object handler) {
        this.handler = handler;
    }

    public void show() {
        ImageCropPanel icp = new ImageCropPanel();
        icp.setCropSize(this.cropWidth, this.cropHeight);
        if (this.image instanceof File) {
            icp.loadImage((File)this.image);
        } else if (this.image instanceof byte[]) {
            icp.loadImage((byte[])this.image);
        } else if (this.image instanceof ImageIcon) {
            icp.loadImage((ImageIcon)this.image);
        } else {
            throw new RuntimeException("Invalid image data");
        }
        FooterPanel footer = new FooterPanel();
        JPanel body = new JPanel();
        body.setLayout(new BorderLayout());
        body.add((Component)icp, "Center");
        body.add((Component)footer, "South");
        JDialog d = null;
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        d = win instanceof Frame ? new JDialog((Frame)win) : (win instanceof Dialog ? new JDialog((Dialog)win) : new JDialog());
        d.setDefaultCloseOperation(2);
        d.setModal(true);
        d.setTitle(this.title);
        d.setContentPane(body);
        Dimension dim = new Dimension(this.windowWidth, this.windowHeight);
        Insets margin = Toolkit.getDefaultToolkit().getScreenInsets(d.getGraphicsConfiguration());
        Dimension scrdim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = Math.max(scrdim.width / 2 - dim.width / 2, margin.left);
        int y = Math.max(scrdim.height / 2 - dim.height / 2, margin.top);
        d.setLocation(x, y);
        d.setSize(dim.width, dim.height);
        footer.handler = new CropHandler(d, icp, this.handler);
        d.setVisible(true);
    }

    private Number getNumber(Map data, String name) {
        try {
            return (Number)data.get(name);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private String getString(Map data, String name) {
        Object value = data == null ? null : (Object)data.get(name);
        return value == null ? null : value.toString();
    }

    private class DefaultLayout
    implements LayoutManager,
    LayoutManager2 {
        private DefaultLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int width = 0;
                int height = 25;
                int count = 0;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    width = Math.max(dim.width, width);
                    ++count;
                }
                width *= count;
                if (count > 1) {
                    width += (count - 1) * 5;
                }
                Insets margin = parent.getInsets();
                return new Dimension(width += margin.left + margin.right, height += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim;
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                ArrayList<Component> items = new ArrayList<Component>();
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    items.add(c);
                }
                int cw = 0;
                int ch = 25;
                int mw = 0;
                int count = items.size();
                for (Component c : items) {
                    dim = c.getPreferredSize();
                    mw = Math.max(mw, dim.width);
                    cw += mw;
                }
                if (count > 1) {
                    cw += (count - 1) * 5;
                }
                x = Math.max(w / 2 - cw / 2, margin.left);
                for (Component c : items) {
                    dim = c.getPreferredSize();
                    c.setBounds(x, y, mw, ch);
                    x += mw + 5;
                }
            }
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container target) {
            this.layoutContainer(target);
        }
    }

    private class CropHandler {
        private JDialog dialog;
        private Object handler;
        private ImageCropPanel panel;

        CropHandler(JDialog dialog, ImageCropPanel panel, Object handler) {
            this.dialog = dialog;
            this.handler = handler;
            this.panel = panel;
        }

        void cancel() {
            this.dialog.dispose();
        }

        void crop() {
            try {
                BufferedImage bi = this.panel.getCropImage();
                if (bi == null) {
                    throw new Exception("No image to crop. Please check.");
                }
                if (this.handler != null) {
                    CallbackHandlerProxy proxy = new CallbackHandlerProxy(this.handler);
                    proxy.call((Object)this.panel.getBytes(bi));
                }
                this.dialog.dispose();
            }
            catch (Throwable t) {
                MsgBox.err(t);
            }
        }
    }

    private class FooterPanel
    extends JPanel {
        CropHandler handler;

        FooterPanel() {
            super.setLayout(new DefaultLayout());
            this.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            JButton btn = new JButton(" OK ");
            btn.setMnemonic('O');
            btn.setMargin(new Insets(2, 4, 2, 4));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FooterPanel.this.doOk();
                }
            });
            this.add(btn);
            btn = new JButton("Cancel");
            btn.setMnemonic('C');
            btn.setMargin(new Insets(2, 4, 2, 4));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FooterPanel.this.doCancel();
                }
            });
            this.add(btn);
        }

        @Override
        public void setLayout(LayoutManager layoutManager) {
        }

        private void doOk() {
            this.handler.crop();
        }

        private void doCancel() {
            this.handler.cancel();
        }
    }
}

