/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.AbstractListDataProvider;
import com.rameses.rcp.common.EditorListSupport;
import com.rameses.rcp.common.ListItem;
import com.rameses.rcp.common.ListItemStatus;
import com.rameses.rcp.common.ListPageModel;
import com.rameses.rcp.common.TableModelSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class PageListModel
extends AbstractListDataProvider
implements ListPageModel,
EditorListSupport.TableEditor {
    private static final int DEFAULT_ROW_LIMIT = 20;
    private int fetchedRows;
    private int preferredRows;
    private int totalMaxRows;
    private int totalRowCount;
    private int pageIndex = 1;
    private int pageCount = 1;
    private String searchtext;
    private Map query = new HashMap();
    private StringBuffer recordCountInfo;
    private StringBuffer pageCountInfo;
    private TableEditorHandlerImpl editorHandler;
    private EditorListSupport editorSupport;

    @Override
    public ListItemStatus createListItemStatus(ListItem oListItem) {
        ListItemStatus stat = super.createListItemStatus(oListItem);
        stat.setPageIndex(this.pageIndex);
        stat.setPageCount(this.pageCount);
        stat.setTotalRows(this.totalRowCount);
        stat.setIsLastPage(this.isLastPage());
        stat.setHasNextPage(this.fetchedRows > this.preferredRows);
        return stat;
    }

    @Override
    protected void beforeLoad() {
        this.fetchedRows = 0;
        this.preferredRows = 0;
        this.totalMaxRows = 0;
        this.totalRowCount = 0;
        this.pageIndex = 1;
        this.pageCount = 1;
    }

    public String getSearchtext() {
        return this.searchtext;
    }

    public void setSearchtext(String searchtext) {
        this.searchtext = searchtext;
        this.getQuery().put("searchtext", searchtext);
    }

    @Override
    public int getRows() {
        return 20;
    }

    @Override
    public int getRowCount() {
        return this.getRows();
    }

    @Override
    public int getMaxRows() {
        return this.getRows();
    }

    public Map getQuery() {
        return this.query;
    }

    @Override
    protected void onbeforeFetchList(Map params) {
        Map qry = this.getQuery();
        if (qry != null) {
            params.putAll(qry);
        }
    }

    @Override
    protected void fetch(boolean forceLoad) {
        boolean fetchNewRecords;
        this.preferredRows = this.getRows();
        ArrayList dataList = this.getDataList();
        boolean bl = fetchNewRecords = dataList == null || forceLoad;
        if (fetchNewRecords) {
            int _startRow = this.pageIndex * this.preferredRows - this.preferredRows;
            if (_startRow < 0) {
                _startRow = 0;
            }
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            this.onbeforeFetchList(params);
            params.put("_start", _startRow);
            params.put("_toprow", _startRow);
            params.put("_rowsize", this.preferredRows + 1);
            params.put("_limit", this.preferredRows + 1);
            dataList = this.fetchList(params);
            if (dataList == null) {
                dataList = new ArrayList();
            }
            this.onafterFetchList(dataList);
            this.fetchedRows = dataList.size();
            if (dataList.size() > this.preferredRows) {
                dataList.remove(dataList.size() - 1);
            }
            this.setDataList(dataList);
        }
        if (this.pageIndex >= this.pageCount) {
            int nrows = Math.max(this.pageCount - 1, 0) * this.preferredRows;
            this.totalRowCount = nrows + dataList.size();
        }
        this.totalMaxRows = Math.max(this.totalMaxRows, this.pageIndex * this.getRows() + Math.min(this.fetchedRows, this.preferredRows));
        this.fillListItems(dataList, 0);
        this.setSelectedItem(this.getSelectedItem() == null ? 0 : this.getSelectedItem().getIndex());
        if (fetchNewRecords && !dataList.isEmpty() && this.getSelectedItem() != null && this.getSelectedItem().getItem() == null) {
            this.setSelectedItem(0);
        }
    }

    @Override
    public void moveFirstPage() {
        if (this.getMessageSupport().hasErrorMessages()) {
            return;
        }
        this.pageIndex = 1;
        this.refresh(true);
        this.refreshSelectedItem();
    }

    @Override
    public void moveBackPage() {
        if (this.getMessageSupport().hasErrorMessages()) {
            return;
        }
        if (this.pageIndex - 1 > 0) {
            --this.pageIndex;
            this.refresh(true);
            this.refreshSelectedItem();
        }
    }

    @Override
    public void moveNextPage() {
        if (this.getMessageSupport().hasErrorMessages()) {
            return;
        }
        if (!this.isLastPage()) {
            ++this.pageIndex;
            this.pageCount = Math.max(this.pageIndex, this.pageCount);
            this.refresh(true);
            this.refreshSelectedItem();
        }
    }

    @Override
    public void moveLastPage() {
        if (this.getMessageSupport().hasErrorMessages()) {
            return;
        }
        if (!this.isLastPage()) {
            int lastPageIndex = this.getLastPageIndex();
            if (lastPageIndex <= 0) {
                return;
            }
            this.pageIndex = lastPageIndex;
            this.pageCount = Math.max(this.pageIndex, this.pageCount);
            this.refresh(true);
            this.refreshSelectedItem();
        }
    }

    public void moveToPage(int index) {
        if (this.getMessageSupport().hasErrorMessages()) {
            return;
        }
        this.pageIndex = Math.max(index, 1);
        this.pageCount = Math.max(this.pageIndex, this.pageCount);
        this.refresh(true);
        this.refreshSelectedItem();
    }

    public final void doSearch() {
        this.load();
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getLastPageIndex() {
        return -1;
    }

    public boolean isLastPage() {
        if (this.pageIndex < this.pageCount) {
            return false;
        }
        if (this.fetchedRows <= this.preferredRows) {
            return true;
        }
        return this.pageIndex > this.pageCount;
    }

    @Override
    protected void dataChanged(Object stat) {
        this.recordCountInfo = new StringBuffer();
        this.pageCountInfo = new StringBuffer();
        if (stat instanceof ListItemStatus) {
            ListItemStatus lis = (ListItemStatus)stat;
            this.recordCountInfo.append(lis.getTotalRows());
            this.recordCountInfo.append(" Record(s)    ");
            this.pageCountInfo.append("Page  " + lis.getPageIndex() + "  of  ");
            if (lis.isHasNextPage()) {
                if (lis.getPageIndex() < lis.getPageCount()) {
                    this.pageCountInfo.append(lis.getPageCount());
                } else {
                    this.pageCountInfo.append("?");
                }
            } else {
                this.pageCountInfo.append(lis.getPageCount());
            }
        }
    }

    public Object getRecordCountInfo() {
        return this.recordCountInfo;
    }

    public Object getPageCountInfo() {
        return this.pageCountInfo;
    }

    public boolean isAllowColumnEditing() {
        return false;
    }

    public boolean isAllowAdd() {
        return true;
    }

    public Object createItem() {
        return new HashMap();
    }

    public Object createItem(String columnName) {
        return this.createItem();
    }

    protected void validateItem(Object item) {
    }

    protected void validate(ListItem li) {
        if (li != null) {
            this.validateItem(li.getItem());
        }
    }

    protected void addItem(Object item) {
    }

    protected void onAddItem(Object item) {
        this.addItem(item);
    }

    protected void onUpdateItem(Object item) {
    }

    protected boolean onRemoveItem(Object item) {
        return false;
    }

    protected void commitItem(Object item) {
    }

    protected void onCommitItem(Object item) {
        this.commitItem(item);
    }

    @Override
    public boolean isColumnEditable(Object item, String columnName) {
        return true;
    }

    protected boolean beforeColumnUpdate(Object item, String columnName, Object newValue) {
        return true;
    }

    protected void afterColumnUpdate(Object item, String columnName) {
    }

    protected void onColumnUpdate(Object item, String columnName) {
        this.afterColumnUpdate(item, columnName);
    }

    public final void refreshEditedCell() {
        this.refreshCurrentEditor();
    }

    public final void refreshCurrentEditor() {
        if (this.editorSupport != null) {
            this.editorSupport.refreshCurrentEditor();
        }
    }

    public final boolean hasUncommittedData() {
        return this.editorSupport == null ? false : this.editorSupport.hasUncommittedData();
    }

    @Override
    public EditorListSupport.TableEditorHandler getTableEditorHandler() {
        if (!this.isAllowColumnEditing()) {
            return null;
        }
        if (this.editorHandler == null) {
            this.editorHandler = new TableEditorHandlerImpl();
        }
        return this.editorHandler;
    }

    @Override
    public TableModelSupport getTableModelSupport() {
        return this.tableModelSupport;
    }

    @Override
    public void setEditorListSupport(EditorListSupport editorSupport) {
        this.editorSupport = editorSupport;
    }

    private class TableEditorHandlerImpl
    implements EditorListSupport.TableEditorHandler {
        PageListModel root;

        private TableEditorHandlerImpl() {
            this.root = PageListModel.this;
        }

        @Override
        public boolean isAllowAdd() {
            return this.root.isAllowAdd();
        }

        @Override
        public Object createItem(String columnName) {
            return this.root.createItem(columnName);
        }

        @Override
        public void validate(ListItem li) {
            this.root.validate(li);
        }

        @Override
        public void onAddItem(Object item) {
            this.root.onAddItem(item);
        }

        @Override
        public void onUpdateItem(Object item) {
            this.root.onUpdateItem(item);
        }

        @Override
        public void onCommitItem(Object item) {
            this.root.onCommitItem(item);
        }

        @Override
        public boolean onRemoveItem(Object item) {
            return this.root.onRemoveItem(item);
        }

        @Override
        public boolean isColumnEditable(Object item, String columnName) {
            return this.root.isColumnEditable(item, columnName);
        }

        @Override
        public boolean beforeColumnUpdate(Object item, String columnName, Object newValue) {
            return this.root.beforeColumnUpdate(item, columnName, newValue);
        }

        @Override
        public void onColumnUpdate(Object item, String columnName) {
            this.root.onColumnUpdate(item, columnName);
        }
    }
}

