/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ProgressModel {
    private int minValue;
    private int maxValue;
    private int value;
    private LinkedBlockingQueue queue;
    private Provider provider;

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        this.refresh();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.refresh();
    }

    public void refresh() {
        if (this.provider != null) {
            this.provider.adjustValues(this.getMinValue(), this.getMaxValue(), this.getValue());
        }
    }

    public void setText(String text) {
        if (this.provider != null) {
            this.provider.adjustText(text);
        }
    }

    public void pause() {
        this.pause(250L);
    }

    public void pause(long millis) {
        if (this.queue == null) {
            this.queue = new LinkedBlockingQueue();
        }
        try {
            this.queue.poll(millis, TimeUnit.MILLISECONDS);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void setProvider(Provider provider) {
        this.provider = provider;
    }

    public Object getBinding() {
        return this.provider == null ? null : this.provider.getBinding();
    }

    public static interface Provider {
        public Object getBinding();

        public void adjustValues(int var1, int var2, int var3);

        public void adjustText(String var1);
    }
}

