/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.TaskListener;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.List;

public abstract class Task {
    private String id = "TASK-" + new UID();
    private boolean cancelled;
    private boolean ended = true;
    private List<TaskListener> listeners = new ArrayList<TaskListener>();
    protected boolean _started;

    public boolean equals(Object obj) {
        if (!(obj instanceof Task)) {
            return false;
        }
        String id1 = this.getId();
        String id2 = ((Task)obj).getId();
        return id1 != null && id2 != null && id1.equals(id2);
    }

    public int hashCode() {
        return Task.class.getName().hashCode() + this.id.hashCode();
    }

    public abstract boolean accept();

    public abstract void execute();

    public void start() {
        if (!this._started) {
            this._started = true;
        }
        for (TaskListener tl : this.listeners) {
            tl.onStart();
        }
    }

    public void end() {
        this._started = false;
        for (TaskListener tl : this.listeners) {
            tl.onStop();
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
        if (cancelled) {
            this._started = false;
            for (TaskListener tl : this.listeners) {
                tl.onCancel();
            }
        }
    }

    public boolean isEnded() {
        return this.ended;
    }

    public void setEnded(boolean ended) {
        this.ended = ended;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

