/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.control.FormItemProperty;
import com.rameses.rcp.control.XFormPanel;
import com.rameses.rcp.control.XLabel;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.ui.UISubControl;
import com.rameses.util.ValueUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ItemPanel
extends JPanel
implements FormItemProperty {
    private LabelImpl label;
    private XFormPanel formPanel;
    private ControlProperty property;
    private Component editorWrapper;
    private Component editor;
    private Insets padding;
    private UIModel uimodel;
    private String captionVAlignment = "TOP";
    private String captionHAlignment = "LEFT";

    public ItemPanel(XFormPanel parent, Component editor) {
        JScrollPane container = null;
        if (editor instanceof JTextArea || editor instanceof JEditorPane) {
            container = new JScrollPane();
            container.setViewportView(editor);
        }
        this.initComponents(parent, editor, container);
    }

    public ItemPanel(XFormPanel parent, Component editor, Component container) {
        this.initComponents(parent, editor, container);
    }

    private void initComponents(XFormPanel parent, Component editor, Component container) {
        this.formPanel = parent;
        this.editor = editor;
        this.editorWrapper = container;
        this.uimodel = new UIModel();
        if (container instanceof JScrollPane && !container.isPreferredSizeSet()) {
            JScrollPane jsp = (JScrollPane)container;
            JViewport view = jsp.getViewport();
            Dimension d = view.getViewSize();
            Insets i = view.getInsets();
            d.width += i.left + i.right;
            d.height += i.top + i.bottom;
            i = jsp.getInsets();
            d.width += i.left + i.right;
            d.height += i.top + i.bottom;
            container.setPreferredSize(d);
        }
        ActiveControl con = (ActiveControl)((Object)editor);
        this.property = con.getControlProperty();
        this.setOpaque(false);
        this.setLayout(new ItemPanelLayout(this.property));
        if (this.property.getCellPadding() != null) {
            this.padding = this.property.getCellPadding();
        }
        this.label = new LabelImpl();
        this.label.setLabelFor(editor);
        this.label.setAddCaptionColon(parent.isAddCaptionColon());
        if (this.property.getCaptionFont() != null) {
            this.label.setFont(this.property.getCaptionFont());
        } else {
            this.label.setFont(parent.getCaptionFont());
        }
        this.label.setForeground(parent.getCaptionForeground());
        if (!ValueUtil.isEmpty((Object)this.label.getText())) {
            this.label.setBorder(parent.getCaptionBorder());
        }
        new FontSupport().applyStyles((JComponent)this.label, this.property.getCaptionFontStyle());
        this.add((Component)this.label, "label");
        if (container != null) {
            this.add(container, "editor");
        } else {
            this.add(editor, "editor");
        }
        ControlPropetyListener pcl = new ControlPropetyListener(this.property);
        this.property.addPropertyChangeListener(pcl);
        editor.addComponentListener(new ComponentListener(){

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ItemPanel.this.setVisible(false);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                ItemPanel.this.setVisible(true);
            }
        });
    }

    public void updateLabelComponent() {
        if (this.label == null) {
            return;
        }
        this.label.setForeground(this.formPanel.getCaptionForeground());
        this.label.setPadding(this.formPanel.getCaptionPadding());
        this.label.setBorder(this.formPanel.getCaptionBorder());
        this.label.setAddCaptionColon(this.formPanel.isAddCaptionColon());
        this.label.setCaptionWidth(this.formPanel.getCaptionWidth());
    }

    public void updateLabelFont(Font font) {
        if (this.label == null || font == null) {
            return;
        }
        this.label.setFont(font);
    }

    public void updateLabelFont(FontSupport fs, String style) {
        if (this.label == null || fs == null || style == null) {
            return;
        }
        fs.applyStyles((JComponent)this.label, style);
    }

    public boolean match(Component editor) {
        if (editor == null) {
            return false;
        }
        return this.editor == editor;
    }

    public Component getEditorComponent() {
        return this.editor;
    }

    public Component getEditorWrapper() {
        return this.editorWrapper;
    }

    public LabelImpl getLabelComponent() {
        return this.label;
    }

    public ControlProperty getControlProperty() {
        return this.property;
    }

    @Override
    public Insets getInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        Insets i = super.getInsets();
        if (i != null) {
            insets.top += i.top;
            insets.left += i.left;
            insets.bottom += i.bottom;
            insets.right += i.right;
        }
        if (this.padding != null) {
            insets.top += this.padding.top;
            insets.left += this.padding.left;
            insets.bottom += this.padding.bottom;
            insets.right += this.padding.right;
        }
        return insets;
    }

    @Override
    public Insets getInsets(Insets insets) {
        Insets i = this.getInsets();
        if (insets == null) {
            return i;
        }
        insets.top = i.top;
        insets.left = i.left;
        insets.bottom = i.bottom;
        insets.right = i.right;
        return insets;
    }

    @Override
    public int getStretchWidth() {
        return this.uimodel.getStretchWidth();
    }

    @Override
    public int getStretchHeight() {
        return this.uimodel.getStretchHeight();
    }

    private class LabelImpl
    extends XLabel {
        Font preferredFont;

        public LabelImpl() {
            super(true);
        }

        @Override
        public Font getFont() {
            this.syncFont();
            return this.preferredFont;
        }

        void syncFont() {
            ItemPanel root = ItemPanel.this;
            Component c = root.getEditorComponent();
            if (c instanceof ActiveControl) {
                Font font;
                ActiveControl a = (ActiveControl)((Object)c);
                ControlProperty cp = a.getControlProperty();
                Font topFont = root.formPanel == null ? null : root.formPanel.getPreferredFont();
                Font font2 = font = cp == null ? null : cp.getCaptionFont();
                if (font == null) {
                    font = topFont;
                }
                if (font == null) {
                    font = root.getFont();
                }
                if (font != null) {
                    String fontStyle = cp == null ? null : cp.getCaptionFontStyle();
                    Map attrs = this.getFontSupport().createFontAttributes(fontStyle);
                    font = this.getFontSupport().applyStyles(font, attrs);
                }
                this.preferredFont = font;
            }
            if (this.preferredFont == null) {
                this.preferredFont = this.getPreferredFont();
            }
        }
    }

    private class ItemPanelLayout
    implements LayoutManager {
        Component label;
        Component editor;
        ControlProperty property;

        ItemPanelLayout(ControlProperty property) {
            this.property = property;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if ("label".equals(name)) {
                this.label = comp;
                ItemPanel.this.uimodel.setLabel(this.label);
            } else if ("editor".equals(name)) {
                this.editor = comp;
                ItemPanel.this.uimodel.setEditor(this.editor);
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp != null) {
                if (this.label == comp) {
                    this.label = null;
                    ItemPanel.this.uimodel.setLabel(null);
                } else if (this.editor == comp) {
                    this.editor = null;
                    ItemPanel.this.uimodel.setEditor(null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim = new Dimension(0, 0);
                String orient = ItemPanel.this.formPanel.getCaptionOrientation();
                dim = "LEFT".equals(orient) ? this.getLayoutSizeHorizontal(parent) : ("TOP".equals(orient) ? this.getLayoutSizeVertical(parent) : ("BOTTOM".equals(orient) ? this.getLayoutSizeVertical(parent) : this.getLayoutSizeHorizontal(parent)));
                Insets margin = parent.getInsets();
                int w = dim.width + margin.left + margin.right;
                int h = dim.height + margin.top + margin.bottom;
                return new Dimension(w, h);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = this.getLayoutSize(parent);
            return new Dimension(100, dim.height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                String orient = ItemPanel.this.formPanel.getCaptionOrientation();
                if ("LEFT".equals(orient)) {
                    this.layoutContainerHorizontal(parent);
                } else if ("TOP".equals(orient)) {
                    this.layoutContainerVertical(parent, false);
                } else if ("BOTTOM".equals(orient)) {
                    this.layoutContainerVertical(parent, true);
                } else {
                    this.layoutContainerHorizontal(parent);
                }
            }
        }

        private Dimension getLayoutSizeHorizontal(Container parent) {
            int w = 0;
            int h = 0;
            if (ItemPanel.this.uimodel.isEditorVisible()) {
                Dimension dim;
                if (ItemPanel.this.uimodel.isLabelVisible()) {
                    ItemPanel.this.uimodel.updateLabelStyles();
                    dim = this.label.getPreferredSize();
                    w = ItemPanel.this.uimodel.getPreferredCaptionWidth();
                    h = dim.height;
                }
                dim = this.editor.getPreferredSize();
                if (this.editor instanceof JPanel) {
                    JPanel panel = (JPanel)this.editor;
                    Dimension dimension = panel.getLayout().preferredLayoutSize(panel);
                }
                h = Math.max(h, dim.height);
                w += dim.width;
            }
            return new Dimension(w, h);
        }

        private Dimension getLayoutSizeVertical(Container parent) {
            int w = 0;
            int h = 0;
            if (ItemPanel.this.uimodel.isEditorVisible()) {
                Dimension dim;
                if (ItemPanel.this.uimodel.isLabelVisible()) {
                    ItemPanel.this.uimodel.updateLabelStyles();
                    dim = this.label.getPreferredSize();
                    w = Math.max(ItemPanel.this.uimodel.getPreferredCaptionWidth(), 0);
                    h = dim.height;
                }
                dim = this.editor.getPreferredSize();
                w = Math.max(w, dim.width);
                h += dim.height;
            }
            return new Dimension(w, h);
        }

        private void layoutContainerHorizontal(Container parent) {
            Insets margin = parent.getInsets();
            int x = margin.left;
            int y = margin.top;
            int h = parent.getHeight() - (margin.top + margin.bottom);
            if (ItemPanel.this.uimodel.isEditorVisible()) {
                int cw = ItemPanel.this.uimodel.getPreferredCaptionWidth();
                if (ItemPanel.this.uimodel.isLabelVisible()) {
                    if (cw <= 0) {
                        // empty if block
                    }
                    this.label.setBounds(x, y, cw, h);
                    x += cw;
                } else if (((ItemPanel)ItemPanel.this).uimodel.label != null) {
                    this.label.setBounds(-1, -1, 0, 0);
                }
                cw = Math.max(parent.getWidth() - x - margin.right, 0);
                Object userObject = null;
                if (this.editor instanceof JComponent) {
                    userObject = ((JComponent)this.editor).getClientProperty("UIControl.userObject");
                }
                Dimension dim = this.editor.getPreferredSize();
                int sw = ItemPanel.this.uimodel.getStretchWidth();
                int pw = dim.width;
                if (!(sw <= 0 && pw == 0 || sw > 0 && userObject == null)) {
                    if (sw > 0) {
                        double d1;
                        double d2;
                        int dw;
                        double d0 = cw;
                        if (pw == 0) {
                            pw = 1;
                        }
                        if (cw < pw) {
                            d0 = pw;
                        }
                        if ((dw = new BigDecimal(d2 = d0 * (d1 = (double)sw / 100.0)).setScale(0, RoundingMode.HALF_UP).intValue()) < pw) {
                            dw = pw;
                        }
                        cw = dw;
                    } else if (pw > 0) {
                        cw = pw;
                    }
                }
                this.editor.setBounds(x, y, cw, h);
            }
        }

        private void layoutContainerVertical(Container parent, boolean reverse) {
            Insets margin = parent.getInsets();
            int x = margin.left;
            int y = margin.top;
            int w = parent.getWidth() - (margin.left + margin.right);
            if (ItemPanel.this.uimodel.isEditorVisible()) {
                Dimension labeldim = new Dimension(0, 0);
                if (ItemPanel.this.uimodel.isLabelVisible()) {
                    int cw = ItemPanel.this.uimodel.getPreferredCaptionWidth();
                    if (cw <= 0) {
                        cw = w;
                    }
                    Dimension dim = this.label.getPreferredSize();
                    labeldim = new Dimension(cw, dim.height);
                }
                if (reverse) {
                    Dimension dim = this.editor.getPreferredSize();
                    int sw = ItemPanel.this.uimodel.getStretchWidth();
                    int dw = dim.width;
                    if (sw > 0) {
                        dw = w;
                    }
                    if (dw > 0 && dw < w) {
                        w = dw;
                    }
                    this.editor.setBounds(x, y, w, dim.height);
                    y += dim.height;
                    if (ItemPanel.this.uimodel.isLabelVisible()) {
                        this.label.setBounds(x, y, labeldim.width, labeldim.height);
                    }
                } else {
                    if (ItemPanel.this.uimodel.isLabelVisible()) {
                        this.label.setBounds(x, y, labeldim.width, labeldim.height);
                        y += labeldim.height;
                    }
                    Dimension dim = this.editor.getPreferredSize();
                    int sw = ItemPanel.this.uimodel.getStretchWidth();
                    int dw = dim.width;
                    if (sw > 0) {
                        dw = w;
                    }
                    if (dw > 0 && dw < w) {
                        w = dw;
                    }
                    int ch = Math.max(parent.getHeight() - y - margin.bottom, 0);
                    this.editor.setBounds(x, y, w, ch);
                }
            }
        }
    }

    private class UIModel {
        Component label;
        Component editor;
        UIControl uicontrol;
        ControlProperty property;

        private UIModel() {
        }

        void setEditor(Component editor) {
            this.editor = editor;
            this.uicontrol = null;
            this.property = null;
            Component comp = editor;
            if (editor instanceof JScrollPane) {
                JScrollPane jsp = (JScrollPane)editor;
                comp = jsp.getViewport().getView();
            }
            if (comp instanceof UIControl) {
                this.uicontrol = (UIControl)((Object)comp);
            }
            if (comp instanceof ActiveControl) {
                this.property = ((ActiveControl)((Object)comp)).getControlProperty();
            }
        }

        void setLabel(Component label) {
            this.label = label;
        }

        boolean isEditorVisible() {
            return this.editor != null && this.editor.isVisible();
        }

        Dimension getEditorPreferredSize() {
            return this.editor == null ? new Dimension(0, 0) : this.editor.getPreferredSize();
        }

        int getStretchWidth() {
            int sw = 0;
            if (this.editor != null) {
                int n = sw = this.uicontrol == null ? 0 : this.uicontrol.getStretchWidth();
                if (sw > 100) {
                    sw = 100;
                }
            }
            if (sw == 0) {
                if (this.editor instanceof UISubControl) {
                    sw = 100;
                } else if (this.editor != null && this.editor.getPreferredSize().width == 0) {
                    sw = 100;
                }
            }
            return sw;
        }

        int getStretchHeight() {
            return this.uicontrol == null ? 0 : this.uicontrol.getStretchHeight();
        }

        boolean isShowCaption() {
            return this.property == null ? false : this.property.isShowCaption();
        }

        boolean isLabelVisible() {
            return this.label != null && this.label.isVisible() && this.isShowCaption();
        }

        int getPreferredCaptionWidth() {
            int cw;
            int n = cw = this.property == null ? 0 : this.property.getCaptionWidth();
            if (cw == 0) {
                cw = ItemPanel.this.formPanel == null ? 0 : ItemPanel.this.formPanel.getCaptionWidth();
            }
            return cw > 0 ? cw : 0;
        }

        void hideLabel() {
            if (this.label != null) {
                this.label.setBounds(0, 0, 0, 0);
            }
        }

        void updateLabelStyles() {
            if (this.label == null || ItemPanel.this.formPanel == null) {
                return;
            }
            if (this.label instanceof JLabel) {
                JLabel jlabel = (JLabel)this.label;
                String valign = ItemPanel.this.formPanel.getCaptionVAlignment();
                if ("CENTER".equals(valign)) {
                    jlabel.setVerticalAlignment(0);
                } else if ("BOTTOM".equals(valign)) {
                    jlabel.setVerticalAlignment(3);
                } else {
                    jlabel.setVerticalAlignment(1);
                }
                String halign = ItemPanel.this.formPanel.getCaptionHAlignment();
                if ("CENTER".equals(halign)) {
                    jlabel.setHorizontalAlignment(0);
                } else if ("RIGHT".equals(halign)) {
                    jlabel.setHorizontalAlignment(4);
                } else {
                    jlabel.setHorizontalAlignment(2);
                }
            }
            if (this.label instanceof LabelImpl) {
                LabelImpl xlabel = (LabelImpl)this.label;
                Insets captionPadding = ItemPanel.this.formPanel.getCaptionPadding();
                if (captionPadding != null) {
                    xlabel.setPadding(captionPadding);
                }
                xlabel.syncFont();
            }
        }
    }

    private class ControlPropetyListener
    implements PropertyChangeListener {
        ItemPanel panel;
        private ControlProperty property;
        private Font sourceFont;

        ControlPropetyListener(ControlProperty property) {
            this.panel = ItemPanel.this;
            this.property = property;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            Object value = evt.getNewValue();
            if ("caption".equals(propName)) {
                Border b = this.panel.getLabelComponent().getBorder();
                if (ValueUtil.isEmpty((Object)value) && !(b instanceof EmptyBorder)) {
                    this.panel.getLabelComponent().setBorder(BorderFactory.createEmptyBorder());
                } else if (!ValueUtil.isEqual((Object)b, (Object)ItemPanel.this.formPanel.getCaptionBorder())) {
                    this.panel.getLabelComponent().setBorder(ItemPanel.this.formPanel.getCaptionBorder());
                }
            } else if ("captionFont".equals(propName)) {
                if (value instanceof Font) {
                    this.panel.getLabelComponent().setFont((Font)value);
                }
            } else if ("captionFontStyle".equals(propName)) {
                String fontStyle = value == null ? null : value.toString();
                this.panel.getLabelComponent().setFontStyle(fontStyle);
            } else if ("captionMnemonic".equals(propName)) {
                String sval;
                char ch = '\u0000';
                String string = sval = value == null ? null : value.toString();
                if (sval == null || sval.length() == 0) {
                    ch = sval.charAt(0);
                }
                this.panel.getLabelComponent().setDisplayedMnemonic(ch);
            } else if ("captionWidth".equals(propName)) {
                this.panel.revalidate();
            } else if ("showCaption".equals(propName)) {
                this.panel.revalidate();
            } else if ("cellPadding".equals(propName)) {
                Insets padding;
                Insets insets = padding = value instanceof Insets ? (Insets)value : null;
                if (padding == null) {
                    padding = new Insets(0, 0, 0, 0);
                }
                this.panel.padding = padding;
                this.panel.revalidate();
            }
        }
    }
}

