/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.common.ExpressionResolver;
import com.rameses.rcp.common.ActionFieldModel;
import com.rameses.rcp.common.CallbackHandler;
import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.control.text.DefaultTextField;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.ValidatorException;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.BreakException;
import com.rameses.util.ExceptionManager;
import com.rameses.util.IgnoreException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class XActionField
extends JPanel
implements MouseEventSupport.ComponentInfo,
UIControl,
ActiveControl {
    private MouseEventSupport mouseSupport;
    private DefaultTextField field;
    private JButton button;
    private int spacing;
    private String handler;
    private boolean readonly;
    private String expression;
    private Binding binding;
    private String[] depends;
    private int index;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private String disableWhen;
    private String varName;
    private String actionCommand;
    private Font fieldFont;
    private Font buttonFont;
    private InputVerifierImpl inputVerifierImpl;
    private FontSupport fontSupport;
    private Font preferredFont;
    private Font sourceFont;
    private String fontStyle;
    private Font preferredActionFont;
    private Font actionFont;
    private String actionFontStyle;
    private ControlProperty property;

    public XActionField() {
        this.initComponent();
    }

    private void initComponent() {
        super.setLayout(new DefaultLayout());
        this.setOpaque(false);
        this.setSpacing(2);
        this.setVarName("item");
        this.inputVerifierImpl = new InputVerifierImpl();
        this.mouseSupport = new MouseEventSupport(this);
        this.mouseSupport.install();
        this.add(this.getField());
        this.add(this.getButton());
    }

    private DefaultTextField getField() {
        if (this.field == null) {
            this.field = new DefaultTextField();
            this.field.putClientProperty("InputVerifierRouter", new InputVerifierImpl());
            this.field.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XActionField.this.actionPerformedImpl(e);
                }
            });
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XActionField.this.refreshComponent();
                }
            };
            this.field.addActionMapping("ACTION_MAPPING_KEY_ESCAPE", al);
            this.fieldFont = this.field.getFont();
        }
        return this.field;
    }

    private JButton getButton() {
        if (this.button == null) {
            this.button = new JButton("...");
            this.button.setMargin(new Insets(1, 4, 1, 4));
            this.button.setFocusable(false);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XActionField.this.actionPerformedImpl(e);
                }
            });
            this.buttonFont = this.button.getFont();
        }
        return this.button;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this.getField().setEditable(!readonly);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getActionText() {
        return this.getButton().getText();
    }

    public void setActionText(String text) {
        this.getButton().setText(text);
    }

    public Insets getActionTextMargin() {
        return this.getButton().getMargin();
    }

    public void setActionTextMargin(Insets margin) {
        this.getButton().setMargin(margin);
    }

    public Icon getActionIcon() {
        return this.getButton().getIcon();
    }

    public void setActionIcon(Icon icon) {
        this.getButton().setIcon(icon);
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public String getDisableWhen() {
        return this.disableWhen;
    }

    public void setDisableWhen(String disableWhen) {
        this.disableWhen = disableWhen;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    public Insets getMargin() {
        return this.getField().getMargin();
    }

    public void setMargin(Insets margin) {
        this.getField().setMargin(margin);
    }

    private FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    @Override
    public Font getFont() {
        return this.preferredFont;
    }

    @Override
    public void setFont(Font font) {
        this.sourceFont = font;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
        this.getField().setFont(this.preferredFont);
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
        this.getField().setFont(this.preferredFont);
    }

    private Font getPreferredFont() {
        Font baseFont;
        Font font = baseFont = this.sourceFont == null ? super.getFont() : this.sourceFont;
        if (baseFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
            baseFont = this.getFontSupport().applyStyles(baseFont, attrs);
        }
        return baseFont;
    }

    public Font getActionFont() {
        return this.preferredActionFont == null ? this.buttonFont : this.preferredActionFont;
    }

    public void setActionFont(Font font) {
        this.actionFont = font;
        this.preferredActionFont = this.getPreferredActionFont();
        this.getButton().setFont(this.preferredActionFont);
    }

    public String getActionFontStyle() {
        return this.actionFontStyle;
    }

    public void setActionFontStyle(String actionFontStyle) {
        this.actionFontStyle = actionFontStyle;
        this.preferredActionFont = this.getPreferredActionFont();
        this.getButton().setFont(this.preferredActionFont);
    }

    private Font getPreferredActionFont() {
        Font baseFont;
        Font font = baseFont = this.actionFont == null ? this.buttonFont : this.actionFont;
        if (baseFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getActionFontStyle());
            baseFont = this.getFontSupport().applyStyles(baseFont, attrs);
        }
        return baseFont;
    }

    @Override
    public Map getInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("expression", this.getExpression());
        map.put("handler", this.getHandler());
        return map;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void load() {
    }

    @Override
    public void refresh() {
        Binding binding = this.getBinding();
        Object bean = binding == null ? null : binding.getBean();
        Object item = null;
        try {
            item = UIControlUtil.getBeanValue(bean, this.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String expression = this.getExpression();
        if (expression != null && expression.trim().length() > 0) {
            ExpressionResolver er = ExpressionResolver.getInstance();
            Object exprBean = this.createExpressionBean(bean, item);
            item = UIControlUtil.evaluateExpr(exprBean, expression);
        }
        String text = item == null ? "" : item.toString();
        this.getField().setText(text);
        String whenExpr = this.getDisableWhen();
        if (whenExpr != null && whenExpr.length() > 0) {
            boolean disabled = false;
            try {
                disabled = UIControlUtil.evaluateExprBoolean(binding.getBean(), whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.getField().setEnabled(!disabled);
            this.getButton().setEnabled(!disabled);
        }
        if ((whenExpr = this.getVisibleWhen()) != null && whenExpr.length() > 0) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(binding.getBean(), whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char captionMnemonic) {
        this.getControlProperty().setCaptionMnemonic(captionMnemonic);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
        super.setFocusable(false);
        this.getField().setFocusable(focusable);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getField().setEnabled(enabled);
        this.getButton().setEnabled(enabled);
    }

    @Override
    public void requestFocus() {
        this.getField().requestFocus();
    }

    private void actionPerformedImpl(ActionEvent ae) {
        try {
            boolean shiftDown;
            boolean ctrlDown = (ae.getModifiers() & 2) == 2;
            boolean bl = shiftDown = (ae.getModifiers() & 1) == 1;
            if (ctrlDown && shiftDown) {
                this.mouseSupport.showComponentInfo();
                return;
            }
            this.invokeAction();
        }
        catch (Exception x) {
            Exception e = ExceptionManager.getOriginal((Exception)x);
            if (e instanceof IgnoreException || e instanceof BreakException) {
                return;
            }
            MsgBox.err(x);
        }
    }

    protected void invokeAction() {
        Binding binding;
        String cmd = this.getActionCommand();
        if (cmd == null || cmd.trim().length() == 0) {
            cmd = this.getHandler();
        }
        Object bean = (binding = this.getBinding()) == null ? null : binding.getBean();
        PropertyInfo info = new PropertyInfo();
        Object result = null;
        Method method = this.findGetterMethod(bean, cmd, null);
        if (method != null) {
            result = this.invokeMethod(method, bean, null);
        } else {
            method = this.findGetterMethod(bean, cmd, new Class[]{Object.class});
            if (method != null) {
                result = this.invokeMethod(method, bean, new Object[]{info});
            }
        }
        if (result != null) {
            System.out.println(result);
            System.out.println(result.getClass());
            System.out.println(result.getClass().getSuperclass());
        }
        if (result instanceof Opener) {
            this.showOutcome(result);
        } else {
            ActionFieldModel model = null;
            model = result instanceof ActionFieldModel ? (ActionFieldModel)result : new DefaultActionFieldModel(result);
            model.setProvider(new DefaultActionFieldModelProvider());
            Object outcome = model.invoke(info);
            this.showOutcome(outcome);
        }
    }

    private void showOutcome(Object outcome) {
        if (outcome instanceof Opener) {
            this.getBinding().fireNavigation(outcome);
        }
    }

    private Method findGetterMethod(Object bean, String methodName, Class[] paramTypes) {
        if (methodName == null || methodName.length() == 0) {
            return null;
        }
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        Class<?> beanClass = bean.getClass();
        try {
            return beanClass.getMethod(methodName, paramTypes);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private Object invokeMethod(Method method, Object bean, Object[] params) {
        if (method == null || bean == null) {
            return null;
        }
        if (params == null) {
            params = new Object[]{};
        }
        try {
            return method.invoke(bean, params);
        }
        catch (Throwable t) {
            if (ClientContext.getCurrentContext().isDebugMode()) {
                t.printStackTrace();
            }
            return null;
        }
    }

    private Object createExpressionBean(Object bean, Object item) {
        ExprBeanSupport beanSupport = new ExprBeanSupport(bean);
        beanSupport.setItem(this.getVarName(), item);
        return beanSupport.createProxy();
    }

    private boolean refreshComponent() {
        block4: {
            try {
                this.refresh();
            }
            catch (BreakException breakException) {
            }
            catch (Exception e) {
                Exception src = ExceptionManager.getOriginal((Exception)e);
                if (!ExceptionManager.getInstance().handleError(src)) {
                    ClientContext.getCurrentContext().getPlatform().showError(this, e);
                }
                if (!(e instanceof ValidatorException)) break block4;
                return false;
            }
        }
        return true;
    }

    private class InputVerifierImpl
    extends InputVerifier {
        XActionField root;

        private InputVerifierImpl() {
            this.root = XActionField.this;
        }

        @Override
        public boolean verify(JComponent input) {
            return this.root.refreshComponent();
        }
    }

    public class PropertyInfo {
        XActionField root;

        public PropertyInfo() {
            this.root = XActionField.this;
        }

        public Object getBinding() {
            return this.root.getBinding();
        }

        public String getName() {
            return this.root.getName();
        }

        public String getValue() {
            return this.root.getField().getText();
        }

        public void setValue(String value) {
            this.root.getField().setText(value == null ? "" : value);
            this.root.getField().repaint();
        }
    }

    private class DefaultActionFieldModelProvider
    implements ActionFieldModel.Provider {
        XActionField root;

        private DefaultActionFieldModelProvider() {
            this.root = XActionField.this;
        }

        @Override
        public Object getBinding() {
            return this.root.getBinding();
        }
    }

    private class DefaultActionFieldModel
    extends ActionFieldModel {
        private Object callback;
        private CallbackHandlerProxy proxy;

        DefaultActionFieldModel(Object callback) {
            boolean pass = false;
            if (callback != null) {
                Class<?> clazz = callback.getClass();
                if (callback instanceof Runnable) {
                    pass = true;
                } else if (callback instanceof Callable) {
                    pass = true;
                } else if (callback instanceof CallbackHandler) {
                    pass = true;
                } else if (clazz.getSuperclass() != null && clazz.getSuperclass().toString().endsWith(".Closure")) {
                    pass = true;
                }
            }
            if (pass) {
                this.proxy = new CallbackHandlerProxy(callback);
            }
        }

        @Override
        public Object invoke(Object info) {
            if (this.proxy == null) {
                return null;
            }
            return this.proxy.call(info);
        }
    }

    private class DefaultLayout
    implements LayoutManager {
        XActionField root;

        private DefaultLayout() {
            this.root = XActionField.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                int spacing = Math.max(this.root.getSpacing(), 0);
                if (this.root.field != null && this.root.field.getParent() != null) {
                    Dimension dim = this.root.field.getPreferredSize();
                    w = dim.width;
                    h = dim.height;
                    if (this.root.button != null && this.root.button.getParent() != null) {
                        dim = this.root.button.getPreferredSize();
                        w += spacing + dim.width;
                        h = Math.max(dim.height, h);
                    }
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                if (this.root.field != null && this.root.field.getParent() != null) {
                    int cw = w;
                    if (this.root.button != null && this.root.button.getParent() != null) {
                        Dimension dim = this.root.button.getPreferredSize();
                        cw = Math.max(w - dim.width, 0);
                        this.root.button.setBounds(x + cw, y, dim.width, h);
                        int spacing = Math.max(this.root.getSpacing(), 0);
                        cw = Math.max(cw - spacing, 0);
                    }
                    this.root.field.setBounds(x, y, cw, h);
                }
            }
        }
    }
}

