/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.common.ExpressionResolver;
import com.rameses.common.PropertyResolver;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.ComboBoxEditorSupport;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import com.rameses.util.ValueUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class XComboBox
extends JComboBox
implements UIInput,
Validatable,
ActiveControl,
MouseEventSupport.ComponentInfo {
    protected Binding binding;
    private int index;
    private String[] depends;
    private String fontStyle;
    private String caption;
    private String varName;
    private String items;
    private String itemKey;
    private String expression;
    private String disableWhen;
    private String visibleWhen;
    private String emptyText = "-";
    private Object itemsObject;
    private boolean immediate;
    private boolean dynamic;
    private boolean allowNull = true;
    private boolean readonly;
    private ControlProperty property = new ControlProperty();
    private ActionMessage actionMessage = new ActionMessage();
    private Font sourceFont;
    protected ComboBoxModelImpl model;
    private Class fieldType;
    private int stretchWidth;
    private int stretchHeight;
    private boolean autoDefaultValue = true;
    private Color focusBackgroundColor;
    private FontSupport fontSupport;
    private Font preferredFont;

    public XComboBox() {
        this.initComponents();
    }

    private void initComponents() {
        this.model = new ComboBoxModelImpl();
        if (Beans.isDesignTime()) {
            this.model.addItem("Item 1", "Item 1");
            this.model.addItem("Item 1", "Item 2");
            this.model.addItem("Item 1", "Item 3");
            super.setModel(this.model);
        }
        this.setVarName("item");
        this.setRenderer(new Renderer2());
        new MouseEventSupport(this).install();
        UIManager.put("ComboBox.disabledForeground", this.getForeground());
        ComboBoxEditorSupport.install(this);
    }

    public boolean isAutoDefaultValue() {
        return this.autoDefaultValue;
    }

    public void setAutoDefaultValue(boolean autoDefaultValue) {
        this.autoDefaultValue = autoDefaultValue;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (Beans.isDesignTime()) {
            this.model.removeAllElements();
            this.model.addElement(name);
        }
    }

    @Override
    public Object getValue() {
        if (Beans.isDesignTime()) {
            return null;
        }
        Object item = this.getSelectedItem();
        if (item == null) {
            return null;
        }
        Object value = ((ComboItem)item).getValue();
        if (value == null) {
            return null;
        }
        String fkey = this.getItemKey();
        if (!ValueUtil.isEmpty((Object)fkey)) {
            PropertyResolver res = PropertyResolver.getInstance();
            value = res.getProperty(value, fkey);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object value) {
        if (Beans.isDesignTime()) {
            return;
        }
        if (value instanceof KeyEvent) {
            this.processKeyEventValue((KeyEvent)value);
            return;
        }
        ComboItem selObj = (ComboItem)this.getSelectedItem();
        if (this.isSelected(selObj, value)) {
            return;
        }
        if (value == null && !this.isAllowNull()) {
            this.model.nopublish = true;
            try {
                this.setSelectedIndex(0);
            }
            catch (Throwable throwable) {
            }
            finally {
                this.model.nopublish = false;
            }
            this.updateBeanValue();
        } else {
            ComboItem selitem = null;
            for (int i = 0; i < this.getItemCount(); ++i) {
                ComboItem ci = (ComboItem)this.getItemAt(i);
                if (!this.isSelected(ci, value)) continue;
                selitem = ci;
                break;
            }
            this.model.nopublish = true;
            try {
                if (selitem != null) {
                    this.model.setSelectedItem(selitem);
                } else if (this.getItemCount() > 0) {
                    this.setSelectedIndex(0);
                } else {
                    this.setSelectedItem(null);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                this.model.nopublish = false;
            }
            this.updateBeanValue();
        }
    }

    private void processKeyEventValue(KeyEvent evt) {
        int idx;
        JComboBox.KeySelectionManager ksm = this.getKeySelectionManager();
        if (ksm != null && (idx = ksm.selectionForKey(evt.getKeyChar(), this.model)) >= 0) {
            this.model.setSelectedItem(this.model.getElementAt(idx));
        }
    }

    protected boolean isSelected(ComboItem ci, Object value) {
        if (value != null && !ValueUtil.isEmpty((Object)this.itemKey)) {
            if (ci.getValue() == null) {
                return false;
            }
            PropertyResolver res = PropertyResolver.getInstance();
            Object key = res.getProperty(ci.getValue(), this.itemKey);
            return key != null && value.equals(key);
        }
        ComboItem c = new ComboItem(value);
        return ci == null ? false : ci.equals(c);
    }

    @Override
    public boolean isNullWhenEmpty() {
        return true;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public String getItems() {
        return this.items;
    }

    public void setItems(String items) {
        this.items = items;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getDisableWhen() {
        return this.disableWhen;
    }

    public void setDisableWhen(String disableWhen) {
        this.disableWhen = disableWhen;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    @Override
    public String getCaption() {
        return this.property.getCaption();
    }

    @Override
    public void setCaption(String caption) {
        this.property.setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.property.getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.property.setCaptionMnemonic(c);
    }

    @Override
    public boolean isRequired() {
        return this.property.isRequired();
    }

    @Override
    public void setRequired(boolean required) {
        this.property.setRequired(required);
    }

    public int getCaptionWidth() {
        return this.property.getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.property.setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.property.isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.property.setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.property.getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.property.setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.property.getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.property.setCaptionFontStyle(captionFontStyle);
    }

    public FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    @Override
    public Font getFont() {
        return this.preferredFont;
    }

    @Override
    public void setFont(Font font) {
        this.sourceFont = font;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public Font getPreferredFont() {
        Font baseFont;
        Font font = baseFont = this.sourceFont == null ? super.getFont() : this.sourceFont;
        if (baseFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
            baseFont = this.getFontSupport().applyStyles(baseFont, attrs);
        }
        return baseFont;
    }

    public Insets getCellPadding() {
        return this.property.getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.property.setCellPadding(padding);
    }

    @Override
    public void validateInput() {
        this.validateInput(this.actionMessage);
    }

    public void validateInput(ActionMessage am) {
        am.clearMessages();
        this.property.setErrorMessage(null);
        if (this.isRequired() && ValueUtil.isEmpty((Object)this.getValue())) {
            am.clearMessages();
            am.addMessage("1001", "{0} is required.", new Object[]{this.getCaption()});
            this.property.setErrorMessage(am.toString());
        }
    }

    @Override
    public ActionMessage getActionMessage() {
        return this.actionMessage;
    }

    @Override
    public ControlProperty getControlProperty() {
        return this.property;
    }

    public Class getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(Class fieldType) {
        this.fieldType = fieldType;
    }

    @Override
    public void setRequestFocus(boolean focus) {
        if (focus) {
            this.requestFocus();
        }
    }

    @Override
    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public void setItemKey(String itemKey) {
        this.itemKey = itemKey;
    }

    public String getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(String emptyText) {
        this.emptyText = emptyText;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public Object getItemsObject() {
        return this.itemsObject;
    }

    public void setItemsObject(Object itemsObject) {
        this.itemsObject = itemsObject;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
        if (info == null) {
            return;
        }
        PropertyInfoWrapper pi = new PropertyInfoWrapper(info);
        this.setExpression(pi.getExpression());
        this.setItemKey(pi.getItemKey());
        Object items = pi.getItems();
        if (items instanceof String) {
            this.setItems(items.toString());
            this.setItemsObject(null);
        } else {
            this.setItems(null);
            this.setItemsObject(items);
        }
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        super.setEnabled(!readonly);
        super.firePropertyChange("enabled", readonly, !readonly);
        this.repaint();
    }

    private Binding getCurrentBinding() {
        if ("true".equals(this.getClientProperty(JTable.class) + "")) {
            Object o;
            if (this.getVarName() == null) {
                this.setVarName("item");
            }
            if ((o = this.getClientProperty(Binding.class)) instanceof Binding) {
                return (Binding)o;
            }
        }
        return this.getBinding();
    }

    private Collection fetchItems() {
        Collection<Object> list = null;
        try {
            Class<Object> type = null;
            Binding oBinding = this.getCurrentBinding();
            Object beanItems = UIControlUtil.getBeanValue(oBinding, this.getItems());
            if (beanItems != null) {
                type = beanItems.getClass();
                if (type.isArray()) {
                    list = Arrays.asList((Object[])beanItems);
                } else if (beanItems instanceof Collection) {
                    list = (Collection)beanItems;
                }
            } else {
                Object value;
                type = this.fieldType != null ? this.fieldType : UIControlUtil.getValueType(this, this.getName());
                if (type == null && (value = UIControlUtil.getBeanValue(this)) != null) {
                    type = value.getClass();
                }
                if (type != null && type.isEnum()) {
                    list = Arrays.asList(type.getEnumConstants());
                }
            }
        }
        catch (Throwable type) {
            // empty catch block
        }
        if (this.itemsObject != null) {
            List<Object> col = null;
            if (this.itemsObject instanceof Collection) {
                col = (List<Object>)this.itemsObject;
            } else if (this.itemsObject.getClass().isArray()) {
                col = Arrays.asList((Object[])this.itemsObject);
            }
            if (list == null) {
                list = col;
            } else {
                list.addAll(col);
            }
        }
        return list;
    }

    private void buildList(ComboBoxModelImpl model) {
        Collection list = this.fetchItems();
        if (list == null) {
            return;
        }
        ExpressionResolver er = ExpressionResolver.getInstance();
        for (Object o : list) {
            Object caption = null;
            if (!ValueUtil.isEmpty((Object)this.expression)) {
                Object exprBean = this.createExpressionBean(o);
                caption = UIControlUtil.evaluateExpr(exprBean, this.expression);
            }
            if (caption == null) {
                caption = o;
            }
            model.addItem(o, caption == null ? "" : caption.toString());
        }
    }

    private Object createExpressionBean(Object itemBean) {
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        ExprBeanSupport beanSupport = new ExprBeanSupport(bean);
        beanSupport.setItem(this.getVarName(), itemBean);
        beanSupport.setItem("MODEL", bean);
        return beanSupport.createProxy();
    }

    @Override
    public void load() {
        ComboBoxModelImpl newModel = this.createModelImpl();
        if (!this.isDynamic()) {
            this.buildList(newModel);
            newModel.setSelectedItem(null);
        }
        super.setModel(newModel);
        this.model = newModel;
        if (this.immediate) {
            super.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (XComboBox.this.isPopupVisible()) {
                        return true;
                    }
                    return UIInputUtil.VERIFIER.verify(input);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        block18: {
            try {
                String whenExpr;
                if (this.isDynamic()) {
                    ComboBoxModelImpl newModel = this.createModelImpl();
                    this.buildList(newModel);
                    this.loadBeanValue(newModel);
                    super.setModel(newModel);
                    this.model = newModel;
                    this.model.nopublish = true;
                } else {
                    this.model.nopublish = true;
                    this.loadBeanValue(this.model);
                }
                if (this.isAutoDefaultValue()) {
                    if (this.getSelectedIndex() < 0) {
                        try {
                            this.setSelectedIndex(0);
                        }
                        catch (Throwable newModel) {
                            // empty catch block
                        }
                    }
                    this.updateBeanValue();
                }
                if ((whenExpr = this.getVisibleWhen()) != null && whenExpr.length() > 0) {
                    boolean result = false;
                    try {
                        result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    this.setVisible(result);
                }
                if (this.isEnabled()) {
                    this.setReadonly(this.isReadonly());
                }
                if ((whenExpr = this.getDisableWhen()) == null || whenExpr.length() <= 0) break block18;
                boolean disabled = false;
                try {
                    disabled = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.setEnabled(!disabled);
            }
            catch (Exception e) {
                this.setEnabled(false);
                this.setFocusable(false);
                if (ClientContext.getCurrentContext().isDebugMode()) {
                    e.printStackTrace();
                }
            }
            finally {
                this.model.nopublish = false;
            }
        }
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("allowNull", this.isAllowNull());
        map.put("dynamic", this.isDynamic());
        map.put("emptyText", this.getEmptyText());
        map.put("expression", this.getExpression());
        map.put("fieldType", this.getFieldType());
        map.put("immediate", this.isImmediate());
        map.put("itemKey", this.getItemKey());
        map.put("items", this.getItems());
        map.put("itemsObject", this.getItemsObject());
        map.put("required", this.isRequired());
        map.put("varName", this.getVarName());
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    protected void onItemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.updateBeanValue();
        }
    }

    @Override
    protected final void fireItemStateChanged(ItemEvent e) {
        if (this.isReadonly()) {
            return;
        }
        if (this.model != null && this.model.nopublish) {
            return;
        }
        this.onItemStateChanged(e);
        super.fireItemStateChanged(e);
    }

    private ComboBoxModelImpl createModelImpl() {
        ComboBoxModelImpl model = new ComboBoxModelImpl();
        if (this.isAllowNull()) {
            model.addItem(null, this.getEmptyText());
        }
        return model;
    }

    private void loadBeanValue(ComboBoxModel model) {
        if (model == null) {
            return;
        }
        Object value = UIControlUtil.getBeanValue(this);
        model.setSelectedItem(this.findItem(model, value));
    }

    private void updateBeanValue() {
        Object newValue = this.getValue();
        Object oldValue = UIControlUtil.getBeanValue(this);
        boolean matched = false;
        if (oldValue == null && newValue == null) {
            matched = true;
        } else if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            matched = true;
        }
        if (!matched) {
            UIInputUtil.updateBeanValue(this);
        }
    }

    private Object findItem(ComboBoxModel model, Object value) {
        String itemkey = this.getItemKey();
        boolean hasItemKey = itemkey != null && itemkey.trim().length() > 0;
        for (int i = 0; i < model.getSize(); ++i) {
            ComboItem item = (ComboItem)model.getElementAt(i);
            Object itemval = item.value;
            if (hasItemKey) {
                itemval = PropertyResolver.getInstance().getProperty(itemval, itemkey);
            }
            if (!this.isEqual(value, itemval)) continue;
            return item;
        }
        return null;
    }

    private boolean isEqual(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        return o1 != null && o2 != null && o1.equals(o2);
    }

    private class DashedBorder
    extends LineBorder {
        public DashedBorder(Color color) {
            super(color);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.setColor(this.lineColor);
            for (int i = 0; i < this.thickness; ++i) {
                BasicGraphicsUtils.drawDashedRect(g, x + i, y + i, width - i - i, height - i - i);
            }
            g.setColor(oldColor);
        }
    }

    private class DottedBorder
    extends AbstractBorder {
        int thickness = 1;
        boolean rounded = true;
        Color lineColor = new Color(125, 125, 125);
        Insets margin = new Insets(1, 3, 1, 2);

        private DottedBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets ins = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(c, ins);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets ins) {
            if (ins == null) {
                ins = new Insets(0, 0, 0, 0);
            }
            ins.top = this.margin.top;
            ins.left = this.margin.left;
            ins.bottom = this.margin.bottom;
            ins.right = this.margin.right;
            return ins;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.thickness <= 0) {
                return;
            }
            Color color = this.lineColor;
            if (color == null) {
                return;
            }
            float length = 2.0f;
            float spacing = 2.0f;
            int cap = this.rounded ? 1 : 2;
            int join = this.rounded ? 1 : 0;
            float[] array = new float[]{(float)this.thickness * (length - 1.0f), (float)this.thickness * (spacing + 1.0f)};
            BasicStroke dashed = new BasicStroke(this.thickness, cap, join, (float)this.thickness * 2.0f, array, 0.0f);
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setStroke(dashed);
                g2.setColor(color);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.drawRect(0, 0, width - 1, height - 1);
            }
            finally {
                g2.dispose();
            }
        }
    }

    private class Renderer2
    extends BasicComboBoxRenderer {
        XComboBox root;
        Border cellBorder;
        Border mainBorder;

        Renderer2() {
            this.root = XComboBox.this;
            this.cellBorder = new EmptyBorder(1, 5, 1, 1);
            this.mainBorder = new EmptyBorder(1, 4, 1, 1);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setOpaque(true);
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (index < 0) {
                this.setBorder(this.mainBorder);
                this.setOpaque(isSelected);
            } else {
                this.setBorder(this.cellBorder);
            }
            return this;
        }
    }

    private class RendererImpl
    extends DefaultListCellRenderer {
        XComboBox root;
        Border cellBorder;
        Border focusBorder;

        RendererImpl() {
            this.root = XComboBox.this;
            this.initComponent();
        }

        void initComponent() {
            this.cellBorder = new EmptyBorder(1, 5, 1, 2);
            this.focusBorder = new DottedBorder();
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            System.out.println("enabled=" + this.root.isEnabled() + ", index=" + index + ", selected=" + isSelected + ", focus=" + hasFocus);
            System.out.println("   background=" + this.root.getBackground() + ", list-background=" + list.getBackground());
            this.setComponentOrientation(list.getComponentOrientation());
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(value == null ? "" : value.toString());
            this.setFont(list.getFont());
            Border border = this.cellBorder;
            if (index < 0 && this.root.hasFocus()) {
                border = this.focusBorder;
                this.setOpaque(false);
            }
            this.setBorder(border);
            return this;
        }
    }

    private class PropertyInfoWrapper {
        private PropertySupport.ComboBoxPropertyInfo property;
        private Map map = new HashMap();

        PropertyInfoWrapper(PropertySupport.PropertyInfo info) {
            if (info instanceof Map) {
                this.map = (Map)((Object)info);
            }
            if (info instanceof PropertySupport.ComboBoxPropertyInfo) {
                this.property = (PropertySupport.ComboBoxPropertyInfo)info;
            }
        }

        public String getExpression() {
            Object value = this.map.get("expression");
            if (value == null && this.property != null) {
                value = this.property.getExpression();
            }
            return value == null ? null : value.toString();
        }

        public String getItemKey() {
            Object value = this.map.get("itemKey");
            if (value == null && this.property != null) {
                value = this.property.getItemKey();
            }
            return value == null ? null : value.toString();
        }

        public Object getItems() {
            Object value = this.map.get("items");
            if (value == null && this.property != null) {
                value = this.property.getItems();
            }
            return value;
        }
    }

    public class ComboItem {
        XComboBox root;
        private String text;
        private Object value;

        public ComboItem(Object value) {
            this(value, value == null ? "" : value.toString());
        }

        public ComboItem(Object value, String text) {
            this.root = XComboBox.this;
            this.value = value;
            this.text = ValueUtil.isEmpty((Object)text) ? "" : text;
        }

        public String toString() {
            return this.text;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ComboItem)) {
                return false;
            }
            ComboItem ci = (ComboItem)o;
            return this.root.isEqual(this.value, ci.value);
        }
    }

    private class ComboBoxModelImpl
    extends DefaultComboBoxModel {
        XComboBox root;
        boolean nopublish;

        private ComboBoxModelImpl() {
            this.root = XComboBox.this;
        }

        void addItem(Object item) {
            this.addItem(item, item == null ? "" : item.toString());
        }

        void addItem(Object item, String caption) {
            this.addElement(new ComboItem(item, caption));
        }

        @Override
        public void setSelectedItem(Object item) {
            if (item == null) {
                super.setSelectedItem(null);
            } else if (item instanceof ComboItem) {
                super.setSelectedItem(item);
            } else {
                super.setSelectedItem(new ComboItem(item));
            }
        }
    }
}

