/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.control.IconButton;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;

public class XIconPanel
extends JPanel
implements UIControl {
    List list = new ArrayList();
    Map controller1 = new HashMap();
    Map controller2 = new HashMap();
    Map controller3 = new HashMap();
    Map controller4 = new HashMap();
    Map controller5 = new HashMap();
    List categories = new ArrayList();
    private Binding binding;
    private String[] depends;
    private int index;
    private boolean buttonBorderPainted;
    private boolean buttonContentFilled;
    private String captionOrientation = "BOTTOM";
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;

    public XIconPanel() {
        this.setLayout(new BorderLayout());
        this.buttonBorderPainted = true;
        this.buttonContentFilled = true;
        this.init();
    }

    @Override
    public void refresh() {
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void load() {
        ArrayList<Action> actions = new ArrayList<Action>();
        this.categories.clear();
        Object beanValue = UIControlUtil.getBeanValue(this);
        if (beanValue instanceof Collection) {
            for (Object o : (Collection)beanValue) {
                if (!(o instanceof Action)) continue;
                actions.add((Action)o);
            }
        }
        for (Action a : actions) {
            Map map = a.getProperties();
            if (this.categories.size() == 0) {
                this.categories.add(map.get("category"));
            }
            if (this.categories.contains(map.get("category"))) continue;
            this.categories.add(map.get("category"));
        }
        IconCanvas innerpanel = new IconCanvas();
        innerpanel.setOpaque(this.isOpaque());
        innerpanel.setLayout(new GridLayout(this.categories.size(), 1, 0, 5));
        this.add((Component)innerpanel, "North");
        for (Object category : this.categories) {
            CategoryPanel innerMostPanel = new CategoryPanel(category.toString());
            innerMostPanel.setOpaque(this.isOpaque());
            int height = 50;
            int width = 50;
            for (Action action : actions) {
                Map map = action.getProperties();
                if (!map.get("category").equals(category)) continue;
                IconButton ibtn = new IconButton();
                ibtn.setHorizontalTextPosition(11);
                ibtn.setVerticalAlignment(0);
                ImageIcon img = new ImageIcon(this.getClass().getResource("/com/rameses/rcp/icons/calendar.png"));
                if (this.getCaptionOrientation().equals("LEFT")) {
                    ibtn.setHorizontalTextPosition(2);
                    height = img.getIconHeight() + 25;
                    width = img.getIconWidth() + this.getFontMetrics(this.getFont()).stringWidth(action.getCaption()) + this.getFontMetrics(this.getFont()).stringWidth(action.getCaption()) / 2 + 5;
                }
                if (this.getCaptionOrientation().equals("RIGHT")) {
                    ibtn.setHorizontalTextPosition(4);
                    height = img.getIconHeight() + 25;
                    width = img.getIconWidth() + this.getFontMetrics(this.getFont()).stringWidth(action.getCaption()) + this.getFontMetrics(this.getFont()).stringWidth(action.getCaption()) / 2 + 5;
                }
                if (this.getCaptionOrientation().equals("BOTTOM")) {
                    ibtn.setHorizontalTextPosition(0);
                    ibtn.setVerticalTextPosition(3);
                    height = img.getIconHeight() + this.getFontMetrics(this.getFont()).getHeight() + 25;
                    width = this.getFontMetrics(this.getFont()).stringWidth(action.getCaption()) + this.getFontMetrics(this.getFont()).stringWidth(action.getCaption()) / 2 + 5;
                }
                if (this.getCaptionOrientation().equals("TOP")) {
                    ibtn.setHorizontalTextPosition(0);
                    ibtn.setVerticalTextPosition(1);
                    height = img.getIconHeight() + this.getFontMetrics(this.getFont()).getHeight() + 25;
                    width = this.getFontMetrics(this.getFont()).stringWidth(action.getCaption()) + this.getFontMetrics(this.getFont()).stringWidth(action.getCaption()) / 2 + 5;
                }
                ibtn.setPreferredSize(new Dimension(width, height));
                ibtn.setContentAreaFilled(false);
                ibtn.setBorderPainted(this.isButtonBorderPainted());
                ibtn.setText(action.getCaption());
                ibtn.setCaption(action.getCaption());
                ibtn.setIcon(img);
                ibtn.setBinding(this.binding);
                ibtn.setName(action.getName());
                ibtn.setPermission(action.getPermission());
                ibtn.setParams(action.getParameters());
                ibtn.setFocusPainted(false);
                if (!action.getClass().getName().equals(Action.class.getName())) {
                    ibtn.putClientProperty(Action.class.getName(), action);
                }
                innerMostPanel.add(ibtn);
                ibtn.load();
            }
            innerpanel.add(innerMostPanel);
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void init() {
        this.controller1.put("category", "group 1");
        this.controller1.put("invokerType", "home_menu");
        this.controller1.put("caption", "group 1 item 1");
        this.controller5.put("category", "group 1");
        this.controller5.put("invokerType", "home_menu");
        this.controller5.put("caption", "group 1 item 2");
        this.controller2.put("category", "group 2");
        this.controller2.put("invokerType", "home_menu");
        this.controller2.put("caption", "group 2 item 1");
        this.controller3.put("category", "group 3");
        this.controller3.put("invokerType", "home_menu");
        this.controller3.put("caption", "group 3 item 1");
        this.controller4.put("category", "group 3");
        this.controller4.put("invokerType", "home_menu");
        this.controller4.put("caption", "group 3 item 2");
        this.list.add(this.controller1);
        this.list.add(this.controller2);
        this.list.add(this.controller3);
        this.list.add(this.controller4);
        this.list.add(this.controller5);
        for (Object item : this.list) {
            HashMap map = (HashMap)item;
            if (this.categories.size() == 0) {
                this.categories.add(map.get("category"));
            }
            if (this.categories.contains(map.get("category"))) continue;
            this.categories.add(map.get("category"));
        }
        IconCanvas innerpanel = new IconCanvas();
        innerpanel.setLayout(new GridLayout(this.categories.size(), 1));
        this.add((Component)innerpanel, "North");
        for (Object category : this.categories) {
            CategoryPanel innerMostPanel = new CategoryPanel(category.toString());
            for (Object item : this.list) {
                HashMap map = (HashMap)item;
                if (!map.get("category").equals(category)) continue;
                innerMostPanel.add(new Item(map.get("caption").toString()));
            }
            innerpanel.add(innerMostPanel);
        }
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    public boolean isButtonBorderPainted() {
        return this.buttonBorderPainted;
    }

    public void setButtonBorderPainted(boolean buttonBorderPainted) {
        this.buttonBorderPainted = buttonBorderPainted;
    }

    public boolean isButtonContentFilled() {
        return this.buttonContentFilled;
    }

    public void setButtonContentFilled(boolean buttonContentFilled) {
        this.buttonContentFilled = buttonContentFilled;
    }

    public String getCaptionOrientation() {
        return this.captionOrientation;
    }

    public void setCaptionOrientation(String captionOrientation) {
        this.captionOrientation = captionOrientation;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    private class CategoryBorder
    extends AbstractBorder {
        private String caption;

        public CategoryBorder(String caption) {
            this.caption = caption;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.decode("#657383"));
            FontMetrics fm = c.getFontMetrics(c.getFont());
            int fontheight = fm.getHeight();
            int fontwidth = fm.stringWidth(this.caption) + 10;
            int half = fontheight / 2 + y + 4;
            g.drawLine(x, half, x + 4, half);
            g.drawLine(fontwidth, half, width - 1, half);
            g.setFont(c.getFont());
            g.setColor(Color.BLACK);
            g.drawString(this.caption, x + 8, fontheight + y + 2);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(c.getFontMetrics(c.getFont()).getHeight() + 4, 1, 1, 1);
        }
    }

    private class Item
    extends JButton {
        public Item(String caption) {
            this.setText(caption);
        }
    }

    private class CategoryPanel
    extends JPanel {
        private String caption;

        public CategoryPanel(String caption) {
            this.setBorder(new CategoryBorder(caption));
            this.setLayout(new FlowLayout(0));
        }
    }

    private class IconCanvas
    extends JPanel {
    }
}

