/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.ValueUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.beans.Beans;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class XImagePanel
extends JPanel
implements UIControl,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private static String DISPLAY_NORMAL = "NORMAL";
    private static String DISPLAY_TILE = "TILE";
    private static String DISPLAY_STRETCH = "STRETCH";
    private static String DISPLAY_AUTO_RESIZE = "AUTO";
    private String displayMode = DISPLAY_NORMAL;
    private ImageIcon imageIcon;
    private Border innerBorder;
    private Border outerBorder;
    private Binding binding;
    private String[] depends;
    private boolean dynamic = true;
    private int index;
    private String iconResource;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private ControlProperty property;

    public XImagePanel() {
        new MouseEventSupport(this).install();
    }

    @Override
    public Border getBorder() {
        return this.innerBorder;
    }

    @Override
    public void setBorder(Border border) {
        this.innerBorder = border;
        if (this.innerBorder == null) {
            super.setBorder(this.outerBorder);
        } else {
            super.setBorder(BorderFactory.createCompoundBorder(this.outerBorder, this.innerBorder));
        }
    }

    public String getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(String displayMode) {
        this.displayMode = displayMode != null ? displayMode.toUpperCase() : DISPLAY_NORMAL;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public Icon getIcon() {
        return this.imageIcon;
    }

    public String getIconResource() {
        return this.iconResource;
    }

    public void setIconResource(String iconResource) {
        this.iconResource = iconResource;
        URL url = null;
        try {
            url = this.getClass().getResource(iconResource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (url == null) {
                url = ClientContext.getCurrentContext().getClassLoader().getResource(iconResource);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (url == null) {
                url = ClientContext.getCurrentContext().getClassLoader().getResource(iconResource);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.imageIcon = new ImageIcon(url);
            int iw = this.imageIcon.getIconWidth();
            int ih = this.imageIcon.getIconHeight();
            this.setPreferredSize(new Dimension(iw, ih));
            this.setMinimumSize(new Dimension(iw, ih));
            this.setDynamic(true);
        }
        catch (Exception ign) {
            this.imageIcon = null;
        }
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    private URL getImageResource(String path) {
        if (ValueUtil.isEmpty((Object)path)) {
            return null;
        }
        ClassLoader cl = ClientContext.getCurrentContext().getClassLoader();
        return cl.getResource(path);
    }

    @Override
    public void refresh() {
        String whenExpr;
        if (this.isDynamic()) {
            Object value = UIControlUtil.getBeanValue(this);
            try {
                this.imageIcon = null;
                if (value instanceof URL) {
                    this.imageIcon = new ImageIcon((URL)value);
                } else if (value instanceof String) {
                    URL url = this.getImageResource(value.toString());
                    if (url != null) {
                        this.imageIcon = new ImageIcon(url);
                    }
                    if (ValueUtil.isEmpty((Object)this.imageIcon)) {
                        this.imageIcon = new ImageIcon(new URL(value.toString()));
                    }
                } else if (value instanceof byte[]) {
                    this.imageIcon = new ImageIcon((byte[])value);
                } else if (value instanceof ImageIcon) {
                    this.imageIcon = (ImageIcon)value;
                } else if (value instanceof File) {
                    File file = (File)value;
                    this.imageIcon = new ImageIcon(file.toURL());
                } else if (value instanceof Image) {
                    this.imageIcon = new ImageIcon((Image)value);
                }
                int iw = this.imageIcon.getIconWidth();
                int ih = this.imageIcon.getIconHeight();
                this.setPreferredSize(new Dimension(iw, ih));
                this.setMinimumSize(new Dimension(iw, ih));
            }
            catch (Throwable iw) {
                // empty catch block
            }
        }
        if ((whenExpr = this.getVisibleWhen()) != null && whenExpr.length() > 0) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void load() {
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dynamic", this.isDynamic());
        map.put("iconResource", this.getIconResource());
        return map;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponents(g);
        if (Beans.isDesignTime()) {
            return;
        }
        if (this.imageIcon == null) {
            return;
        }
        int imgWidth = this.imageIcon.getIconWidth();
        int imgHeight = this.imageIcon.getIconHeight();
        int cw = this.getWidth();
        int ch = this.getHeight();
        if (DISPLAY_TILE.equals(this.displayMode)) {
            Color oldColor = g.getColor();
            int cols = cw / imgWidth;
            int rows = ch / imgHeight;
            if (cw % imgWidth > 0) {
                ++cols;
            }
            if (ch % imgHeight > 0) {
                ++rows;
            }
            for (int i = 0; i < rows; ++i) {
                for (int ii = 0; ii < cols; ++ii) {
                    g.drawImage(this.imageIcon.getImage(), ii * imgWidth, i * imgHeight, imgWidth, imgHeight, null);
                }
            }
        } else if (DISPLAY_STRETCH.equals(this.displayMode)) {
            cw = Math.max(cw, imgWidth);
            ch = Math.max(ch, imgHeight);
            g.drawImage(this.imageIcon.getImage(), 0, 0, cw, ch, null);
        } else {
            g.drawImage(this.imageIcon.getImage(), 0, 0, imgWidth, imgHeight, null);
        }
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }
}

