/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.Base64Cipher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.beans.Beans;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XImageViewer
extends JPanel
implements UIControl,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private Binding binding;
    private int index;
    private boolean advanced;
    private boolean fitImage;
    private String[] depends;
    private boolean dynamic;
    private int width = -1;
    private int height = -1;
    private String emptyImage;
    private Icon emptyImageIcon;
    private JSlider zoomSlider;
    private JCheckBox fitImgCheckBox = new JCheckBox("Fit:");
    private TitledBorder sliderBorder;
    private JScrollPane scrollPane = new JScrollPane();
    private ImageCanvas canvas = new ImageCanvas();
    private JPanel columnHeader = new JPanel();
    private JLabel lblZoom = new JLabel("Zoom: 100%");
    private double zoomLevel = 1.0;
    private double fitPercentageWidth = 1.0;
    private double fitPercentageHeight = 1.0;
    private double scaleWidth = 1.0;
    private double scaleHeight = 1.0;
    private double scale = 1.0;
    private AffineTransform at;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private Base64Cipher base64;
    private ControlProperty property;

    public XImageViewer() {
        if (!Beans.isDesignTime()) {
            this.init();
        }
        if (Beans.isDesignTime()) {
            this.setPreferredSize(new Dimension(40, 40));
        }
        new MouseEventSupport(this).install();
    }

    private void init() {
        super.setLayout(new BorderLayout());
        super.setBorder(BorderFactory.createEtchedBorder());
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setViewportView(this.canvas);
        super.add((Component)this.scrollPane, "Center");
        this.fitImgCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XImageViewer.this.fitImage) {
                    XImageViewer.this.fitImage = false;
                } else {
                    XImageViewer.this.fitImage = true;
                }
                if (XImageViewer.this.fitImage) {
                    XImageViewer.this.zoomSlider.setValue(100);
                    XImageViewer.this.zoomSlider.setEnabled(false);
                } else {
                    XImageViewer.this.zoomSlider.setEnabled(true);
                }
                XImageViewer.this.repaint();
            }
        });
        this.setFitImage(true);
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    @Override
    public void refresh() {
        String whenExpr;
        if (this.dynamic) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XImageViewer.this.render();
                }
            });
        }
        if ((whenExpr = this.getVisibleWhen()) != null && whenExpr.length() > 0) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void load() {
        if (!this.dynamic) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XImageViewer.this.render();
                }
            });
        }
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Map getInfo() {
        return null;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    private Image getImage() {
        Image image = null;
        try {
            Object value = null;
            try {
                value = UIControlUtil.getBeanValue(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (value != null) {
                ImageIcon ii;
                image = value instanceof InputStream ? ImageIO.read((InputStream)value) : ((ii = this.resolveImage(value)) == null ? null : ii.getImage());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return image;
    }

    private void attachAdvancedOptions() {
        if (this.advanced) {
            this.columnHeader.setBorder(BorderFactory.createEtchedBorder());
            this.columnHeader.setLayout(new FlowLayout(0, 1, 1));
            this.zoomSlider = new JSlider(10, 200, 100);
            this.zoomSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    XImageViewer.this.zoomLevel = (double)XImageViewer.this.zoomSlider.getValue() / 100.0;
                    XImageViewer.this.lblZoom.setText("Zoom: " + (int)(XImageViewer.this.zoomLevel * 100.0) + "%");
                    XImageViewer.this.canvas.repaint();
                    XImageViewer.this.canvas.revalidate();
                }
            });
            if (this.fitImage) {
                this.zoomSlider.setEnabled(false);
            }
            this.columnHeader.add(this.lblZoom);
            this.columnHeader.add(this.zoomSlider);
            this.columnHeader.add(this.fitImgCheckBox);
            this.add((Component)this.columnHeader, "North");
        } else {
            this.remove(this.columnHeader);
        }
    }

    private void render() {
        if (this.advanced) {
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.scrollPane.setVerticalScrollBarPolicy(20);
        } else if (this.fitImage) {
            this.advanced = false;
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.scrollPane.setVerticalScrollBarPolicy(21);
        }
    }

    private Base64Cipher getBase64Cipher() {
        if (this.base64 == null) {
            this.base64 = new Base64Cipher();
        }
        return this.base64;
    }

    private ImageIcon resolveImage(Object value) throws Exception {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return new ImageIcon((byte[])value);
        }
        if (value instanceof URL) {
            return new ImageIcon((URL)value);
        }
        if (value instanceof File) {
            return new ImageIcon(((File)value).toURI().toURL());
        }
        if (value instanceof ImageIcon) {
            return (ImageIcon)value;
        }
        if (value instanceof Image) {
            return new ImageIcon((Image)value);
        }
        if (value instanceof String) {
            String str = value.toString().toLowerCase();
            if (str.matches("[a-zA-Z]{1,}://.*")) {
                return new ImageIcon(new URL(value.toString()));
            }
            if (this.getBase64Cipher().isEncoded(value.toString())) {
                Object o = this.getBase64Cipher().decode(value.toString(), false);
                return this.resolveImage(o);
            }
            URL url = this.getClass().getClassLoader().getResource((String)value);
            if (url != null) {
                return new ImageIcon(url);
            }
        }
        return null;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
        this.attachAdvancedOptions();
    }

    public boolean isFitImage() {
        return this.fitImage;
    }

    public void setFitImage(boolean fitImage) {
        this.fitImage = fitImage;
        if (this.fitImgCheckBox != null) {
            this.fitImgCheckBox.setSelected(fitImage);
        }
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getEmptyImage() {
        return this.emptyImage;
    }

    public void setEmptyImage(String emptyImageName) {
        this.emptyImage = emptyImageName;
    }

    public Icon getEmptyImageIcon() {
        return this.emptyImageIcon;
    }

    public void setEmptyImageIcon(Icon emptyImageIcon) {
        this.emptyImageIcon = emptyImageIcon;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.canvas != null) {
            this.canvas.setBackground(bg);
        }
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    private class ImageCanvas
    extends JPanel {
        private ImageCanvas() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Image image = XImageViewer.this.getImage();
            boolean usingEmptyIcon = false;
            if (image == null && XImageViewer.this.emptyImageIcon instanceof ImageIcon) {
                usingEmptyIcon = true;
                image = ((ImageIcon)XImageViewer.this.emptyImageIcon).getImage();
            }
            if (image == null) {
                return;
            }
            XImageViewer.this.width = (int)((double)image.getWidth(this) * XImageViewer.this.zoomLevel);
            XImageViewer.this.height = (int)((double)image.getHeight(this) * XImageViewer.this.zoomLevel);
            if (XImageViewer.this.isFitImage() && !Beans.isDesignTime()) {
                this.calculateFit(image);
                Graphics2D g2 = (Graphics2D)g.create();
                XImageViewer.this.at = AffineTransform.getTranslateInstance(XImageViewer.this.fitPercentageWidth, XImageViewer.this.fitPercentageHeight);
                XImageViewer.this.at.scale(XImageViewer.this.scale, XImageViewer.this.scale);
                g2.drawImage(image, XImageViewer.this.at, this);
                this.updateSize(image.getWidth(this), image.getHeight(this));
                g2.dispose();
            } else {
                g.drawImage(image, 0, 0, XImageViewer.this.width, XImageViewer.this.height, null);
                this.updateSize(XImageViewer.this.width, XImageViewer.this.height);
                g.dispose();
            }
            if (!usingEmptyIcon) {
                image.flush();
            }
        }

        private void updateSize(final int width, final int height) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageCanvas.this.setPreferredSize(new Dimension(width, height));
                }
            });
        }

        private void calculateFit(Image image) {
            XImageViewer.this.scaleWidth = XImageViewer.this.scrollPane.getViewport().getExtentSize().getWidth() / (double)XImageViewer.this.width;
            XImageViewer.this.scaleHeight = XImageViewer.this.scrollPane.getViewport().getExtentSize().getHeight() / (double)XImageViewer.this.height;
            XImageViewer.this.scale = Math.min(XImageViewer.this.scaleWidth, XImageViewer.this.scaleHeight);
            XImageViewer.this.fitPercentageWidth = (XImageViewer.this.scrollPane.getViewport().getExtentSize().getWidth() - XImageViewer.this.scale * (double)image.getWidth(this)) / 2.0;
            XImageViewer.this.fitPercentageHeight = (XImageViewer.this.scrollPane.getViewport().getExtentSize().getHeight() - XImageViewer.this.scale * (double)image.getHeight(this)) / 2.0;
        }
    }
}

