/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.control.text.DefaultLabel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.ui.UIOutput;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.ValueUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class XLabel
extends DefaultLabel
implements UIOutput,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private ControlProperty property = new ControlProperty();
    private Binding binding;
    private String[] depends;
    private String expression;
    private String visibleWhen;
    private String varName;
    private int index;
    private boolean useHtml;
    private boolean hideOnEmpty;
    private Insets padding;
    private Format format;
    private String labelFor;
    private boolean addCaptionColon = true;
    private boolean forceUseActiveCaption;
    private boolean antiAliasOn;
    private ControlProperty activeProperty;
    private JComponent activeComponent;
    private ActiveControlSupport activeControlSupport;
    private Logger logger;
    private int stretchWidth;
    private int stretchHeight;
    private String dateFormat;
    private String numberFormat;
    private String originalText;

    public XLabel() {
        this(false);
    }

    public XLabel(boolean forceUseActiveCaption) {
        this.forceUseActiveCaption = forceUseActiveCaption;
        this.setPadding(new Insets(1, 3, 1, 1));
        new MouseEventSupport(this).install();
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.getClass().getName());
        }
        return this.logger;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
    }

    public boolean isHideOnEmpty() {
        return this.hideOnEmpty;
    }

    public void setHideOnEmpty(boolean hideOnEmpty) {
        this.hideOnEmpty = hideOnEmpty;
    }

    public boolean isUseHtml() {
        return this.useHtml;
    }

    public void setUseHtml(boolean useHtml) {
        this.useHtml = useHtml;
        if (Beans.isDesignTime()) {
            this.showDesignTimeValue();
        }
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        if (Beans.isDesignTime()) {
            this.showDesignTimeValue();
        }
    }

    @Override
    public void setText(String text) {
        if (Beans.isDesignTime()) {
            this.setExpression(text);
        } else {
            this.setTextValue(text);
        }
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public Border getBorder() {
        Border border = super.getBorder();
        if (border instanceof BorderWrapper) {
            border = ((BorderWrapper)border).getBorder();
        }
        return border;
    }

    @Override
    public void setBorder(Border border) {
        BorderWrapper wrapper = new BorderWrapper(border, this.getPadding());
        super.setBorder(wrapper);
    }

    public void setBorderUI(String uiresource) {
        try {
            Border border = UIManager.getLookAndFeelDefaults().getBorder(uiresource);
            if (border != null) {
                this.setBorder(border);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getCaption() {
        return this.property.getCaption();
    }

    public void setCaption(String caption) {
        this.property.setCaption(caption);
    }

    public boolean isShowCaption() {
        return this.property.isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.property.setShowCaption(show);
    }

    public char getCaptionMnemonic() {
        return this.property.getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.property.setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.property.getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.property.setCaptionWidth(width);
    }

    public Font getCaptionFont() {
        return this.property.getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.property.setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.property.getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.property.setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.property.getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.property.setCellPadding(padding);
    }

    public String getFor() {
        return this.labelFor;
    }

    public void setFor(String name) {
        this.labelFor = name;
    }

    @Override
    public void setLabelFor(Component c) {
        this.activeComponent = (JComponent)c;
        if (c instanceof ActiveControl) {
            ActiveControl ac = (ActiveControl)((Object)c);
            this.activeProperty = ac.getControlProperty();
            String acCaption = this.activeProperty.getCaption();
            if (this.forceUseActiveCaption || !ValueUtil.isEmpty((Object)acCaption) && !acCaption.equals("Caption")) {
                this.setName(null);
                this.setExpression(null);
                this.formatText(this.activeProperty.getCaption(), this.activeProperty.isRequired());
                super.setDisplayedMnemonic(this.activeProperty.getCaptionMnemonic());
            }
            this.activeControlSupport = new ActiveControlSupport();
            this.activeProperty.addPropertyChangeListener(this.activeControlSupport);
        }
        super.setLabelFor(c);
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
        Border border = this.getBorder();
        if (border instanceof BorderWrapper) {
            border = ((BorderWrapper)border).getBorder();
        }
        super.setBorder(new BorderWrapper(border, this.getPadding()));
    }

    public boolean isAddCaptionColon() {
        return this.addCaptionColon;
    }

    public void setAddCaptionColon(boolean addCaptionColon) {
        this.addCaptionColon = addCaptionColon;
        this.formatText(this.activeProperty.getCaption(), this.activeProperty.isRequired());
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public boolean isAntiAliasOn() {
        return this.antiAliasOn;
    }

    public void setAntiAliasOn(boolean antiAliasOn) {
        this.antiAliasOn = antiAliasOn;
    }

    @Override
    public Color getBackground() {
        try {
            Color bgcolor;
            if (this.isOpaque() && !this.isEnabled() && (bgcolor = UIManager.getLookAndFeelDefaults().getColor("ComboBox.disabledBackground")) != null) {
                return bgcolor;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.getBackground();
    }

    @Override
    public Object getValue() {
        boolean hasName;
        Object beanValue = null;
        boolean bl = hasName = !ValueUtil.isEmpty((Object)this.getName());
        if (hasName) {
            beanValue = UIControlUtil.getBeanValue(this);
        }
        if (!ValueUtil.isEmpty((Object)this.expression)) {
            Object exprBean;
            Object object = exprBean = this.getBinding() == null ? null : this.getBinding().getBean();
            if (this.getVarName() != null) {
                exprBean = this.createExpressionBean(beanValue);
            }
            return UIControlUtil.evaluateExpr(exprBean, this.expression);
        }
        if (hasName) {
            return beanValue;
        }
        return super.getText();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (Beans.isDesignTime()) {
            this.showDesignTimeValue();
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int idx) {
        this.index = idx;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public void load() {
        UIControl c;
        if (!ValueUtil.isEmpty((Object)this.labelFor) && (c = this.binding.find(this.labelFor)) instanceof JComponent) {
            this.setLabelFor((JComponent)((Object)c));
        }
    }

    private Format getFormatter() {
        Format format = this.getFormat();
        if (format != null) {
            return format;
        }
        String pattern = this.getDateFormat();
        if (pattern != null && pattern.trim().length() > 0) {
            return new SimpleDateFormat(pattern);
        }
        pattern = this.getNumberFormat();
        if (pattern != null && pattern.trim().length() > 0) {
            return new DecimalFormat(pattern);
        }
        return null;
    }

    @Override
    public void refresh() {
        block5: {
            try {
                String name = this.getName();
                boolean hasName = name != null && name.length() > 0;
                Binding binding = this.getBinding();
                Object beanValue = null;
                if (hasName) {
                    beanValue = UIControlUtil.getBeanValue(binding, name);
                }
                Object value = null;
                String exprStr = this.getExpression();
                Object exprBean = this.createExpressionBean(beanValue);
                value = exprStr != null && exprStr.length() > 0 ? UIControlUtil.evaluateExpr(exprBean, exprStr) : (hasName ? beanValue : super.getText());
                Format format = this.getFormatter();
                Object fvalue = this.formatValue(format, value);
                this.setTextValue(fvalue == null ? "" : fvalue.toString());
                String exprWhen = this.getVisibleWhen();
                if (exprWhen == null || exprWhen.length() <= 0) break block5;
                boolean result = false;
                try {
                    result = UIControlUtil.evaluateExprBoolean(exprBean, exprWhen);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.setVisible(result);
            }
            catch (Throwable e) {
                this.setTextValue("");
                if (!ClientContext.getCurrentContext().isDebugMode()) break block5;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("expression", this.getExpression());
        map.put("format", this.getFormat());
        map.put("varName", this.getVarName());
        map.put("visibleWhen", this.getVisibleWhen());
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public ControlProperty getControlProperty() {
        return this.property;
    }

    @Override
    public boolean isVisible() {
        boolean b = super.isVisible();
        if (Beans.isDesignTime()) {
            return b;
        }
        if (!this.isHideOnEmpty()) {
            return b;
        }
        if (!b) {
            return false;
        }
        String text = super.getText();
        return text == null ? false : text.trim().length() > 0;
    }

    @Override
    public void setDisplayedMnemonic(char aChar) {
        super.setDisplayedMnemonic(aChar);
        if (aChar == '\u0000') {
            return;
        }
        String text = this.getText().toLowerCase();
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != aChar) continue;
            this.setDisplayedMnemonicIndex(i);
            return;
        }
        Pattern p = Pattern.compile("<.*?>");
        Matcher m = p.matcher(text);
        int startindex = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            if (start > startindex) {
                chars = text.substring(startindex, start).toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    if (chars[i] != aChar) continue;
                    this.setDisplayedMnemonicIndex(startindex + i);
                    return;
                }
            }
            startindex = end;
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.isAntiAliasOn()) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paint(g2);
            g2.dispose();
        } else {
            super.paint(g);
        }
    }

    private void showDesignTimeValue() {
        if (!Beans.isDesignTime()) {
            return;
        }
        String str = null;
        str = this.getExpression();
        if (str != null) {
            super.setText(this.resolveText(str));
        } else {
            str = this.getName();
            if (str != null) {
                super.setText(str);
            } else {
                super.setText("");
            }
        }
    }

    private void setTextValue(String text) {
        this.originalText = text;
        super.setText(this.resolveText(text));
    }

    private String resolveText(String text) {
        if (this.isUseHtml() && text != null) {
            if (text.trim().length() == 0) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            if (text.toLowerCase().indexOf("<html>") < 0) {
                sb.append("<html>");
            }
            sb.append(text);
            if (text.toLowerCase().lastIndexOf("</html>") < 0) {
                sb.append("</html>");
            }
            return sb.toString();
        }
        return text;
    }

    private Object createExpressionBean(Object itemBean) {
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        ExprBeanSupport beanSupport = new ExprBeanSupport(bean);
        if (itemBean != null) {
            beanSupport.setItem(this.getVarName(), itemBean);
        }
        beanSupport.setItem("MODEL", bean);
        return beanSupport.createProxy();
    }

    private void formatText(String text, boolean required) {
        StringBuffer sb = new StringBuffer(text);
        if (this.addCaptionColon && !ValueUtil.isEmpty((Object)text)) {
            sb.append(" :");
        }
        if (required) {
            int mnem = this.getDisplayedMnemonic();
            int idx = XLabel.findDisplayedMnemonicIndex(sb, mnem);
            if (idx != -1) {
                sb.replace(idx, idx + 1, "<u>" + sb.charAt(idx) + "</u>");
            }
            sb.insert(0, "<html>");
            sb.append(" <font color=\"red\">*</font>");
            sb.append("</html>");
        }
        super.setText(sb.toString());
    }

    static int findDisplayedMnemonicIndex(StringBuffer text, int mnemonic) {
        if (text == null || mnemonic == 0) {
            return -1;
        }
        char uc = Character.toUpperCase((char)mnemonic);
        char lc = Character.toLowerCase((char)mnemonic);
        int uci = text.indexOf(uc + "");
        int lci = text.indexOf(lc + "");
        if (uci == -1) {
            return lci;
        }
        if (lci == -1) {
            return uci;
        }
        return lci < uci ? lci : uci;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object formatValue(Format fm, Object value) {
        if (value == null || fm == null) {
            return value;
        }
        if (fm instanceof DecimalFormat) {
            try {
                if (value instanceof Number) {
                    return fm.format((Number)value);
                }
                return fm.format(new BigDecimal(value.toString()));
            }
            catch (Throwable throwable) {
                return value;
            }
        }
        if (!(fm instanceof SimpleDateFormat)) {
        }
        try {
            void var3_10;
            void var3_6;
            if (value instanceof java.util.Date) {
                return fm.format((java.util.Date)value);
            }
            Object var3_4 = null;
            String str = value.toString();
            String[] arr = str.split(" ");
            if (arr.length == 6) {
                StringBuilder sb = new StringBuilder();
                sb.append(arr[1]).append("-").append(arr[2]).append("-").append(arr[5]).append(" ").append(arr[3]);
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("MMM-dd-yyyy HH:mm:ss");
                    java.util.Date date = sdf.parse(sb.toString());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (var3_6 == null) {
                if (str.matches("[0-9]{4,4}-[0-9]{2,2}-[0-9]{2,2} [0-9]{2,2}:[0-9]{2,2}:[0-9]{2,2}[.][0-9]{1,}")) {
                    Timestamp timestamp = Timestamp.valueOf(str);
                } else if (str.matches("[0-9]{4,4}-[0-9]{2,2}-[0-9]{2,2} [0-9]{2,2}:[0-9]{2,2}:[0-9]{2,2}")) {
                    Timestamp timestamp = Timestamp.valueOf(str);
                } else if (str.matches("[0-9]{4,4}-[0-9]{2,2}-[0-9]{2,2}")) {
                    Date date = Date.valueOf(str);
                }
            }
            if (var3_10 != null) {
                return fm.format(var3_10);
            }
        }
        finally {
            return value;
        }
    }

    private class BorderWrapper
    extends AbstractBorder {
        XLabel root;
        private Border border;
        private Insets padding;

        BorderWrapper(Border border, Insets padding) {
            this.root = XLabel.this;
            this.border = border instanceof BorderWrapper ? ((BorderWrapper)border).getBorder() : border;
            this.padding = this.copy(padding);
        }

        public Border getBorder() {
            return this.border;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets ins) {
            if (ins == null) {
                new Insets(0, 0, 0, 0);
            }
            ins.right = 0;
            ins.bottom = 0;
            ins.left = 0;
            ins.top = 0;
            if (this.border != null) {
                Insets ins0 = this.border.getBorderInsets(c);
                ins.top += ins0.top;
                ins.left += ins0.left;
                ins.bottom += ins0.bottom;
                ins.right += ins0.right;
            }
            ins.top += this.padding.top;
            ins.left += this.padding.left;
            ins.bottom += this.padding.bottom;
            ins.right += this.padding.right;
            return ins;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (this.border != null) {
                this.border.paintBorder(c, g, x, y, w, h);
            }
        }

        private Insets copy(Insets padding) {
            if (padding == null) {
                return new Insets(0, 0, 0, 0);
            }
            return new Insets(padding.top, padding.left, padding.bottom, padding.right);
        }
    }

    private class ActiveControlSupport
    implements PropertyChangeListener {
        XLabel root;
        private Color oldFg;

        private ActiveControlSupport() {
            this.root = XLabel.this;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            Object value = evt.getNewValue();
            if ("caption".equals(propName)) {
                String text = value == null ? "" : value + "";
                XLabel.this.formatText(text, XLabel.this.activeProperty.isRequired());
            } else if ("captionMnemonic".equals(propName)) {
                XLabel.this.setDisplayedMnemonic((value + "").charAt(0));
                XLabel.this.formatText(XLabel.this.activeProperty.getCaption(), XLabel.this.activeProperty.isRequired());
            } else if ("required".equals(propName)) {
                boolean required = "true".equals(value + "");
                XLabel.this.formatText(XLabel.this.activeProperty.getCaption(), required);
            } else if ("errorMessage".equals(propName)) {
                boolean error;
                String message = value != null ? value + "" : null;
                boolean bl = error = !ValueUtil.isEmpty(message);
                if (error) {
                    this.oldFg = XLabel.this.getForeground();
                    XLabel.this.setForeground(Color.RED);
                } else {
                    XLabel.this.setForeground(this.oldFg);
                }
                XLabel.this.setToolTipText(message);
                if (XLabel.this.activeComponent != null) {
                    XLabel.this.activeComponent.setToolTipText(message);
                }
            }
        }
    }
}

