/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.common.PropertyResolver;
import com.rameses.platform.interfaces.Platform;
import com.rameses.platform.interfaces.SubWindow;
import com.rameses.rcp.common.LookupDataSource;
import com.rameses.rcp.common.LookupHandler;
import com.rameses.rcp.common.LookupModel;
import com.rameses.rcp.common.LookupOpenerSupport;
import com.rameses.rcp.common.LookupSelector;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.SimpleLookupDataSource;
import com.rameses.rcp.common.WindowUtil;
import com.rameses.rcp.constant.TextCase;
import com.rameses.rcp.constant.TrimSpaceOption;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.control.text.IconedTextField;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.framework.UIControllerContext;
import com.rameses.rcp.framework.UIControllerPanel;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.support.TextDocument;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UILookup;
import com.rameses.rcp.ui.UISelector;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.rcp.util.ControlSupport;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import com.rameses.util.BreakException;
import com.rameses.util.ValueUtil;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class XLookupField
extends IconedTextField
implements UILookup,
UISelector,
Validatable,
ActiveControl,
ActionListener,
LookupSelector,
MouseEventSupport.ComponentInfo {
    protected ControlProperty property = new ControlProperty();
    protected ActionMessage actionMessage = new ActionMessage();
    private LookupHandlerProxy lookupHandlerProxy = new LookupHandlerProxy();
    private LookupInputSupport inputSupport = new LookupInputSupport();
    private TrimSpaceOption trimSpaceOption = TrimSpaceOption.ALL;
    private TextDocument document = new TextDocument();
    private Binding binding;
    private String[] depends;
    private int index;
    private String varName = "item";
    private String handler;
    private Object handlerObject;
    private Object selectedValue;
    private String expression;
    private String returnFields;
    private String disableWhen;
    private String visibleWhen;
    private boolean transferFocusOnSelect = true;
    private boolean dirty;
    private boolean loaded;
    private boolean nullWhenEmpty = true;
    private int stretchWidth;
    private int stretchHeight;
    private int selectionOption = 2;

    public XLookupField() {
        super("com/rameses/rcp/icons/search.png");
        this.initComponent();
    }

    private void initComponent() {
        this.setOrientation("RIGHT");
        this.document.setTextCase(TextCase.UPPER);
        this.setDocument(this.document);
        if (Beans.isDesignTime()) {
            this.document.setTextCase(TextCase.NONE);
            return;
        }
        this.addActionMapping("ACTION_MAPPING_KEY_ESCAPE", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    XLookupField.this.refresh();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        new MouseEventSupport(this).install();
        this.setMargin(new Insets(1, 5, 1, 1));
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public boolean isNullWhenEmpty() {
        return this.nullWhenEmpty;
    }

    public void setNullWhenEmpty(boolean nullWhenEmpty) {
        this.nullWhenEmpty = nullWhenEmpty;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public Object getHandlerObject() {
        return this.handlerObject;
    }

    public void setHandlerObject(Object handlerObject) {
        this.handlerObject = handlerObject;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        super.setText(expression);
    }

    @Override
    public String getText() {
        if (Beans.isDesignTime()) {
            if (!ValueUtil.isEmpty((Object)this.expression)) {
                return this.expression;
            }
            if (!ValueUtil.isEmpty((Object)this.getName())) {
                return this.getName();
            }
            return super.getText();
        }
        return super.getText();
    }

    public boolean isTransferFocusOnSelect() {
        return this.transferFocusOnSelect;
    }

    public void setTransferFocusOnSelect(boolean transerFocusOnSelect) {
        this.transferFocusOnSelect = transerFocusOnSelect;
    }

    public TextCase getTextCase() {
        return this.document.getTextCase();
    }

    public void setTextCase(TextCase textCase) {
        this.document.setTextCase(textCase);
    }

    public TrimSpaceOption getTrimSpaceOption() {
        return this.trimSpaceOption;
    }

    public void setTrimSpaceOption(TrimSpaceOption option) {
        this.trimSpaceOption = option;
    }

    private UIInputUtil.Support getInputSupport() {
        Object o;
        if (this.inputSupport.delegate == null && (o = this.getClientProperty(UIInputUtil.Support.class)) != null) {
            this.inputSupport.delegate = (UIInputUtil.Support)o;
        }
        return this.inputSupport;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
        if (info == null) {
            return;
        }
        PropertyInfoWrapper pi = new PropertyInfoWrapper(info);
        this.setExpression(pi.getExpression());
        Object handler = pi.getHandler();
        if (handler instanceof String) {
            this.setHandler(handler.toString());
            this.setHandlerObject(null);
        } else {
            this.setHandler(null);
            this.setHandlerObject(handler);
        }
    }

    public String getReturnFields() {
        return this.returnFields;
    }

    public void setReturnFields(String returnFields) {
        this.returnFields = returnFields;
    }

    @Override
    public String getDisableWhen() {
        return this.disableWhen;
    }

    @Override
    public void setDisableWhen(String disableWhen) {
        this.disableWhen = disableWhen;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    protected InputVerifier getChildInputVerifier() {
        return this.inputSupport;
    }

    @Override
    protected void onprocessKeyEvent(KeyEvent e) {
        if (e.isActionKey() || e.isAltDown() || e.isControlDown()) {
            return;
        }
        this.dirty = true;
    }

    @Override
    public boolean requestFocusInWindow() {
        if (!this.isEnabled()) {
            this.transferFocus();
            return false;
        }
        return super.requestFocusInWindow();
    }

    @Override
    public boolean focusFirstInput() {
        this.getBinding().Utils.focusComponent(this);
        return true;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public void refresh() {
        Object bindingBean;
        boolean hasBindingName;
        this.updateBackground();
        Object itemBean = null;
        boolean bl = hasBindingName = !ValueUtil.isEmpty((Object)this.getName());
        if (hasBindingName) {
            try {
                itemBean = UIControlUtil.getBeanValue(this);
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
            catch (Throwable t) {
                System.out.println("[WARN] error caused by " + t.getMessage());
            }
        }
        Object expval = null;
        Object object = bindingBean = this.getBinding() == null ? null : this.getBinding().getBean();
        if (bindingBean != null) {
            Object exprBean = this.createExpressionBean(itemBean);
            String sval = this.getDisableWhen();
            if (sval != null && sval.length() > 0) {
                try {
                    this.setEnabled(!UIControlUtil.evaluateExprBoolean(exprBean, sval));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (!this.isEnabled() && this.hasFocus()) {
                    this.transferFocus();
                }
            }
            if ((sval = this.getExpression()) != null && sval.length() > 0) {
                expval = UIControlUtil.evaluateExpr(exprBean, this.expression);
            }
            if ((sval = this.getVisibleWhen()) != null && sval.length() > 0) {
                try {
                    this.setVisible(UIControlUtil.evaluateExprBoolean(exprBean, sval));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (!this.isVisible() && this.hasFocus()) {
                    this.transferFocus();
                }
            }
        }
        if (hasBindingName && (itemBean == null || itemBean.toString().trim().length() == 0)) {
            this.setText(null);
        } else {
            this.setText(expval == null ? null : expval.toString());
        }
    }

    @Override
    public void load() {
        this.dirty = false;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    private Object createExpressionBean(Object itemBean) {
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        ExprBeanSupport beanSupport = new ExprBeanSupport(bean);
        beanSupport.setItem(this.getVarName(), itemBean);
        beanSupport.setItem("MODEL", bean);
        beanSupport.setItem("DATA", this.getClientProperty("UIControl.userObject"));
        return beanSupport.createProxy();
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("disableWhen", this.getDisableWhen());
        map.put("expression", this.getExpression());
        map.put("focusAccelerator", Character.valueOf(this.getFocusAccelerator()));
        map.put("handler", this.getHandler());
        map.put("handlerObject", this.getHandlerObject());
        map.put("returnFields", this.getReturnFields());
        map.put("varName", this.getVarName());
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof EventObject) {
            if (value instanceof KeyEvent) {
                this.setText(((KeyEvent)value).getKeyChar() + "");
            }
        } else if (value != null) {
            this.setText(value.toString());
        } else {
            this.setText("");
        }
        this.dirty = false;
    }

    @Override
    public String getCaption() {
        return this.property.getCaption();
    }

    @Override
    public void setCaption(String caption) {
        this.property.setCaption(caption);
    }

    @Override
    public boolean isRequired() {
        return this.property.isRequired();
    }

    @Override
    public void setRequired(boolean required) {
        this.property.setRequired(required);
    }

    public char getCaptionMnemonic() {
        return this.property.getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.property.setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.property.getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.property.setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.property.isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.property.setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.property.getCaptionFont();
    }

    public void setCaptionFont(Font font) {
        this.property.setCaptionFont(font);
    }

    public String getCaptionFontStyle() {
        return this.property.getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.property.setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.property.getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.property.setCellPadding(padding);
    }

    @Override
    public ActionMessage getActionMessage() {
        return this.actionMessage;
    }

    @Override
    public void validateInput() {
        this.validateInput(this.actionMessage);
    }

    public void validateInput(ActionMessage am) {
        am.clearMessages();
        this.property.setErrorMessage(null);
        if (ValueUtil.isEmpty((Object)this.getText()) && this.isRequired()) {
            am.addMessage("1001", "{0} is required.", new Object[]{this.getCaption()});
        }
        if (am.hasMessages()) {
            this.property.setErrorMessage(am.toString());
        }
    }

    @Override
    public ControlProperty getControlProperty() {
        return this.property;
    }

    @Override
    protected void onactionPerformed(ActionEvent e) {
        this.fireLookup();
    }

    private void fireLookup() {
        block13: {
            if (Beans.isDesignTime()) {
                return;
            }
            if (this.isReadonly()) {
                return;
            }
            try {
                UIController c;
                this.getInputVerifierProxy().setEnabled(false);
                Object obj = this.loadHandler();
                this.loaded = true;
                if (obj instanceof Throwable) {
                    if (!(obj instanceof BreakException)) {
                        MsgBox.err((Throwable)obj);
                    }
                    this.getInputVerifierProxy().setEnabled(true);
                    return;
                }
                if (this.lookupHandlerProxy.getModel() == null) {
                    MsgBox.alert("No available lookup model found. Please check.");
                    return;
                }
                this.selectionOption = 2;
                this.lookupHandlerProxy.getModel().setSelector(this);
                this.lookupHandlerProxy.getModel().setReturnFields(this.getReturnFields());
                boolean show = this.lookupHandlerProxy.getModel().show(this.getText());
                if (!show) break block13;
                LookupDataSource oModel = this.lookupHandlerProxy.getModel();
                if (oModel instanceof LookupModel) {
                    ((LookupModel)oModel).setSelectedItem(-1);
                }
                if ((c = this.lookupHandlerProxy.getController()) == null) {
                    return;
                }
                UIControllerContext uic = new UIControllerContext(c);
                Platform platform = ClientContext.getCurrentContext().getPlatform();
                String conId = uic.getId();
                if (conId == null) {
                    conId = this.getName() + this.handler;
                }
                if (platform.isWindowExists(conId)) {
                    return;
                }
                UIControllerPanel lookupPanel = new UIControllerPanel(uic);
                new WindowSupport().install(lookupPanel);
                Map<String, String> props = new HashMap<String, String>();
                try {
                    Map openerProps = this.lookupHandlerProxy.opener.getProperties();
                    props = WindowUtil.extractWindowAttrs(openerProps);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                props.put("id", conId);
                props.put("title", uic.getTitle());
                platform.showPopup(this, lookupPanel, props);
            }
            catch (Throwable e) {
                MsgBox.err(e);
                this.getInputVerifierProxy().setEnabled(true);
            }
        }
    }

    @Override
    public Object select(Object value) {
        this.selectedValue = value;
        this.selectionOption = 0;
        LookupDataSource lds = this.lookupHandlerProxy.getModel();
        String flds = lds.getReturnFields();
        if (flds != null && flds.length() > 0) {
            this.selectedValue = new ResultFieldsMapper().parse(flds, value);
        } else {
            String itemKey = lds.getReturnItemKey();
            String itemVal = lds.getReturnItemValue();
            this.selectedValue = new ResultKeyValueMapper().parse(itemKey, itemVal, value);
        }
        Object outcome = this.getInputSupport().setValue(this.getName(), this.selectedValue);
        this.putClientProperty("updateBeanValue", true);
        this.getInputVerifierProxy().setEnabled(true);
        if (this.lookupHandlerProxy.hasOnselectCallback()) {
            this.putClientProperty("cellEditorValue", "no_updates");
        }
        if (outcome instanceof Opener || "_close".equals(outcome)) {
            return outcome;
        }
        if (this.transferFocusOnSelect) {
            this.transferFocus();
        } else {
            this.requestFocus();
        }
        return null;
    }

    @Override
    public void cancelSelection() {
        this.putClientProperty("updateBeanValue", false);
        this.getInputVerifierProxy().setEnabled(true);
        this.requestFocus();
    }

    private Object loadHandler() {
        Binding oBinding;
        Object o = null;
        if (!ValueUtil.isEmpty((Object)this.handler)) {
            if (this.handler.matches(".+:.+")) {
                o = LookupOpenerSupport.lookupOpener(this.handler, new HashMap());
            } else {
                oBinding = (Binding)this.getClientProperty(Binding.class);
                if (oBinding == null) {
                    oBinding = this.getBinding();
                }
                if ((o = UIControlUtil.getBeanValue(oBinding, this.handler)) instanceof Throwable) {
                    return o;
                }
            }
        } else if (this.handlerObject != null) {
            o = this.handlerObject;
        }
        if (o == null) {
            return null;
        }
        if (o instanceof LookupHandler) {
            LookupHandler lh = (LookupHandler)o;
            this.lookupHandlerProxy.setHandler(lh);
            o = lh.getOpener();
        }
        if (o instanceof Opener) {
            oBinding = (Binding)this.getClientProperty(Binding.class);
            if (oBinding == null) {
                oBinding = this.getBinding();
            }
            Opener opener = (Opener)o;
            opener = ControlSupport.initOpener(opener, oBinding.getController());
            this.lookupHandlerProxy.setOpener(opener);
        }
        return null;
    }

    private class LookupDataSourceProxy
    implements LookupDataSource {
        SimpleLookupDataSource source;
        LookupSelector selector;

        LookupDataSourceProxy(SimpleLookupDataSource source) {
            this.source = source;
        }

        @Override
        public Object getOnselect() {
            return null;
        }

        @Override
        public Object getOnempty() {
            return null;
        }

        @Override
        public LookupSelector getSelector() {
            return this.selector;
        }

        @Override
        public void setSelector(LookupSelector selector) {
            this.selector = selector;
            this.source.setSelector(selector);
        }

        @Override
        public boolean show(String searchtext) {
            this.source.setSearchText(searchtext);
            return true;
        }

        @Override
        public String getReturnItemKey() {
            return null;
        }

        @Override
        public void setReturnItemKey(String returnItemKey) {
        }

        @Override
        public String getReturnItemValue() {
            return null;
        }

        @Override
        public void setReturnItemValue(String returnItemValue) {
        }

        @Override
        public String getReturnFields() {
            return null;
        }

        @Override
        public void setReturnFields(String returnFields) {
        }
    }

    private class ResultFieldsMapper {
        PropertyResolver res = PropertyResolver.getInstance();

        private ResultFieldsMapper() {
        }

        public Object parse(String fields, Object value) {
            if (value == null || fields == null) {
                return value;
            }
            String[] fldnames = fields.split(",");
            if (value instanceof List) {
                ArrayList<Object> results = new ArrayList<Object>();
                for (Object o : (List)value) {
                    Object xo = this.extract(fldnames, o);
                    if (xo == null) continue;
                    results.add(xo);
                }
                return results;
            }
            if (value != null) {
                return this.extract(fldnames, value);
            }
            return null;
        }

        private Object extract(String[] fldnames, Object o) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String name : fldnames) {
                if (name == null || name.length() == 0) continue;
                map.put(name, this.res.getProperty(o, name));
            }
            return map;
        }
    }

    private class ResultKeyValueMapper {
        PropertyResolver res = PropertyResolver.getInstance();

        private ResultKeyValueMapper() {
        }

        public Object parse(String itemKey, String itemVal, Object value) {
            if (value == null) {
                return null;
            }
            if (itemKey == null && itemVal == null) {
                return value;
            }
            if (itemKey != null && itemVal == null) {
                itemVal = itemKey;
            } else if (itemKey == null && itemVal != null) {
                itemKey = itemVal;
            }
            if (value instanceof List) {
                ArrayList<Object> results = new ArrayList<Object>();
                for (Object o : (List)value) {
                    Object xo = this.extract(itemKey, itemVal, o);
                    if (xo == null) continue;
                    results.add(xo);
                }
                return results;
            }
            if (value != null) {
                return this.extract(itemKey, itemVal, value);
            }
            return null;
        }

        private Object extract(String itemKey, String itemVal, Object o) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (itemKey != null) {
                map.put("key", this.res.getProperty(o, itemKey));
            }
            if (itemVal != null) {
                map.put("value", this.res.getProperty(o, itemVal));
            }
            return map;
        }
    }

    private class PropertyInfoWrapper {
        private PropertySupport.LookupPropertyInfo property;
        private Map map = new HashMap();

        PropertyInfoWrapper(PropertySupport.PropertyInfo info) {
            if (info instanceof Map) {
                this.map = (Map)((Object)info);
            }
            if (info instanceof PropertySupport.LookupPropertyInfo) {
                this.property = (PropertySupport.LookupPropertyInfo)info;
            }
        }

        public Object getHandler() {
            Object value = this.map.get("handler");
            if (value == null && this.property != null) {
                value = this.property.getHandler();
            }
            return value;
        }

        public String getExpression() {
            Object value = this.map.get("expression");
            if (value == null && this.property != null) {
                value = this.property.getExpression();
            }
            return value == null ? null : value.toString();
        }
    }

    private class WindowSupport
    implements AncestorListener,
    ActionListener,
    PropertyChangeListener {
        private JComponent component;

        private WindowSupport() {
        }

        void install(JComponent comp) {
            this.component = comp;
            comp.addAncestorListener(this);
            comp.addPropertyChangeListener("Window.close", this);
        }

        @Override
        public void ancestorAdded(AncestorEvent e) {
            JRootPane rootPane = this.component.getRootPane();
            if (rootPane == null) {
                return;
            }
            rootPane.putClientProperty("Window.closeAction", this);
        }

        @Override
        public void ancestorRemoved(AncestorEvent e) {
        }

        @Override
        public void ancestorMoved(AncestorEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRootPane rootPane = this.component.getRootPane();
            if (rootPane == null) {
                return;
            }
            Container parent = rootPane.getParent();
            if (parent instanceof SubWindow) {
                ((SubWindow)((Object)parent)).closeWindow();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (XLookupField.this.selectionOption == 2) {
                XLookupField.this.cancelSelection();
            }
        }
    }

    private class LookupInputSupport
    extends InputVerifier
    implements UIInputUtil.Support {
        UIInputUtil.Support delegate;

        private LookupInputSupport() {
        }

        @Override
        public boolean verify(JComponent input) {
            if (!XLookupField.this.dirty) {
                return true;
            }
            if (XLookupField.this.isReadonly() || !XLookupField.this.isEnabled() || !XLookupField.this.isEditable()) {
                return true;
            }
            try {
                if (!XLookupField.this.loaded) {
                    XLookupField.this.loadHandler();
                    XLookupField.this.loaded = true;
                }
            }
            catch (Throwable t) {
                System.out.println("[XLookupField] error on field " + XLookupField.this.getName());
                t.printStackTrace();
                return true;
            }
            XLookupField jcomp = XLookupField.this;
            jcomp.putClientProperty("UIControl.value", null);
            String text = XLookupField.this.getText();
            if (!ValueUtil.isEmpty((Object)XLookupField.this.getExpression()) && ValueUtil.isEmpty((Object)text)) {
                HashMap value;
                HashMap hashMap = value = XLookupField.this.isNullWhenEmpty() ? null : new HashMap();
                if (XLookupField.this.lookupHandlerProxy.hasOnemptyCallback()) {
                    XLookupField.this.lookupHandlerProxy.invokeOnempty(value);
                } else {
                    this.updateBeanValue(input.getName(), value);
                }
                jcomp.putClientProperty("UIControl.value", new Object[]{value});
                XLookupField.this.selectedValue = null;
            }
            this.publishUpdates();
            return true;
        }

        @Override
        public Object setValue(String name, Object value) {
            return this.setValue(name, value, null);
        }

        @Override
        public Object setValue(String name, Object value, JComponent jcomp) {
            XLookupField xlkp = XLookupField.this;
            xlkp.putClientProperty("UIControl.value", null);
            Object outcome = null;
            if (XLookupField.this.lookupHandlerProxy.hasOnselectCallback()) {
                outcome = XLookupField.this.lookupHandlerProxy.invokeOnselect(value);
            } else {
                this.updateBeanValue(name, value);
            }
            xlkp.putClientProperty("UIControl.value", new Object[]{value});
            this.publishUpdates();
            XLookupField.this.dirty = false;
            return outcome;
        }

        private void updateBeanValue(String name, Object value) {
            if (name == null) {
                return;
            }
            if (this.delegate == null) {
                Object bean = XLookupField.this.binding.getBean();
                if (bean != null) {
                    PropertyResolver resolver = PropertyResolver.getInstance();
                    resolver.setProperty(XLookupField.this.binding.getBean(), name, value);
                    XLookupField.this.binding.getValueChangeSupport().notify(name, value);
                }
            } else {
                this.delegate.setValue(name, value, XLookupField.this);
            }
        }

        private void publishUpdates() {
            if (this.delegate == null) {
                XLookupField.this.refresh();
                XLookupField.this.binding.notifyDepends(XLookupField.this);
            }
        }
    }

    private class LookupHandlerProxy
    implements LookupHandler {
        private Object codeBean;
        private LookupDataSource model;
        private LookupHandler handler;
        private Opener opener;
        private Object onselectCallback;
        private Object onemptyCallback;

        private LookupHandlerProxy() {
        }

        LookupDataSource getModel() {
            return this.model;
        }

        UIController getController() {
            return this.opener == null ? null : this.opener.getController();
        }

        boolean hasOnselectCallback() {
            return this.onselectCallback != null;
        }

        boolean hasOnemptyCallback() {
            return this.onemptyCallback != null;
        }

        void setHandler(LookupHandler handler) {
            this.handler = handler;
        }

        void setOpener(Opener opener) {
            if (opener != null) {
                UIController controller;
                if (opener.getParams() != null) {
                    this.onselectCallback = opener.getParams().get("onselect");
                    this.onemptyCallback = opener.getParams().get("onempty");
                }
                if ((controller = opener.getController()) == null) {
                    throw new IllegalStateException("'" + opener.getName() + "' opener must have a controller");
                }
                this.model = null;
                this.codeBean = controller.getCodeBean();
                if (this.codeBean instanceof LookupDataSource) {
                    this.model = (LookupDataSource)this.codeBean;
                } else if (this.codeBean instanceof SimpleLookupDataSource) {
                    this.model = new LookupDataSourceProxy((SimpleLookupDataSource)this.codeBean);
                } else {
                    throw new IllegalStateException("'" + opener.getName() + "' opener controller must be an instance of LookupDataSource");
                }
                controller.setId(opener.getId());
                controller.setName(opener.getName());
                controller.setTitle(opener.getCaption());
                Object callback = this.model.getOnselect();
                if (callback != null) {
                    this.onselectCallback = callback;
                }
                if ((callback = this.model.getOnempty()) != null) {
                    this.onemptyCallback = callback;
                }
            } else {
                this.model = null;
            }
            this.opener = opener;
        }

        @Override
        public Object getOpener() {
            if (this.handler != null) {
                return this.handler.getOpener();
            }
            return this.opener;
        }

        @Override
        public void onselect(Object item) {
            if (this.handler != null) {
                this.handler.onselect(item);
            }
        }

        Object invokeOnempty(Object value) {
            return this.invokeHandler(this.onemptyCallback, value);
        }

        Object invokeOnselect(Object item) {
            return this.invokeHandler(this.onselectCallback, item);
        }

        private Object invokeHandler(Object handler, Object item) {
            if (handler == null) {
                return null;
            }
            Method method = null;
            Class<?> clazz = handler.getClass();
            try {
                method = clazz.getMethod("call", Object.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (method != null) {
                    return method.invoke(handler, item);
                }
                return null;
            }
            catch (RuntimeException re) {
                re.printStackTrace();
                throw re;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
    }
}

