/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.common.MethodResolver;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.control.text.AbstractMaskField;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.util.HashMap;
import java.util.Map;
import javax.swing.InputVerifier;

public class XMaskField
extends AbstractMaskField
implements UIInput,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private Binding binding;
    private String[] depends;
    private int index;
    private boolean nullWhenEmpty;
    private boolean immediate;
    private ControlProperty controlProperty;
    private ActionCommandInvoker actionCommandInvoker;
    private int stretchWidth;
    private int stretchHeight;

    public XMaskField() {
        this.initComponent();
    }

    private void initComponent() {
        if (Beans.isDesignTime()) {
            return;
        }
        this.actionCommandInvoker = new ActionCommandInvoker();
        this.addActionMapping("ACTION_MAPPING_KEY_ESCAPE", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    XMaskField.this.refresh();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        new MouseEventSupport(this).install();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (Beans.isDesignTime()) {
            super.setText(name == null ? "" : name);
        }
    }

    @Override
    protected InputVerifier getChildInputVerifier() {
        return UIInputUtil.VERIFIER;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public boolean isNullWhenEmpty() {
        return this.nullWhenEmpty;
    }

    public void setNullWhenEmpty(boolean nullWhenEmpty) {
        this.nullWhenEmpty = nullWhenEmpty;
    }

    @Override
    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public void setRequestFocus(boolean focus) {
    }

    @Override
    public void load() {
        this.updateMask();
        String cmd = this.getActionCommand();
        if (cmd != null && cmd.length() > 0) {
            this.removeActionMapping("ACTION_MAPPING_KEY_ENTER", this.actionCommandInvoker);
            this.addActionMapping("ACTION_MAPPING_KEY_ENTER", this.actionCommandInvoker);
        }
    }

    @Override
    public void refresh() {
        block8: {
            try {
                this.updateBackground();
                String whenExpr = this.getVisibleWhen();
                Binding binding = this.getBinding();
                if (whenExpr != null && whenExpr.length() > 0) {
                    boolean result = false;
                    try {
                        result = UIControlUtil.evaluateExprBoolean(binding.getBean(), whenExpr);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    this.setVisible(result);
                }
                if ((whenExpr = this.getDisableWhen()) != null && whenExpr.length() > 0) {
                    boolean disabled = false;
                    try {
                        disabled = UIControlUtil.evaluateExprBoolean(binding.getBean(), whenExpr);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    this.setEnabled(!disabled);
                }
                Object value = UIControlUtil.getBeanValue(this);
                this.setValue(value);
            }
            catch (Exception e) {
                this.setValue(null);
                if (!ClientContext.getCurrentContext().isDebugMode()) break block8;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionCommand", this.getActionCommand());
        map.put("focusAccelerator", Character.valueOf(this.getFocusAccelerator()));
        map.put("mask", this.getMask());
        map.put("includeLiteral", this.isIncludeLiteral());
        map.put("required", this.isRequired());
        return map;
    }

    @Override
    public Object getValue() {
        return super.getValue();
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.controlProperty == null) {
            this.controlProperty = new ControlProperty();
        }
        return this.controlProperty;
    }

    public boolean isRequired() {
        return this.getControlProperty().isRequired();
    }

    public void setRequired(boolean required) {
        this.getControlProperty().setRequired(required);
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.getControlProperty().setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    private class ActionCommandInvoker
    implements ActionListener {
        XMaskField root;

        private ActionCommandInvoker() {
            this.root = XMaskField.this;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String cmd = this.root.getActionCommand();
                if (cmd == null || cmd.length() == 0) {
                    return;
                }
                UIInputUtil.updateBeanValue(this.root);
                Object bean = this.root.getBinding().getBean();
                Object outcome = MethodResolver.getInstance().invoke(bean, cmd, new Object[0]);
                if (outcome instanceof Opener) {
                    this.root.getBinding().fireNavigation(outcome);
                }
            }
            catch (Throwable t) {
                MsgBox.err(t);
            }
        }
    }
}

