/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.ObjectProxy;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.swing.RadioListPanel;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XRadioList
extends RadioListPanel
implements UIControl,
Validatable,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private ControlProperty property;
    private Binding binding;
    private String[] depends;
    private int index;
    private boolean dynamic;
    private boolean required;
    private String visibleWhen;
    private String handler;
    private String itemKey;
    private String itemExpression;
    private String varName = "item";
    private RadioListModel model;
    private Object modelObject;
    private int stretchWidth;
    private int stretchHeight;
    private FontSupport fontSupport;
    private Font preferredFont;
    private Font sourceFont;
    private String fontStyle;
    private boolean refreshed;
    private ActionMessage actionMessage;

    public XRadioList() {
        this.setItemCount(2);
    }

    private FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    @Override
    public Font getFont() {
        return this.preferredFont;
    }

    @Override
    public void setFont(Font font) {
        this.sourceFont = font;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
        this.fontChanged();
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
        this.fontChanged();
    }

    public Font getPreferredFont() {
        Font baseFont;
        Font font = baseFont = this.sourceFont == null ? super.getFont() : this.sourceFont;
        if (baseFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
            baseFont = this.getFontSupport().applyStyles(baseFont, attrs);
        }
        return baseFont;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public void setItemKey(String itemKey) {
        this.itemKey = itemKey;
    }

    public String getItemExpression() {
        return this.itemExpression;
    }

    public void setItemExpression(String itemExpression) {
        this.itemExpression = itemExpression;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void load() {
        this.model = null;
        this.modelObject = null;
        Binding binding = this.getBinding();
        Object bean = binding == null ? null : binding.getBean();
        try {
            Object handlerObj = null;
            String handler = this.getHandler();
            if (handler != null && handler.length() > 0) {
                handlerObj = UIControlUtil.getBeanValue(bean, handler);
            }
            if (handlerObj != null) {
                this.modelObject = handlerObj;
                this.model = new ObjectProxy().create(this.modelObject, RadioListModel.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.modelObject == null) {
            this.model = new EmptyRadioListModel();
            this.modelObject = this.model;
        }
    }

    @Override
    public void refresh() {
        block8: {
            boolean reload = !this.refreshed || this.isDynamic();
            try {
                if (reload) {
                    this.buildItems();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            Binding binding = this.getBinding();
            Object bean = binding == null ? null : binding.getBean();
            Object value = UIControlUtil.getBeanValue(bean, this.getName());
            int idx = this.indexOfItemKey(value);
            this.setSelectedIndex(idx);
            try {
                String visibleWhen = this.getVisibleWhen();
                if (visibleWhen == null || visibleWhen.length() <= 0) break block8;
                boolean b = false;
                try {
                    b = UIControlUtil.evaluateExprBoolean(bean, visibleWhen);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.setVisible(b);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!this.refreshed) {
            this.refreshed = true;
        }
        this.enableComponents(this.isEnabled());
        this.revalidate();
        this.repaint();
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public Map getInfo() {
        return null;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    private Object getBeanValue() {
        Object bean;
        String name = this.getName();
        if (name == null || name.length() == 0) {
            return null;
        }
        Binding binding = this.getBinding();
        Object object = bean = binding == null ? null : binding.getBean();
        if (bean == null) {
            return null;
        }
        return UIControlUtil.getBeanValue(bean, name);
    }

    @Override
    public ActionMessage getActionMessage() {
        if (this.actionMessage == null) {
            this.actionMessage = new ActionMessage();
        }
        return this.actionMessage;
    }

    @Override
    public void validateInput() {
        this.validateInput(this.getActionMessage());
    }

    public void validateInput(ActionMessage am) {
        am.clearMessages();
        this.getControlProperty().setErrorMessage(null);
        if (!this.isRequired()) {
            return;
        }
        Object value = this.getBeanValue();
        if (value == null || value.toString().length() == 0) {
            String caption = this.getCaption();
            if (caption == null) {
                caption = this.getName();
            }
            am.addMessage("1001", "{0} is required.", new Object[]{caption});
            if (am.hasMessages()) {
                this.getControlProperty().setErrorMessage(am.toString());
            }
        }
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    @Override
    public boolean isRequired() {
        return this.getControlProperty().isRequired();
    }

    @Override
    public void setRequired(boolean required) {
        this.getControlProperty().setRequired(required);
    }

    @Override
    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    @Override
    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.getControlProperty().setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    @Override
    protected void onselect(Object obj) {
        if (this.model == null) {
            return;
        }
        try {
            String skey = this.getItemKey();
            if (skey != null && skey.length() > 0) {
                obj = UIControlUtil.getBeanValue(obj, skey);
            }
            if (this.getCallbackMethod(this.modelObject, "onselect") == null) {
                Binding binding = this.getBinding();
                Object bean = binding.getBean();
                UIControlUtil.setBeanValue(bean, this.getName(), obj);
                EventQueue.invokeLater(new NotifyDependsRunnable(binding, this.getName(), obj));
            } else {
                EventQueue.invokeLater(new OnSelectRunnable(obj));
            }
        }
        catch (Throwable t) {
            MsgBox.err(t);
        }
    }

    private void buildItems() {
        List list = null;
        if (this.model != null) {
            int rows = -1;
            if (this.getGetterMethod(this.modelObject, "getRows") != null) {
                rows = this.model.getRows();
            }
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("_start", 0);
            params.put("_limit", rows < 0 ? 100 : rows);
            list = this.model.fetchList(params);
        }
        this.removeAll();
        if (list != null) {
            String expr = this.getItemExpression();
            for (Object o : list) {
                if (expr == null || expr.length() == 0) {
                    this.addItem(o == null ? "null" : o.toString(), o);
                    continue;
                }
                Object exprBean = this.createExpressionBean(o);
                Object result = UIControlUtil.evaluateExpr(exprBean, expr);
                this.addItem(result == null ? "null" : result.toString(), o);
            }
        }
    }

    private Object createExpressionBean(Object itemBean) {
        ExprBeanSupport beanSupport = new ExprBeanSupport(this.binding.getBean());
        beanSupport.setItem(this.getVarName(), itemBean);
        return beanSupport.createProxy();
    }

    private int indexOfItemKey(Object key) {
        String skey = this.getItemKey();
        List list = this.getUserObjects();
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (skey != null && skey.length() > 0) {
                o = UIControlUtil.getBeanValue(o, skey);
            }
            if (o == null && key == null) {
                return i;
            }
            if (o != null && o.equals(key)) {
                return i;
            }
            if (key == null || !key.equals(o)) continue;
            return i;
        }
        return -1;
    }

    private Method getCallbackMethod(Object obj, String name) {
        Method m2;
        if (obj == null || name == null) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        try {
            m2 = clazz.getMethod(name, Object[].class);
            if (m2 != null) {
                return m2;
            }
        }
        catch (Throwable m2) {
            // empty catch block
        }
        try {
            m2 = clazz.getMethod(name, Object.class);
            if (m2 != null) {
                return m2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private Method getGetterMethod(Object obj, String name) {
        if (obj == null || name == null) {
            return null;
        }
        try {
            Method m = obj.getClass().getMethod(name, new Class[0]);
            if (m != null) {
                return m;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private void fontChanged() {
        Font font = this.getFont();
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setFont(font);
        }
    }

    private class OnSelectRunnable
    implements Runnable {
        private Object value;

        OnSelectRunnable(Object value) {
            this.value = value;
        }

        @Override
        public void run() {
            try {
                XRadioList.this.model.onselect(this.value);
            }
            catch (Throwable t) {
                MsgBox.err(t);
            }
        }
    }

    private class NotifyDependsRunnable
    implements Runnable {
        private Binding binding;
        private String name;
        private Object value;

        NotifyDependsRunnable(Binding binding, String name, Object value) {
            this.binding = binding;
            this.name = name;
            this.value = value;
        }

        @Override
        public void run() {
            try {
                this.binding.getValueChangeSupport().notify(this.name, this.value);
                this.binding.notifyDepends(this.name);
            }
            catch (Throwable t) {
                MsgBox.err(t);
            }
        }
    }

    private class EmptyRadioListModel
    implements RadioListModel {
        private EmptyRadioListModel() {
        }

        @Override
        public int getRows() {
            return -1;
        }

        @Override
        public List fetchList(Map params) {
            return null;
        }

        @Override
        public void onselect(Object obj) {
        }
    }

    static interface RadioListModel {
        public int getRows();

        public List fetchList(Map var1);

        public void onselect(Object var1);
    }
}

