/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.LookupOpenerSupport;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.SubFormPanelModel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.framework.UIControllerContext;
import com.rameses.rcp.framework.UIControllerPanel;
import com.rameses.rcp.framework.UIViewPanel;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.BindingConnector;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UISubControl;
import com.rameses.rcp.util.ControlSupport;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.ValueUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class XSubFormPanel
extends JPanel
implements UISubControl,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private String handler;
    private String[] depends;
    private String visibleWhen;
    private int index;
    private boolean dynamic;
    private boolean multiForm;
    private JPanel multiPanel;
    private SubFormPanelModel model;
    private List<Opener> openers;
    private Object handlerObj;
    protected Binding binding;
    private int stretchWidth;
    private int stretchHeight;
    private List<Binding> subBindings = new ArrayList<Binding>();
    protected BindingConnector bindingConnector = new BindingConnector(this);
    protected List<SubFormContext> subFormItems = new ArrayList<SubFormContext>();
    protected List<Opener> currentOpeners = new ArrayList<Opener>();
    protected ControlProperty property = new ControlProperty();

    public XSubFormPanel() {
        super.setLayout(new BorderLayout());
        this.setOpaque(false);
        if (Beans.isDesignTime()) {
            this.setPreferredSize(new Dimension(40, 20));
            this.setBackground(Color.decode("#a0a0a0"));
            this.setOpaque(true);
        }
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (XSubFormPanel.this.binding != null) {
                    XSubFormPanel.this.bindingConnector.setParentBinding(XSubFormPanel.this.binding);
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                XSubFormPanel.this.bindingConnector.setParentBinding(null);
            }
        });
        new MouseEventSupport(this).install();
    }

    public XSubFormPanel(Opener o) {
        this();
        this.getOpeners().add(o);
        this.multiForm = false;
    }

    public XSubFormPanel(List<Opener> o) {
        this();
        this.openers = o;
        this.multiForm = true;
    }

    public List<Opener> getOpeners() {
        if (this.openers == null) {
            this.openers = new ArrayList<Opener>();
        }
        return this.openers;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    @Override
    public Component add(Component comp) {
        if (this.multiForm) {
            return this.multiPanel.add(comp);
        }
        return super.add(comp);
    }

    private Map createOpenerParams(Opener opener) {
        Map udfParams;
        Object o;
        HashMap openerParams = opener.getParams();
        if (openerParams == null) {
            openerParams = new HashMap();
            opener.setParams(openerParams);
        }
        HashMap props = new HashMap();
        props.putAll(openerParams);
        Object userObj = this.getClientProperty("UIControl.userObject");
        if (userObj instanceof Map && (o = ((Map)userObj).get("properties")) instanceof Map) {
            props.putAll((Map)o);
        }
        Map map = udfParams = this.model == null ? null : this.model.getOpenerParams(opener);
        if (udfParams != null) {
            props.putAll(udfParams);
        }
        return props;
    }

    public void refreshViews() {
        if (this.subFormItems == null || this.subFormItems.isEmpty()) {
            return;
        }
        for (SubFormContext ctx : this.subFormItems) {
            Opener opener;
            UIControllerContext uictx = ctx.getCurrentController();
            if (uictx == null || (opener = ctx.getOpener()) == null || opener.getController() == null) continue;
            Object o = opener.getHandle();
            ControlSupport.setProperties(o, this.createOpenerParams(opener));
            try {
                Binding viewBinding = uictx.getCurrentView().getBinding();
                if (viewBinding == null) continue;
                viewBinding.refresh();
                SwingUtilities.updateComponentTreeUI(ctx);
            }
            catch (Throwable t) {
                System.out.println("[WARN] error on binding refresh caused by " + t.getMessage());
            }
        }
    }

    @Override
    public void refresh() {
        this.refreshImpl(this.isDynamic());
    }

    private void refreshImpl(boolean dynamic) {
        String sval;
        if (dynamic) {
            this.model = new DefaultSubFormPanelModel(null);
            this.buildForm();
        }
        if ((sval = this.getVisibleWhen()) != null && sval.length() > 0) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(this.getBinding().getBean(), sval);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void load() {
        if (!this.dynamic) {
            this.buildForm();
        }
        this.bindingConnector.setParentBinding(this.binding);
    }

    protected void buildForm() {
        try {
            this.buildFormImpl();
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private void buildFormImpl() {
        Object value = null;
        if (this.getOpeners().size() > 0) {
            value = this.getOpeners();
        } else if (!ValueUtil.isEmpty((Object)this.getHandler())) {
            String shandler = this.getHandler();
            value = shandler.matches(".+:.+") ? LookupOpenerSupport.lookupOpener(shandler, new HashMap()) : UIControlUtil.getBeanValue(this.getBinding().getBean(), shandler);
        }
        SubFormPanelModel newModel = null;
        newModel = value instanceof SubFormPanelModel ? (SubFormPanelModel)value : new DefaultSubFormPanelModel(value);
        if (this.model != null && this.model.equals(newModel)) {
            this.refreshViews();
            return;
        }
        ArrayList<Opener> openers = new ArrayList<Opener>();
        this.handlerObj = newModel.getOpener();
        if (this.handlerObj != null) {
            if (this.handlerObj instanceof Collection) {
                for (Object o : (Collection)this.handlerObj) {
                    openers.add((Opener)o);
                }
            } else if (this.handlerObj.getClass().isArray()) {
                for (Object o : (Object[])this.handlerObj) {
                    openers.add((Opener)o);
                }
            } else if (this.handlerObj instanceof Opener) {
                openers.add((Opener)this.handlerObj);
            }
        }
        this.multiForm = openers.size() > 1;
        Set<Binding> connectorBindings = this.bindingConnector.getSubBindings();
        connectorBindings.clear();
        newModel.setProvider(new DefaultProviderImpl());
        this.model = newModel;
        if (openers.size() == 0) {
            this.removeAll();
            this.subFormItems.clear();
            SwingUtilities.updateComponentTreeUI(this);
            return;
        }
        if (!this.multiForm && this.currentOpeners.size() > 0 && openers.get(0) == this.currentOpeners.get(0) && !this.subFormItems.isEmpty()) {
            SubFormContext sfc = this.subFormItems.get(0);
            sfc.renderView();
            connectorBindings.addAll(this.getSubBindings());
        } else {
            this.removeAll();
            this.subFormItems.clear();
            this.currentOpeners.clear();
            this.currentOpeners.addAll(openers);
            SwingUtilities.updateComponentTreeUI(this);
            if (this.multiForm) {
                this.multiPanel = new JPanel();
                this.multiPanel.setOpaque(false);
                this.multiPanel.setLayout(new BoxLayout(this.multiPanel, 1));
                super.add((Component)this.multiPanel, "North");
            }
            for (Opener opener : openers) {
                this.addOpener(opener);
            }
            connectorBindings.addAll(this.getSubBindings());
        }
    }

    private void addOpener(Opener opener) {
        Object props;
        Object userObj;
        HashMap openerParams = opener.getParams();
        if (openerParams == null) {
            openerParams = new HashMap();
            opener.setParams(openerParams);
        }
        if ((userObj = this.getClientProperty("UIControl.userObject")) instanceof Map && (props = ((Map)userObj).get("properties")) instanceof Map) {
            openerParams.putAll((Map)props);
        }
        UIController caller = this.binding.getController();
        opener.setCaller(caller);
        opener = ControlSupport.initOpener(opener, caller);
        UIController controller = opener.getController();
        if (controller == null) {
            throw new IllegalStateException("Cannot find controller " + opener.getName());
        }
        UIControllerContext uic = new UIControllerContext(controller);
        if (!ValueUtil.isEmpty((Object)opener.getOutcome())) {
            uic.setCurrentView(opener.getOutcome());
        }
        SubFormContext sfc = new SubFormContext(uic, opener);
        this.subFormItems.add(sfc);
        this.add(sfc);
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dynamic", this.isDynamic());
        map.put("handler", this.getHandler());
        map.put("handlerObject", this.getHandlerObject());
        map.put("visibleWhen", this.getVisibleWhen());
        return map;
    }

    @Override
    public boolean focusFirstInput() {
        for (Binding b : this.getSubBindings()) {
            if (!b.focusFirstInput()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getHandlerObject() {
        return this.handlerObj;
    }

    public void setHandlerObject(Object handlerObj) {
        this.handlerObj = handlerObj;
        if (handlerObj instanceof Opener) {
            this.getOpeners().add((Opener)handlerObj);
        }
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0).getPreferredSize();
        }
        return super.getPreferredSize();
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    public List<Binding> getSubBindings() {
        ArrayList<Binding> list = new ArrayList<Binding>();
        for (SubFormContext sfc : this.subFormItems) {
            UIViewPanel uiv;
            UIControllerContext ucc;
            if (sfc == null || (ucc = sfc.getCurrentController()) == null || (uiv = ucc.getCurrentView()) == null) continue;
            list.add(uiv.getBinding());
        }
        return list;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    @Override
    public String getCaption() {
        if (this.property.getCaption() == null) {
            if (!ValueUtil.isEmpty((Object)this.getName())) {
                return this.getName();
            }
            return this.handler;
        }
        return this.property.getCaption();
    }

    public void setCaption(String caption) {
        this.property.setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.property.getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.property.setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.property.getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.property.setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.property.isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.property.setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.property.getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.property.setCaptionFont(f);
    }

    public Insets getCellPadding() {
        return this.property.getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.property.setCellPadding(padding);
    }

    @Override
    public ControlProperty getControlProperty() {
        return this.property;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    private class DefaultProviderImpl
    implements SubFormPanelModel.Provider {
        XSubFormPanel root;

        private DefaultProviderImpl() {
            this.root = XSubFormPanel.this;
        }

        @Override
        public Object getBinding() {
            return this.root.getBinding();
        }

        @Override
        public void refresh() {
            this.root.refresh();
            if (!this.root.isDynamic()) {
                this.root.refreshViews();
            }
        }

        @Override
        public void reload() {
            this.root.refreshImpl(true);
        }
    }

    private class DefaultSubFormPanelModel
    extends SubFormPanelModel {
        private Object value;

        DefaultSubFormPanelModel(Object value) {
            this.value = value;
        }

        @Override
        public Object getOpener() {
            return this.value;
        }
    }

    protected class SubFormContext
    extends UIControllerPanel {
        XSubFormPanel root;
        private Opener opener;

        SubFormContext(UIControllerContext controller, Opener opener) {
            super(controller);
            this.root = XSubFormPanel.this;
            this.opener = opener;
            this.setOpaque(false);
            this.setName(this.root.getName());
        }

        public Opener getOpener() {
            return this.opener;
        }

        @Override
        public void renderView() {
            super.renderView();
            Set<Binding> bindings = this.root.bindingConnector.getSubBindings();
            bindings.clear();
            bindings.addAll(this.root.getSubBindings());
        }
    }
}

